/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.alert;

import java.util.Collections;
import java.util.Set;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.alert.PublicPhdMissingCandidacyValidationAlert_Base;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;

public class PublicPhdMissingCandidacyValidationAlert
extends PublicPhdMissingCandidacyValidationAlert_Base {
    private static final int INTERVAL = 15;

    private PublicPhdMissingCandidacyValidationAlert() {
    }

    public PublicPhdMissingCandidacyValidationAlert(PhdIndividualProgramProcess process2) {
        this();
        this.init(process2, this.generateSubject(process2), this.generateBody(process2));
    }

    private MultiLanguageString generateSubject(PhdIndividualProgramProcess process2) {
        return process2.getCandidacyProcess().getPublicPhdCandidacyPeriod().getEmailMessageSubjectForMissingCandidacyValidation(process2);
    }

    private MultiLanguageString generateBody(PhdIndividualProgramProcess process2) {
        return process2.getCandidacyProcess().getPublicPhdCandidacyPeriod().getEmailMessageBodyForMissingCandidacyValidation(process2);
    }

    protected void generateMessage() {
        new Message((Sender)((Object)this.getSender()), null, Collections.emptyList(), this.buildMailSubject(), this.buildMailBody(), this.getEmail());
    }

    private Set<String> getEmail() {
        return Collections.singleton(this.getProcess().getPerson().getInstitutionalOrDefaultEmailAddressValue());
    }

    public String getDescription() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)String.format("message.phd.missing.candidacy.validation.alert", 15), (String[])new String[0]);
    }

    protected boolean isToFire() {
        int days = Days.daysBetween((ReadableInstant)this.calculateStartDate().toDateMidnight(), (ReadableInstant)new LocalDate().toDateMidnight()).getDays();
        return days >= 15;
    }

    private LocalDate calculateStartDate() {
        return this.getFireDate() != null ? this.getFireDate().toLocalDate() : this.getCandidacyProcess().getWhenCreated().toLocalDate();
    }

    private PhdProgramCandidacyProcess getCandidacyProcess() {
        return this.getProcess().getCandidacyProcess();
    }

    protected boolean isToDiscard() {
        return this.getCandidacyProcess().isValidatedByCandidate() || this.candidacyPeriodIsOver();
    }

    private boolean candidacyPeriodIsOver() {
        return new DateTime().isAfter((ReadableInstant)this.getCandidacyProcess().getPublicPhdCandidacyPeriod().getEnd());
    }

    public boolean isToSendMail() {
        return true;
    }

    public boolean isSystemAlert() {
        return true;
    }
}

