/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public abstract class PhdElementsList<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<T> types = new TreeSet<T>();

    protected PhdElementsList() {
    }

    protected PhdElementsList(String types) {
        this.types.addAll(this.convertToSet(types));
    }

    protected PhdElementsList(Collection<T> types) {
        this.types.addAll(types);
    }

    private Set<T> convertToSet(String types) {
        HashSet<T> result = new HashSet<T>();
        for (String each : types.split(",")) {
            String valueToParse = each.trim();
            if (StringUtils.isEmpty((String)valueToParse)) continue;
            result.add(this.convertElementToSet(valueToParse));
        }
        return result;
    }

    protected abstract T convertElementToSet(String var1);

    private String convertToString(Set<T> types) {
        StringBuilder result = new StringBuilder();
        for (T each : types) {
            result.append(this.convertElementToString(each)).append(",");
        }
        if (result.length() > 0 && result.charAt(result.length() - 1) == ',') {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    protected abstract String convertElementToString(T var1);

    public Set<T> getTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    public Set<T> getSortedTypes() {
        return Collections.unmodifiableSet(new TreeSet<T>(this.types));
    }

    public String toString() {
        return this.convertToString(this.types);
    }

    public PhdElementsList<T> addAccessTypes(T ... types) {
        PhdElementsList<T> result = this.createNewInstance();
        result.types.addAll(this.getTypes());
        result.types.addAll(Arrays.asList(types));
        return result;
    }

    protected abstract PhdElementsList<T> createNewInstance();
}

