/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityType;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.PartyType;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.ScientificCouncilUnit_Base;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitClassification;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.YearMonthDay;

public class ScientificCouncilUnit
extends ScientificCouncilUnit_Base {
    public ScientificCouncilUnit() {
        super.setType(PartyTypeEnum.SCIENTIFIC_COUNCIL);
    }

    public void setType(PartyTypeEnum partyTypeEnum) {
        throw new DomainException("unit.impossible.set.type", new String[0]);
    }

    protected List<Group> getDefaultGroups() {
        List groups = super.getDefaultGroups();
        groups.add(RoleType.SCIENTIFIC_COUNCIL.actualGroup());
        return groups;
    }

    public static ScientificCouncilUnit getScientificCouncilUnit() {
        Set<Party> parties = PartyType.getPartiesSet(PartyTypeEnum.SCIENTIFIC_COUNCIL);
        return parties.isEmpty() ? null : (ScientificCouncilUnit)((Object)parties.iterator().next());
    }

    public static ScientificCouncilUnit createScientificCouncilUnit(MultiLanguageString name, String unitNameCard, Integer costCenterCode, String acronym, YearMonthDay beginDate, YearMonthDay endDate, Unit parentUnit, AccountabilityType accountabilityType, String webAddress, UnitClassification classification, Boolean canBeResponsibleOfSpaces, Space campus) {
        ScientificCouncilUnit scu = new ScientificCouncilUnit();
        scu.init(name, unitNameCard, costCenterCode, acronym, beginDate, endDate, webAddress, classification, null, canBeResponsibleOfSpaces, campus);
        scu.addParentUnit(parentUnit, accountabilityType);
        return scu;
    }
}

