/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import java.util.Comparator;
import java.util.Date;
import jvstm.cps.ConsistencyPredicate;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityType;
import org.fenixedu.academic.domain.organizationalStructure.Accountability_Base;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.DomainObject;

public class Accountability
extends Accountability_Base {
    protected Accountability() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public Accountability(Party parentParty, Party childParty, AccountabilityType accountabilityType) {
        this();
        this.setAccountabilityType(accountabilityType);
        this.setBeginDate(new YearMonthDay());
        this.setParentParty(parentParty);
        this.setChildParty(childParty);
    }

    public void delete() {
        super.setAccountabilityType(null);
        super.setChildParty(null);
        super.setParentParty(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public static Comparator<Accountability> getComparatorByBeginDate() {
        return new Comparator<Accountability>(){

            @Override
            public int compare(Accountability left, Accountability right) {
                int result = left.getBeginDate().compareTo((ReadablePartial)right.getBeginDate());
                return result == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)left, (DomainObject)right) : result;
            }
        };
    }

    public boolean belongsToPeriod(YearMonthDay begin, YearMonthDay end) {
        return !(end != null && this.getBeginDate().isAfter((ReadablePartial)end) || this.getEndDate() != null && this.getEndDate().isBefore((ReadablePartial)begin));
    }

    public boolean isActive(YearMonthDay currentDate) {
        return this.belongsToPeriod(currentDate, currentDate);
    }

    public boolean isActive() {
        return this.isActive(new YearMonthDay());
    }

    public boolean isFinished() {
        return this.getEndDate() != null && this.getEndDate().isBefore((ReadablePartial)new YearMonthDay());
    }

    public LocalDate getBeginLocalDate() {
        YearMonthDay result = this.getBeginDate();
        return result == null ? null : result.toLocalDate();
    }

    public void setBeginLocalDate(LocalDate input) {
        super.setBeginDate(input == null ? null : new YearMonthDay((Object)input));
    }

    public LocalDate getEndLocalDate() {
        YearMonthDay result = this.getEndDate();
        return result == null ? null : result.toLocalDate();
    }

    public void setEndLocalDate(LocalDate input) {
        super.setEndDate(input == null ? null : new YearMonthDay((Object)input));
    }

    public Date getBeginDateInDateType() {
        return this.getBeginDate() != null ? this.getBeginDate().toDateTimeAtCurrentTime().toDate() : null;
    }

    public Date getEndDateInDateType() {
        return this.getEndDate() != null ? this.getEndDate().toDateTimeAtCurrentTime().toDate() : null;
    }

    public void setChildParty(Party childParty) {
        if (childParty == null) {
            throw new DomainException("error.accountability.inexistent.childParty", new String[0]);
        }
        super.setChildParty(childParty);
    }

    public void setParentParty(Party parentParty) {
        if (parentParty == null) {
            throw new DomainException("error.accountability.inexistent.parentParty", new String[0]);
        }
        super.setParentParty(parentParty);
    }

    public void setAccountabilityType(AccountabilityType accountabilityType) {
        if (accountabilityType == null) {
            throw new DomainException("error.accountability.inexistent.accountabilityType", new String[0]);
        }
        super.setAccountabilityType(accountabilityType);
    }

    @ConsistencyPredicate
    protected boolean checkDateInterval() {
        YearMonthDay start = this.getBeginDate();
        YearMonthDay end = this.getEndDate();
        return start != null && (end == null || !start.isAfter((ReadablePartial)end));
    }
}

