/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.gratuity.masterDegree;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.fenixedu.academic.domain.gratuity.SibsPaymentStatus;
import org.fenixedu.academic.domain.gratuity.SibsPaymentType;
import org.fenixedu.academic.domain.gratuity.masterDegree.SibsPaymentFile;
import org.fenixedu.academic.domain.gratuity.masterDegree.SibsPaymentFileEntry_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;

public class SibsPaymentFileEntry
extends SibsPaymentFileEntry_Base {
    public SibsPaymentFileEntry() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public SibsPaymentFileEntry(Integer year, Integer studentNumber, SibsPaymentType paymentType, Date transactionDate, Double payedValue, SibsPaymentFile sibsPaymentFile, SibsPaymentStatus paymentStatus) {
        this();
        this.setYear(year);
        this.setStudentNumber(studentNumber);
        this.setPaymentType(paymentType);
        this.setTransactionDate(transactionDate);
        this.setPayedValue(payedValue);
        this.setSibsPaymentFile(sibsPaymentFile);
        this.setPaymentStatus(paymentStatus);
    }

    public static List<SibsPaymentFileEntry> readNonProcessed() {
        ArrayList<SibsPaymentFileEntry> result = new ArrayList<SibsPaymentFileEntry>();
        for (SibsPaymentFileEntry sibsPaymentFileEntry : Bennu.getInstance().getSibsPaymentFileEntrysSet()) {
            if (sibsPaymentFileEntry.getPaymentStatus() == SibsPaymentStatus.PROCESSED_PAYMENT) continue;
            result.add(sibsPaymentFileEntry);
        }
        return result;
    }

    public static List<SibsPaymentFileEntry> readByYearAndStudentNumberAndPaymentType(Integer year, Integer studentNumber, SibsPaymentType sibsPaymentType) {
        ArrayList<SibsPaymentFileEntry> result = new ArrayList<SibsPaymentFileEntry>();
        for (SibsPaymentFileEntry sibsPaymentFileEntry : Bennu.getInstance().getSibsPaymentFileEntrysSet()) {
            if (!sibsPaymentFileEntry.getYear().equals(year) || !sibsPaymentFileEntry.getStudentNumber().equals(studentNumber) || sibsPaymentFileEntry.getPaymentType() != sibsPaymentType) continue;
            result.add(sibsPaymentFileEntry);
        }
        return result;
    }

    public static List<SibsPaymentFileEntry> readByYearAndStudentNumberAndPaymentTypeExceptFileEntry(SibsPaymentFileEntry paymentFileEntry) {
        ArrayList<SibsPaymentFileEntry> result = new ArrayList<SibsPaymentFileEntry>();
        for (SibsPaymentFileEntry sibsPaymentFileEntry : Bennu.getInstance().getSibsPaymentFileEntrysSet()) {
            if (sibsPaymentFileEntry == paymentFileEntry || !sibsPaymentFileEntry.getYear().equals(paymentFileEntry.getYear()) || !sibsPaymentFileEntry.getStudentNumber().equals(paymentFileEntry.getStudentNumber()) || !sibsPaymentFileEntry.getPaymentType().equals((Object)paymentFileEntry.getPaymentType())) continue;
            result.add(sibsPaymentFileEntry);
        }
        return result;
    }

    @Deprecated
    public Date getTransactionDate() {
        DateTime dt = this.getTransactionDateDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setTransactionDate(Date date) {
        if (date == null) {
            this.setTransactionDateDateTime(null);
        } else {
            this.setTransactionDateDateTime(new DateTime(date.getTime()));
        }
    }
}

