/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.exceptions.DomainException;

public class BibliographicReferences
implements Serializable {
    private static final long serialVersionUID = 1489616281219374804L;
    private final List<BibliographicReference> bibliographicReferences;

    public BibliographicReferences() {
        this.bibliographicReferences = ImmutableList.of();
    }

    public BibliographicReferences(List<BibliographicReference> refs) {
        this.bibliographicReferences = ImmutableList.copyOf(refs);
    }

    public SortedSet<BibliographicReference> getBibliographicReferencesSortedByOrder() {
        return new TreeSet<BibliographicReference>(this.bibliographicReferences);
    }

    public List<BibliographicReference> getBibliographicReferencesList() {
        return this.bibliographicReferences;
    }

    public int getBibliographicReferencesListCount() {
        return this.bibliographicReferences.size();
    }

    public BibliographicReference getBibliographicReference(int oid) {
        return this.bibliographicReferences.get(oid);
    }

    public BibliographicReferences with(String year, String title, String authors, String reference, String url, BibliographicReferenceType type) {
        ArrayList<BibliographicReference> refs = new ArrayList<BibliographicReference>(this.bibliographicReferences);
        refs.add(new BibliographicReference(year, title, authors, reference, url, type, refs.size()));
        return new BibliographicReferences(refs);
    }

    public BibliographicReferences with(String year, String title, String authors, String reference, String url, BibliographicReferenceType type, int order) {
        ArrayList<BibliographicReference> refs = new ArrayList<BibliographicReference>(this.bibliographicReferences);
        refs.add(order, new BibliographicReference(year, title, authors, reference, url, type, order));
        return new BibliographicReferences(refs);
    }

    public BibliographicReferences replacing(int index, String year, String title, String authors, String reference, String url, BibliographicReferenceType type) {
        ArrayList<BibliographicReference> refs = new ArrayList<BibliographicReference>(this.bibliographicReferences);
        refs.set(index, new BibliographicReference(year, title, authors, reference, url, type, index));
        return new BibliographicReferences(refs);
    }

    public BibliographicReferences without(int index) {
        ArrayList<BibliographicReference> refs = new ArrayList<BibliographicReference>(this.bibliographicReferences);
        refs.remove(index);
        BibliographicReferences.reOrderBibliographicReferences(refs);
        return new BibliographicReferences(refs);
    }

    public BibliographicReferences movingBibliographicReference(int oldPosition, int newPosition) {
        try {
            if (this.validPositions(oldPosition, newPosition)) {
                BibliographicReference bibliographicReference = this.getBibliographicReference(oldPosition);
                ArrayList<BibliographicReference> refs = new ArrayList<BibliographicReference>(this.bibliographicReferences);
                refs.remove(oldPosition);
                refs.add(newPosition, bibliographicReference);
                BibliographicReferences.reOrderBibliographicReferences(refs);
                return new BibliographicReferences(refs);
            }
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw new DomainException("bibliographicReferences.invalid.reference.positions", new String[0]);
        }
    }

    private boolean validPositions(int oldPosition, int newPosition) {
        return oldPosition != newPosition && newPosition >= 0 && newPosition != this.getBibliographicReferencesListCount();
    }

    private static void reOrderBibliographicReferences(List<BibliographicReference> refs) {
        for (int i = 0; i < refs.size(); ++i) {
            refs.set(i, refs.get(i).withOrder(i));
        }
    }

    public List<BibliographicReference> getMainBibliographicReferences() {
        return this.bibliographicReferences.stream().filter(BibliographicReference::isMain).collect(Collectors.toList());
    }

    public List<BibliographicReference> getSecondaryBibliographicReferences() {
        return this.bibliographicReferences.stream().filter(BibliographicReference::isSecondary).collect(Collectors.toList());
    }

    public static enum BibliographicReferenceType {
        MAIN,
        SECONDARY;


        public String getName() {
            return this.name();
        }
    }

    public static class BibliographicReference
    implements Comparable<BibliographicReference>,
    Serializable {
        private static final long serialVersionUID = 7998864914358693747L;
        private String year;
        private String title;
        private String authors;
        private String reference;
        private String url;
        private BibliographicReferenceType type;
        private int order;

        public BibliographicReference() {
        }

        public BibliographicReference(String year, String title, String authors, String reference, String url, BibliographicReferenceType type, int order) {
            if (Strings.isNullOrEmpty((String)title) || Strings.isNullOrEmpty((String)authors)) {
                throw new IllegalArgumentException("Title and author cannot be empty!");
            }
            this.year = year;
            this.title = title;
            this.authors = authors;
            this.reference = reference;
            this.url = url;
            this.type = type;
            this.order = order;
        }

        public BibliographicReference withOrder(int newOrder) {
            return new BibliographicReference(this.year, this.title, this.authors, this.reference, this.url, this.type, newOrder);
        }

        public String getAuthors() {
            return this.authors;
        }

        public String getReference() {
            return this.reference;
        }

        public String getTitle() {
            return this.title;
        }

        public BibliographicReferenceType getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url == null || this.url.length() == 0 || this.url.equalsIgnoreCase("http://") ? null : this.url;
        }

        public String getYear() {
            return this.year;
        }

        public int getOrder() {
            return this.order;
        }

        @Override
        public int compareTo(BibliographicReference bibliographicReference) {
            return this.getOrder() - bibliographicReference.getOrder();
        }

        public boolean isMain() {
            return this.getType() == BibliographicReferenceType.MAIN;
        }

        public boolean isSecondary() {
            return this.getType() == BibliographicReferenceType.SECONDARY;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.year).append(" || ");
            result.append(this.title).append(" || ");
            result.append(this.authors).append(" || ");
            result.append(this.reference).append(" || ");
            result.append(this.url).append("\n");
            return result.toString();
        }
    }
}

