/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutorFactory;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleLevel;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.joda.time.YearMonthDay;

public abstract class CurricularRuleNotPersistent
implements ICurricularRule {
    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        CurricularRuleNotPersistent curricularRuleNotPersistent = null;
        if (!(obj instanceof CurricularRuleNotPersistent)) {
            return false;
        }
        curricularRuleNotPersistent = (CurricularRuleNotPersistent)obj;
        return this.getDegreeModuleToApplyRule() == curricularRuleNotPersistent.getDegreeModuleToApplyRule() && this.getCurricularRuleType() == curricularRuleNotPersistent.getCurricularRuleType();
    }

    public int hashCode() {
        StringBuilder builder = new StringBuilder();
        if (this.getDegreeModuleToApplyRule() != null) {
            builder.append(String.valueOf(this.getDegreeModuleToApplyRule().hashCode()));
            builder.append('@');
        }
        builder.append(String.valueOf(this.getCurricularRuleType().hashCode()));
        return builder.toString().hashCode();
    }

    @Override
    public boolean appliesToContext(Context context) {
        return context == null || this.appliesToCourseGroup(context.getParentCourseGroup());
    }

    @Override
    public boolean appliesToCourseGroup(CourseGroup courseGroup) {
        return this.getContextCourseGroup() == null || this.getContextCourseGroup() == courseGroup;
    }

    @Override
    public boolean hasContextCourseGroup() {
        return this.getContextCourseGroup() != null;
    }

    @Override
    public boolean hasCurricularRuleType(CurricularRuleType ruleType) {
        return this.getCurricularRuleType() == ruleType;
    }

    @Override
    public boolean isCompositeRule() {
        return this.getCurricularRuleType() == null;
    }

    @Override
    public boolean isValid(ExecutionSemester executionSemester) {
        return this.getBegin().isBeforeOrEquals(executionSemester) && (this.getEnd() == null || this.getEnd().isAfterOrEquals(executionSemester));
    }

    @Override
    public boolean isValid(ExecutionYear executionYear) {
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            if (!this.isValid(executionSemester)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public boolean isActive() {
        return this.getEnd() == null || this.getEnd().containsDay(new YearMonthDay());
    }

    @Override
    public RuleResult evaluate(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return CurricularRuleExecutorFactory.findExecutor(this).execute(this, sourceDegreeModuleToEvaluate, enrolmentContext);
    }

    @Override
    public RuleResult verify(VerifyRuleLevel level, EnrolmentContext enrolmentContext, DegreeModule degreeModuleToVerify, CourseGroup parentCourseGroup) {
        return this.createVerifyRuleExecutor().verify(this, level, enrolmentContext, degreeModuleToVerify, parentCourseGroup);
    }
}

