/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.serviceRequests;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.DegreeFinalizationCertificateRequestWithCeilingInTotalAmountForUnitsPR_Base;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class DegreeFinalizationCertificateRequestWithCeilingInTotalAmountForUnitsPR
extends DegreeFinalizationCertificateRequestWithCeilingInTotalAmountForUnitsPR_Base {
    private DegreeFinalizationCertificateRequestWithCeilingInTotalAmountForUnitsPR() {
    }

    public DegreeFinalizationCertificateRequestWithCeilingInTotalAmountForUnitsPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money baseAmount, Money amountPerUnit, Money amountPerPage, Money maximumAmount) {
        this();
        this.init(EntryType.DEGREE_FINALIZATION_CERTIFICATE_REQUEST_FEE, EventType.DEGREE_FINALIZATION_CERTIFICATE_REQUEST, startDate, endDate, serviceAgreementTemplate, baseAmount, amountPerUnit, amountPerPage, maximumAmount);
    }

    public Money getAmountForUnits(Integer numberOfUnits) {
        if (numberOfUnits <= 1) {
            return Money.ZERO;
        }
        Money totalAmountOfUnits = this.getAmountPerUnit().multiply(new BigDecimal(numberOfUnits - 1));
        if (this.getMaximumAmount().greaterThan(Money.ZERO) && totalAmountOfUnits.greaterThan(this.getMaximumAmount())) {
            totalAmountOfUnits = this.getMaximumAmount();
        }
        return totalAmountOfUnits;
    }

    public DegreeFinalizationCertificateRequestWithCeilingInTotalAmountForUnitsPR edit(Money baseAmount, Money amountPerUnit, Money amountPerPage, Money maximumAmount) {
        this.deactivate();
        return new DegreeFinalizationCertificateRequestWithCeilingInTotalAmountForUnitsPR(new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), baseAmount, amountPerUnit, amountPerPage, maximumAmount);
    }
}

