/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.AcademicEventExemption;
import org.fenixedu.academic.domain.accounting.postingRules.BaseAmountPlusAmountPerPagePR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;

public abstract class BaseAmountPlusAmountPerPagePR
extends BaseAmountPlusAmountPerPagePR_Base {
    protected BaseAmountPlusAmountPerPagePR() {
    }

    protected void init(EntryType entryType, EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money baseAmount, Money amountPerPage) {
        super.init(entryType, eventType, startDate, endDate, serviceAgreementTemplate);
        this.checkParameters(baseAmount, amountPerPage);
        super.setBaseAmount(baseAmount);
        super.setAmountPerPage(amountPerPage);
    }

    private void checkParameters(Money baseAmount, Money amountPerPage) {
        if (baseAmount == null) {
            throw new DomainException("error.accounting.postingRules.BaseAmountPlusAmountPerUnitGreaterThanOnePR.baseAmount.cannot.be.null", new String[0]);
        }
        if (amountPerPage == null) {
            throw new DomainException("error.accounting.postingRules.BaseAmountPlusAmountPerUnitGreaterThanOnePR.amountPerPage.cannot.be.null", new String[0]);
        }
    }

    public void setBaseAmount(Money baseAmount) {
        throw new DomainException("error.accounting.postingRules.BaseAmountPlusAmountPerUnitGreaterThanOnePR.cannot.modify.baseAmount", new String[0]);
    }

    public void setAmountPerPage(Money amountPerPage) {
        throw new DomainException("error.accounting.postingRules.BaseAmountPlusAmountPerUnitGreaterThanOnePR.cannot.modify.amountPerUnit", new String[0]);
    }

    public List<EntryDTO> calculateEntries(Event event, DateTime when) {
        return Collections.singletonList(new EntryDTO(this.getEntryType(), event, this.calculateTotalAmountToPay(event, when), event.getPayedAmount(), event.calculateAmountToPay(when), event.getDescriptionForEntryType(this.getEntryType()), event.calculateAmountToPay(when)));
    }

    protected Set<AccountingTransaction> internalProcess(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        if (entryDTOs.size() != 1) {
            throw new DomainException("error.accounting.postingRules.BaseAmountPlusAmountPerUnitGreaterThanOnePR.invalid.number.of.entryDTOs", new String[0]);
        }
        EntryDTO entryDTO = entryDTOs.iterator().next();
        this.checkIfCanAddAmount(entryDTO.getAmountToPay(), event, transactionDetail.getWhenRegistered());
        return Collections.singleton(this.makeAccountingTransaction(user, event, fromAccount, toAccount, entryDTO.getEntryType(), entryDTO.getAmountToPay(), transactionDetail));
    }

    private void checkIfCanAddAmount(Money amountToPay, Event event, DateTime when) {
        if (amountToPay.compareTo(this.calculateTotalAmountToPay(event, when)) != 0) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.postingRules.BaseAmountPlusAmountPerUnitGreaterThanOnePR.amount.being.payed.must.match.amount.to.pay", event.getDescriptionForEntryType(this.getEntryType()));
        }
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        Money result = this.isUrgent(event) ? this.getBaseAmount().multiply(BigDecimal.valueOf(2.0)) : this.getBaseAmount();
        return result.add(this.getAmountForPages(event));
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        if (!event.getExemptionsSet().isEmpty()) {
            Set<Exemption> exemptions = event.getExemptionsSet();
            for (Exemption exemption : exemptions) {
                AcademicEventExemption academicEventExemption = (AcademicEventExemption)((Object)exemption);
                amountToPay = amountToPay.subtract(academicEventExemption.getValue());
            }
        }
        if (amountToPay.isNegative()) {
            return Money.ZERO;
        }
        return amountToPay;
    }

    protected abstract boolean isUrgent(Event var1);

    protected abstract Money getAmountForPages(Event var1);
}

