/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.ServiceAgreement;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplatePaymentPlan;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public abstract class ServiceAgreementTemplate
extends ServiceAgreementTemplate_Base {
    protected ServiceAgreementTemplate() {
        super.setRootDomainObject(Bennu.getInstance());
        super.setCreationDate(new DateTime());
    }

    public Set<PostingRule> getPostingRulesSet() {
        return Collections.unmodifiableSet(super.getPostingRulesSet());
    }

    public void removePostingRules(PostingRule postingRules) {
        super.removePostingRules(postingRules);
    }

    public void setCreationDate(DateTime creationDate) {
        throw new DomainException("error.accounting.agreement.ServiceAgreementTemplate.cannot.modify.creationDate", new String[0]);
    }

    public Set<PostingRule> getActivePostingRules() {
        return this.getActivePostingRules(new DateTime());
    }

    public Set<PostingRule> getActivePostingRules(DateTime when) {
        HashSet<PostingRule> activePostingRules = new HashSet<PostingRule>();
        for (PostingRule postingRule : this.getPostingRulesSet()) {
            if (!postingRule.isActiveForDate(when)) continue;
            activePostingRules.add(postingRule);
        }
        return activePostingRules;
    }

    public Set<PostingRule> getActiveVisiblePostingRules() {
        return this.getActiveVisiblePostingRules(new DateTime());
    }

    public Set<PostingRule> getActiveVisiblePostingRules(DateTime when) {
        HashSet<PostingRule> result = new HashSet<PostingRule>();
        for (PostingRule postingRule : this.getPostingRulesSet()) {
            if (!postingRule.isActiveForDate(when) || !postingRule.isVisible()) continue;
            result.add(postingRule);
        }
        return result;
    }

    public PostingRule findPostingRuleByEventType(EventType eventType) {
        return this.findPostingRuleByEventTypeAndDate(eventType, new DateTime());
    }

    public PostingRule findPostingRuleByEventTypeAndDate(EventType eventType, DateTime when) {
        PostingRule postingRule = this.getPostingRuleByEventTypeAndDate(eventType, when);
        if (postingRule == null) {
            // empty if block
        }
        return postingRule;
    }

    public String getEnumerationResourcesString(String name) {
        return BundleUtil.getString((String)"resources.EnumerationResources", (String)name, (String[])new String[0]);
    }

    public PostingRule findPostingRuleBy(EventType eventType, DateTime startDate, DateTime endDate) {
        ArrayList<PostingRule> activePostingRulesInPeriod = new ArrayList<PostingRule>();
        for (PostingRule postingRule : this.getPostingRulesSet()) {
            if (!postingRule.isActiveForPeriod(startDate, endDate) || postingRule.getEventType() != eventType) continue;
            activePostingRulesInPeriod.add(postingRule);
        }
        return activePostingRulesInPeriod.isEmpty() ? null : Collections.max(activePostingRulesInPeriod, PostingRule.COMPARATOR_BY_START_DATE);
    }

    public PostingRule getPostingRuleByEventTypeAndDate(EventType eventType, DateTime when) {
        for (PostingRule postingRule : this.getActivePostingRules(when)) {
            if (postingRule.getEventType() != eventType) continue;
            return postingRule;
        }
        return null;
    }

    public boolean hasPostingRuleFor(EventType eventType) {
        return this.hasPostingRuleFor(eventType, new DateTime());
    }

    public boolean hasPostingRuleFor(EventType eventType, DateTime when) {
        return this.getPostingRuleByEventTypeAndDate(eventType, when) != null;
    }

    public boolean containsPostingRule(EventType eventType, DateTime when) {
        return this.getPostingRuleByEventTypeAndDate(eventType, when) != null;
    }

    public boolean hasServiceAgreementForPerson(Person person) {
        return this.getServiceAgreementForPerson(person) != null;
    }

    public ServiceAgreement getServiceAgreementForPerson(Person person) {
        for (ServiceAgreement serviceAgreement : this.getServiceAgreementsSet()) {
            if (serviceAgreement.getPerson() != person) continue;
            return serviceAgreement;
        }
        return null;
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getServiceAgreementsSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.accounting.serviceAgreementTemplates.ServiceAgreementTemplate.cannot.be.deleted", (String[])new String[0]));
        }
        if (!this.getPostingRulesSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.accounting.serviceAgreementTemplates.ServiceAgreementTemplate.cannot.be.deleted", (String[])new String[0]));
        }
    }

    public final void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public ServiceAgreementTemplatePaymentPlan getDefaultPaymentPlan(ExecutionYear executionYear) {
        for (ServiceAgreementTemplatePaymentPlan paymentPlan : this.getPaymentPlansSet()) {
            if (paymentPlan.getExecutionYear() != executionYear || !paymentPlan.isDefault()) continue;
            return paymentPlan;
        }
        return null;
    }

    public boolean hasDefaultPaymentPlan(ExecutionYear executionYear) {
        return this.getDefaultPaymentPlan(executionYear) != null;
    }

    public boolean hasActivePostingRuleFor(EventType eventType) {
        return this.getPostingRuleByEventTypeAndDate(eventType, new DateTime()) != null;
    }

    public Set<PostingRule> getAllPostingRulesFor(EventType eventType) {
        HashSet<PostingRule> result = new HashSet<PostingRule>();
        for (PostingRule postingRule : super.getPostingRulesSet()) {
            if (postingRule.getEventType() != eventType) continue;
            result.add(postingRule);
        }
        return result;
    }
}

