/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.accessControl.FenixGroup;
import org.fenixedu.academic.domain.accessControl.PersistentResponsibleForExecutionCourseGroup;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.joda.time.DateTime;

@GroupOperator(value="responsibleForExecutionCourse")
public class ResponsibleForExecutionCourseGroup
extends FenixGroup {
    private static final long serialVersionUID = 1695000768665174854L;
    private static final ResponsibleForExecutionCourseGroup INSTANCE = new ResponsibleForExecutionCourseGroup();

    private ResponsibleForExecutionCourseGroup() {
    }

    public static ResponsibleForExecutionCourseGroup get() {
        return INSTANCE;
    }

    public Set<User> getMembers() {
        HashSet<User> users = new HashSet<User>();
        for (ExecutionYear executionYear : Bennu.getInstance().getExecutionYearsSet()) {
            if (!executionYear.isCurrent()) continue;
            for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
                for (ExecutionCourse executionCourse : executionSemester.getAssociatedExecutionCoursesSet()) {
                    for (Professorship professorship : executionCourse.getProfessorshipsSet()) {
                        User user;
                        if (!professorship.getResponsibleFor().booleanValue() || (user = professorship.getPerson().getUser()) == null) continue;
                        users.add(user);
                    }
                }
            }
        }
        return users;
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user) {
        if (user != null && user.getPerson().getTeacher() != null) {
            for (Professorship professorship : user.getPerson().getTeacher().getProfessorships(ExecutionYear.readCurrentExecutionYear())) {
                if (!professorship.isResponsibleFor()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentResponsibleForExecutionCourseGroup.getInstance();
    }

    public boolean equals(Object object) {
        return object instanceof ResponsibleForExecutionCourseGroup;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{ResponsibleForExecutionCourseGroup.class});
    }
}

