/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.ScientificCommissionLog;
import org.fenixedu.academic.domain.ScientificCommission_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;

public class ScientificCommission
extends ScientificCommission_Base {
    public ScientificCommission(ExecutionDegree executionDegree, Person person) {
        if (executionDegree.isPersonInScientificCommission(person)) {
            throw new DomainException("scientificCommission.person.duplicate", new String[0]);
        }
        this.setRootDomainObject(Bennu.getInstance());
        this.setContact(false);
        this.setExecutionDegree(executionDegree);
        this.setPerson(person);
        ScientificCommissionLog.createLog(this.getExecutionDegree().getDegree(), this.getExecutionDegree().getExecutionYear(), "resources.MessagingResources", "log.degree.scientificcomission.addmember", this.getPerson().getPresentationName(), this.getExecutionDegree().getDegree().getPresentationName());
    }

    public Coordinator getCoordinator() {
        for (Coordinator coordinator : this.getExecutionDegree().getCoordinatorsListSet()) {
            if (!this.getPerson().equals((Object)coordinator.getPerson())) continue;
            return coordinator;
        }
        return null;
    }

    public Boolean getHasCoordinator() {
        return this.getCoordinator() != null;
    }

    public Boolean isContact() {
        return this.getContact() == null ? false : this.getContact();
    }

    public void delete() {
        ScientificCommissionLog.createLog(this.getExecutionDegree().getDegree(), this.getExecutionDegree().getExecutionYear(), "resources.MessagingResources", "log.degree.scientificcomission.removemember", this.getPerson().getName(), this.getPerson().getUsername(), this.getExecutionDegree().getDegree().getPresentationName());
        this.setPerson(null);
        this.setExecutionDegree(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public void changeContactStatus(Boolean contact) {
        if (!contact.equals(this.getContact())) {
            this.setContact(contact);
            this.logEditMember();
        }
    }

    public void logEditMember() {
        ScientificCommissionLog.createLog(this.getExecutionDegree().getDegree(), this.getExecutionDegree().getExecutionYear(), "resources.MessagingResources", "log.degree.scientificcomission.editmember", this.getPerson().getPresentationName(), this.getExecutionDegree().getDegree().getPresentationName());
    }
}

