/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.fenixedu.academic.domain.EmptyGrade;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.curriculum.EnrollmentState;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.commons.i18n.LocalizedString;

public class Grade
implements Serializable,
Comparable<Grade> {
    private static Grade emptyGrade = new EmptyGrade();
    private static Map<String, Grade> gradeMap = new HashMap<String, Grade>();
    private final String value;
    private final GradeScale gradeScale;

    protected Grade() {
        this.value = null;
        this.gradeScale = null;
    }

    protected Grade(String value, GradeScale gradeScale) {
        if (EmptyGrade.qualifiesAsEmpty(value)) {
            throw new DomainException("error.grade.invalid.argument", new String[0]);
        }
        if (!gradeScale.belongsTo(value)) {
            throw new DomainException("error.grade.invalid.grade", new String[0]);
        }
        this.value = value.trim().toUpperCase();
        this.gradeScale = gradeScale;
    }

    @Override
    public int compareTo(Grade otherGrade) {
        return this.gradeScale.compareGrades(this, otherGrade);
    }

    public BigDecimal getNumericValue() {
        return this.value == null ? null : new BigDecimal(this.getValue());
    }

    public String getValue() {
        return this.value;
    }

    public Integer getIntegerValue() {
        return this.isNumeric() ? Integer.valueOf(this.getValue()) : null;
    }

    public GradeScale getGradeScale() {
        return this.gradeScale;
    }

    public static Grade createGrade(String value, GradeScale gradeScale) {
        if (EmptyGrade.qualifiesAsEmpty(value)) {
            return Grade.createEmptyGrade();
        }
        Grade grade = gradeMap.get(Grade.exportAsString(gradeScale, value));
        if (grade == null) {
            grade = new Grade(value, gradeScale);
            gradeMap.put(grade.exportAsString(), grade);
        }
        return grade;
    }

    public static Grade createEmptyGrade() {
        return emptyGrade;
    }

    public static Grade importFromString(String string) {
        if (EmptyGrade.qualifiesAsEmpty(string)) {
            return emptyGrade;
        }
        String[] tokens = string.split(":");
        return Grade.createGrade(tokens[1], GradeScale.valueOf(tokens[0]));
    }

    public String toString() {
        return this.exportAsString();
    }

    public String exportAsString() {
        return Grade.exportAsString(this.getGradeScale(), this.getValue());
    }

    private static String exportAsString(GradeScale gradeScale, String value) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)gradeScale);
        stringBuilder.append(":");
        stringBuilder.append(value.trim().toUpperCase());
        return stringBuilder.toString();
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isNumeric() {
        if (this.value.isEmpty()) {
            return false;
        }
        boolean foundSeperator = false;
        for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            if (c == '.' || c == ',') {
                if (foundSeperator) {
                    return false;
                }
                foundSeperator = true;
                continue;
            }
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public boolean isApproved() {
        return this.getGradeScale().isApproved(this);
    }

    public boolean isNotApproved() {
        return this.getGradeScale().isNotApproved(this);
    }

    public boolean isNotEvaluated() {
        return this.getGradeScale().isNotEvaluated(this);
    }

    public LocalizedString getExtendedValue() {
        return this.gradeScale.getExtendedValue(this);
    }

    public EnrollmentState getEnrolmentState() {
        if (this.isNotEvaluated()) {
            return EnrollmentState.NOT_EVALUATED;
        }
        if (this.isNotApproved()) {
            return EnrollmentState.NOT_APROVED;
        }
        if (this.isApproved()) {
            return EnrollmentState.APROVED;
        }
        return EnrollmentState.NOT_APROVED;
    }
}

