/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Comparator;
import org.fenixedu.academic.domain.DistrictSubdivision;
import org.fenixedu.academic.domain.District_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;

public class District
extends District_Base {
    public static Comparator<District> COMPARATOR_BY_NAME = new Comparator<District>(){

        @Override
        public int compare(District leftDistrict, District rightDistrict) {
            int comparationResult = leftDistrict.getName().compareTo(rightDistrict.getName());
            return comparationResult == 0 ? leftDistrict.getExternalId().compareTo(rightDistrict.getExternalId()) : comparationResult;
        }
    };

    private District() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public District(String code, String name) {
        this();
        this.init(code, name);
    }

    private void init(String code, String name) {
        this.checkParameters(code, name);
        super.setCode(code);
        super.setName(name);
    }

    private void checkParameters(String code, String name) {
        if (code == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.District.code.cannot.be.null", new String[0]);
        }
        if (name == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.District.name.cannot.be.null", new String[0]);
        }
    }

    public DistrictSubdivision getDistrictSubdivisionByName(String name) {
        for (DistrictSubdivision districtSubdivision : this.getDistrictSubdivisionsSet()) {
            if (!districtSubdivision.getName().equals(name)) continue;
            return districtSubdivision;
        }
        return null;
    }

    public static District readByCode(String code) {
        for (District district : Bennu.getInstance().getDistrictsSet()) {
            if (!district.getCode().equals(code)) continue;
            return district;
        }
        return null;
    }

    public static District readByName(String name) {
        for (District district : Bennu.getInstance().getDistrictsSet()) {
            if (!district.getName().equals(name)) continue;
            return district;
        }
        return null;
    }
}

