/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Department_Base;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.TeacherAuthorization;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.messaging.DepartmentForum;
import org.fenixedu.academic.domain.organizationalStructure.CompetenceCourseGroupUnit;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.domain.organizationalStructure.ScientificAreaUnit;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.joda.time.ReadableInterval;

public class Department
extends Department_Base {
    public static final Comparator<Department> COMPARATOR_BY_NAME = new ComparatorChain();

    public Department() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public List<Teacher> getAllCurrentTeachers() {
        return this.getAllTeachers(ExecutionSemester.readActualExecutionSemester());
    }

    public List<Teacher> getAllTeachers(AcademicInterval interval) {
        return this.getTeacherAuthorizationStream().filter(a -> a.getExecutionSemester().getAcademicInterval().overlaps((ReadableInterval)interval)).map(a -> a.getTeacher()).collect(Collectors.toList());
    }

    public List<Teacher> getAllTeachers(ExecutionSemester semester) {
        return this.getTeacherAuthorizationStream().filter(a -> a.getExecutionSemester().equals(semester)).map(a -> a.getTeacher()).collect(Collectors.toList());
    }

    public List<Teacher> getAllTeachers(ExecutionYear executionYear) {
        return this.getTeacherAuthorizationStream().filter(a -> a.getExecutionSemester().getExecutionYear().equals(executionYear)).map(a -> a.getTeacher()).collect(Collectors.toList());
    }

    public List<Teacher> getAllTeachers() {
        return this.getTeacherAuthorizationStream().map(a -> a.getTeacher()).collect(Collectors.toList());
    }

    public Stream<TeacherAuthorization> getRevokedTeacherAuthorizationStream() {
        return this.getRevokedTeacherAuthorizationSet().stream();
    }

    public Stream<TeacherAuthorization> getTeacherAuthorizationStream() {
        return this.getTeacherAuthorizationSet().stream();
    }

    public Set<DegreeType> getDegreeTypes() {
        TreeSet<DegreeType> degreeTypes = new TreeSet<DegreeType>();
        for (Degree degree : this.getDegreesSet()) {
            degreeTypes.add(degree.getDegreeType());
        }
        return degreeTypes;
    }

    public Set<CycleType> getCycleTypes() {
        TreeSet<CycleType> cycles = new TreeSet<CycleType>();
        for (DegreeType degreeType : this.getDegreeTypes()) {
            cycles.addAll(degreeType.getCycleTypes());
        }
        return cycles;
    }

    public String getAcronym() {
        int begin = this.getRealName().indexOf("(");
        int end = this.getRealName().indexOf(")");
        return this.getRealName().substring(begin + 1, end);
    }

    public List<CompetenceCourse> getBolonhaCompetenceCourses() {
        DepartmentUnit departmentUnit = this.getDepartmentUnit();
        ArrayList<CompetenceCourse> courses = new ArrayList<CompetenceCourse>();
        for (ScientificAreaUnit areaUnit : departmentUnit.getScientificAreaUnits()) {
            for (CompetenceCourseGroupUnit competenceCourseGroupUnit : areaUnit.getCompetenceCourseGroupUnits()) {
                courses.addAll(competenceCourseGroupUnit.getCompetenceCourses());
            }
        }
        return courses;
    }

    public void addAllBolonhaCompetenceCourses(Collection<CompetenceCourse> competenceCourses, ExecutionSemester period) {
        for (CompetenceCourse course : this.getBolonhaCompetenceCourses()) {
            if (course.getCurricularCoursesWithActiveScopesInExecutionPeriod(period).isEmpty()) continue;
            competenceCourses.add(course);
        }
    }

    public static Department readByName(String departmentName) {
        for (Department department : Bennu.getInstance().getDepartmentsSet()) {
            if (!department.getName().equals(departmentName)) continue;
            return department;
        }
        return null;
    }

    public void delete() {
        if (!this.getTeacherGroupSet().isEmpty()) {
            throw new DomainException("error.department.cannotDeleteDepartmentUsedInAccessControl", new String[0]);
        }
        this.setMembersGroup(null);
        this.setDepartmentUnit(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public MultiLanguageString getNameI18n() {
        return new MultiLanguageString().with(MultiLanguageString.pt, this.getRealName()).with(MultiLanguageString.en, this.getRealNameEn());
    }

    public Integer getCompetenceCourseInformationChangeRequestsCount() {
        int count = 0;
        for (CompetenceCourse course : this.getDepartmentUnit().getCompetenceCourses()) {
            count += course.getCompetenceCourseInformationChangeRequestsSet().size();
        }
        return count;
    }

    public Integer getDraftCompetenceCourseInformationChangeRequestsCount() {
        int count = 0;
        for (CompetenceCourse course : this.getDepartmentUnit().getCompetenceCourses()) {
            count += course.getDraftCompetenceCourseInformationChangeRequestsCount().intValue();
        }
        return count;
    }

    public Group getCompetenceCourseMembersGroup() {
        return this.getMembersGroup().toGroup();
    }

    public void setCompetenceCourseMembersGroup(Group group) {
        this.setMembersGroup(group.toPersistentGroup());
    }

    public boolean isUserMemberOfCompetenceCourseMembersGroup(User user) {
        return this.getCompetenceCourseMembersGroup().isMember(user);
    }

    public boolean isUserMemberOfCompetenceCourseMembersGroup(Person person) {
        return this.getCompetenceCourseMembersGroup().isMember(person.getUser());
    }

    public boolean isCurrentUserMemberOfCompetenceCourseMembersGroup() {
        return this.isUserMemberOfCompetenceCourseMembersGroup(AccessControl.getPerson());
    }

    public DepartmentForum getDepartmentForum() {
        return this.getForum();
    }

    public static Department find(String departmentCode) {
        Unit unit;
        for (Department department : Bennu.getInstance().getDepartmentsSet()) {
            if (!department.getAcronym().equals(departmentCode)) continue;
            return department;
        }
        if (StringUtils.isNumeric((String)departmentCode) && (unit = Unit.readByCostCenterCode(new Integer(departmentCode))) != null) {
            DepartmentUnit departmentUnit = unit.getDepartmentUnit();
            return departmentUnit == null ? null : departmentUnit.getDepartment();
        }
        return null;
    }

    public static List<Department> readActiveDepartments() {
        return Bennu.getInstance().getDepartmentsSet().stream().filter(Department_Base::getActive).sorted(COMPARATOR_BY_NAME).collect(Collectors.toList());
    }

    static {
        ((ComparatorChain)COMPARATOR_BY_NAME).addComparator((Comparator)new BeanComparator("name", (Comparator)Collator.getInstance()));
        ((ComparatorChain)COMPARATOR_BY_NAME).addComparator(DomainObjectUtil.COMPARATOR_BY_ID);
    }
}

