/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.log.FirstYearShiftsCapacityToggleLog;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicYearCE;
import org.fenixedu.academic.dto.resourceAllocationManager.ContextSelectionBean;
import org.fenixedu.academic.dto.resourceAllocationManager.StudentContextSelectionBean;
import org.fenixedu.academic.service.services.person.SearchPerson;
import org.fenixedu.academic.ui.struts.action.base.FenixContextDispatchAction;
import org.fenixedu.academic.ui.struts.action.externalSupervision.consult.ShowStudentTimeTable;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.ExecutionPeriodDA$callable$setFirstYearShiftsCapacity;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.RAMApplication;
import org.fenixedu.academic.util.CollectionPager;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=RAMApplication.RAMSchedulesApp.class, path="manage", titleKey="link.schedules.chooseContext")
@Mapping(path="/chooseExecutionPeriod", module="resourceAllocationManager")
@Forwards(value={@Forward(name="toggleFirstYearShiftsCapacity", path="/resourceAllocationManager/toggleFirstYearShiftsCapacity_bd.jsp"), @Forward(name="showForm", path="/resourceAllocationManager/chooseExecutionPeriod_bd.jsp"), @Forward(name="showTimeTable", path="/resourceAllocationManager/showTimetable.jsp")})
public class ExecutionPeriodDA
extends FenixContextDispatchAction {
    private static final Integer FIRST_CURRICULAR_YEAR;
    private static final Comparator<ExecutionDegree> executionDegreeComparator;
    public static final Advice advice$setFirstYearShiftsCapacity;

    public ActionForward choose(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.prepare(mapping, form, request, response);
    }

    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContextSelectionBean contextSelectionBean = (ContextSelectionBean)request.getAttribute("context_selection_bean");
        StudentContextSelectionBean studentContextSelectionBean = new StudentContextSelectionBean(contextSelectionBean.getAcademicInterval());
        request.setAttribute("studentContextSelectionBean", (Object)studentContextSelectionBean);
        ArrayList<ExecutionDegree> executionDegrees = new ArrayList<ExecutionDegree>(ExecutionDegree.filterByAcademicInterval(contextSelectionBean.getAcademicInterval()));
        Collections.sort(executionDegrees, executionDegreeComparator);
        request.setAttribute("executionDegrees", executionDegrees);
        ExecutionSemester executionSemester = (ExecutionSemester)((Object)ExecutionInterval.getExecutionInterval(contextSelectionBean.getAcademicInterval()));
        request.setAttribute("executionSemester", (Object)executionSemester);
        AcademicCalendarEntry academicCalendarEntry = contextSelectionBean.getAcademicInterval().getAcademicCalendarEntry();
        while (!(academicCalendarEntry instanceof AcademicCalendarRootEntry)) {
            if (academicCalendarEntry instanceof AcademicYearCE) {
                ExecutionYear year = ExecutionYear.getExecutionYear((AcademicYearCE)((Object)academicCalendarEntry));
                request.setAttribute("executionYear", (Object)year);
                break;
            }
            academicCalendarEntry = academicCalendarEntry.getParentEntry();
        }
        if (!executionSemester.isCurrent()) {
            request.setAttribute("noEditionAllowed", (Object)true);
        }
        return mapping.findForward("showForm");
    }

    public ActionForward chooseStudent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StudentContextSelectionBean studentContextSelectionBean = (StudentContextSelectionBean)this.getRenderedObject();
        String number = studentContextSelectionBean.getNumber();
        if (number != null && !number.isEmpty()) {
            AcademicInterval academicInterval = studentContextSelectionBean.getAcademicInterval();
            ExecutionInterval executionInterval = ExecutionInterval.getExecutionInterval(academicInterval);
            SearchPerson.SearchParameters searchParameters = new SearchPerson.SearchParameters();
            if (StringUtils.isNumeric((String)number)) {
                searchParameters.setStudentNumber(Integer.valueOf(number));
            } else {
                searchParameters.setUsername(number);
            }
            CollectionPager<Person> people = new SearchPerson().run(searchParameters, new SearchPerson.SearchPersonPredicate(searchParameters));
            ArrayList<Registration> registrations = new ArrayList<Registration>();
            for (Person person : people.getCollection()) {
                if (person.getStudent() == null) continue;
                for (Registration registration : person.getStudent().getRegistrationsSet()) {
                    if (!registration.hasAnyActiveState((ExecutionSemester)((Object)executionInterval))) continue;
                    registrations.add(registration);
                }
            }
            if (studentContextSelectionBean.getToEdit()) {
                request.setAttribute("toEditScheduleRegistrations", registrations);
            } else {
                request.setAttribute("registrations", registrations);
            }
            request.setAttribute("timeTableExecutionSemester", (Object)executionInterval);
        }
        return this.prepare(mapping, form, request, response);
    }

    public ActionForward chooseStudentById(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Registration registration = (Registration)((Object)this.getDomainObject(request, "registrationId"));
        ExecutionSemester executionSemester = (ExecutionSemester)this.getDomainObject(request, "executionSemesterId");
        request.setAttribute("registration", (Object)registration);
        return new ShowStudentTimeTable().forwardToShowTimeTable(registration, mapping, request, executionSemester);
    }

    public ActionForward toggleFirstYearShiftsCapacity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("executionYear", this.getDomainObject(request, "executionYearId"));
        return mapping.findForward("toggleFirstYearShiftsCapacity");
    }

    public ActionForward blockFirstYearShiftsCapacity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExecutionYear executionYear = (ExecutionYear)this.getDomainObject(request, "executionYearId");
        Map<ExecutionDegree, Integer> modified = this.setFirstYearShiftsCapacity(true, executionYear);
        request.setAttribute("affectedDegrees", this.getAffectedDegreesInfo(modified));
        request.setAttribute("executionYear", (Object)executionYear);
        return mapping.findForward("toggleFirstYearShiftsCapacity");
    }

    public ActionForward unblockFirstYearShiftsCapacity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExecutionYear executionYear = (ExecutionYear)this.getDomainObject(request, "executionYearId");
        Map<ExecutionDegree, Integer> modified = this.setFirstYearShiftsCapacity(false, executionYear);
        request.setAttribute("affectedDegrees", this.getAffectedDegreesInfo(modified));
        request.setAttribute("executionYear", (Object)executionYear);
        return mapping.findForward("toggleFirstYearShiftsCapacity");
    }

    private List<String> getAffectedDegreesInfo(Map<ExecutionDegree, Integer> modified) {
        ArrayList<String> modifiedDescription = new ArrayList<String>();
        for (Map.Entry<ExecutionDegree, Integer> entry : modified.entrySet()) {
            modifiedDescription.add(new String(entry.getKey().getPresentationName() + " :  " + entry.getValue()));
        }
        Collections.sort(modifiedDescription);
        return modifiedDescription;
    }

    private Map<ExecutionDegree, Integer> setFirstYearShiftsCapacity(Boolean bl, ExecutionYear executionYear) {
        return (Map)advice$setFirstYearShiftsCapacity.perform((Callable)new ExecutionPeriodDA$callable$setFirstYearShiftsCapacity(this, bl, executionYear));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ Map advised$setFirstYearShiftsCapacity(ExecutionPeriodDA this_, Boolean toBlock, ExecutionYear executionYear) {
        ExecutionSemester executionSemester = executionYear.getFirstExecutionPeriod();
        HashMap<Shift, HashSet<ExecutionDegree>> shiftsDegrees = new HashMap<Shift, HashSet<ExecutionDegree>>();
        HashSet<Shift> shifts = new HashSet<Shift>();
        HashMap<ExecutionDegree, Integer> modified = new HashMap<ExecutionDegree, Integer>();
        for (Degree degree : Degree.readAllMatching(DegreeType.oneOf(DegreeType::isBolonhaDegree, DegreeType::isIntegratedMasterDegree))) {
            for (DegreeCurricularPlan degreeCurricularPlan : degree.getActiveDegreeCurricularPlans()) {
                ExecutionDegree executionDegree = degreeCurricularPlan.getExecutionDegreeByAcademicInterval(executionSemester.getExecutionYear().getAcademicInterval());
                if (executionDegree == null) continue;
                for (SchoolClass schoolClass : executionDegree.getSchoolClassesSet()) {
                    if (!schoolClass.getAnoCurricular().equals(FIRST_CURRICULAR_YEAR) || schoolClass.getExecutionPeriod() != executionSemester) continue;
                    for (Shift shift : schoolClass.getAssociatedShiftsSet()) {
                        HashSet<ExecutionDegree> executionDegrees = (HashSet<ExecutionDegree>)shiftsDegrees.get((Object)shift);
                        if (executionDegrees == null) {
                            executionDegrees = new HashSet<ExecutionDegree>();
                        }
                        executionDegrees.add(executionDegree);
                        shiftsDegrees.put(shift, executionDegrees);
                        shifts.add(shift);
                    }
                }
            }
        }
        for (Shift shift : shifts) {
            int capacity = shift.getLotacao();
            if (toBlock.booleanValue() && capacity > 0) {
                shift.setLotacao(capacity * -1);
            } else {
                if (toBlock.booleanValue() || capacity >= 0) continue;
                shift.setLotacao(capacity * -1);
            }
            for (ExecutionDegree executionDegree : (Set)shiftsDegrees.get((Object)shift)) {
                if (modified.containsKey(executionDegree)) {
                    modified.put(executionDegree, (Integer)modified.get(executionDegree) + 1);
                    continue;
                }
                modified.put(executionDegree, 1);
            }
        }
        if (modified.size() > 0) {
            new FirstYearShiftsCapacityToggleLog(executionYear.getFirstExecutionPeriod(), Authenticate.getUser().getPerson().getUser());
        }
        return modified;
    }

    static {
        advice$setFirstYearShiftsCapacity = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        FIRST_CURRICULAR_YEAR = 1;
        executionDegreeComparator = new Comparator<ExecutionDegree>(){

            @Override
            public int compare(ExecutionDegree executionDegree1, ExecutionDegree executionDegree2) {
                Degree degree1 = executionDegree1.getDegreeCurricularPlan().getDegree();
                Degree degree2 = executionDegree2.getDegreeCurricularPlan().getDegree();
                int degreeTypeComparison = degree1.getDegreeType().compareTo(degree2.getDegreeType());
                return degreeTypeComparison != 0 ? degreeTypeComparison : degree1.getNome().compareTo(degree2.getNome());
            }
        };
    }
}

