/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers;

import java.util.ArrayList;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.dto.serviceRequests.IDocumentRequestBean;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.converters.EnumConverter;

public class DocumentRequestTypeProvider
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        return this.provide(source, currentValue, false, false);
    }

    public Object provide(Object source, Object currentValue, boolean includeQuickDeliveryTypes, boolean includePreBolonhaTypes) {
        IDocumentRequestBean bean = (IDocumentRequestBean)source;
        ArrayList<DocumentRequestType> result = new ArrayList<DocumentRequestType>();
        for (DocumentRequestType documentRequestType : DocumentRequestType.values()) {
            if (includeQuickDeliveryTypes != documentRequestType.isAllowedToQuickDeliver() || !includePreBolonhaTypes && documentRequestType.isPreBolonha() || documentRequestType.isBolonhaOnly() && bean.hasRegistration() && !bean.getRegistration().isBolonha() || documentRequestType.equals((Object)DocumentRequestType.APPROVEMENT_CERTIFICATE)) continue;
            result.add(documentRequestType);
        }
        return result;
    }

    public Converter getConverter() {
        return new EnumConverter();
    }

    public static class QuickDeliveryTypes
    extends DocumentRequestTypeProvider {
        @Override
        public Object provide(Object source, Object currentValue) {
            return super.provide(source, currentValue, true, false);
        }
    }

    public static class PreBolonhaTypes
    extends DocumentRequestTypeProvider {
        @Override
        public Object provide(Object source, Object currentValue) {
            return super.provide(source, currentValue, false, true);
        }
    }
}

