/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.teacher.evaluation;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.faces.model.SelectItem;
import org.apache.commons.beanutils.BeanComparator;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.academic.domain.Project;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.teacher.CreateProject;
import org.fenixedu.academic.service.services.teacher.DeleteEvaluation;
import org.fenixedu.academic.service.services.teacher.EditProject;
import org.fenixedu.academic.ui.faces.bean.teacher.evaluation.EvaluationManagementBackingBean;
import org.fenixedu.academic.util.DateFormatUtil;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.fenixframework.FenixFramework;

public class ProjectManagementBackingBean
extends EvaluationManagementBackingBean {
    protected String name;
    protected String beginProjectDate;
    protected String beginProjectHour;
    protected String endProjectDate;
    protected String endProjectHour;
    protected Project project;
    protected String projectID;
    protected List<Project> associatedProjects;
    protected Boolean onlineSubmissionsAllowed;
    protected Integer maxSubmissionsToKeep;
    protected String groupingID;
    protected List<SelectItem> executionCourseGroupings;
    protected List<String> selectedDepartments;

    public ProjectManagementBackingBean() {
        this.initSelectedDepartments();
    }

    private void initSelectedDepartments() {
        Project project = this.getProject();
        this.selectedDepartments = new ArrayList<String>();
        if (project != null) {
            for (Department department : project.getDeparmentsSet()) {
                this.selectedDepartments.add(department.getExternalId());
            }
        }
    }

    private String getBeginString() {
        return this.getBeginProjectDate() + " " + this.getBeginProjectHour();
    }

    private String getEndString() {
        return this.getEndProjectDate() + " " + this.getEndProjectHour();
    }

    public String createProject() {
        try {
            CreateProject.runCreateProject(this.getExecutionCourseID(), this.getName(), DateFormatUtil.parse("dd/MM/yyyy HH:mm", this.getBeginString()), DateFormatUtil.parse("dd/MM/yyyy HH:mm", this.getEndString()), this.getDescription(), this.getOnlineSubmissionsAllowed(), this.getMaxSubmissionsToKeep(), this.getGroupingID(), this.getGradeScale(), this.getSelectDepartments());
        }
        catch (FenixServiceException e) {
            this.setErrorMessage(e.getMessage());
            return "";
        }
        catch (ParseException e) {
            this.setErrorMessage("error.invalidDate");
            return "";
        }
        catch (DomainException e) {
            this.setErrorMessage(e.getKey());
            return "";
        }
        return "projectsIndex";
    }

    public String editProject() {
        try {
            EditProject.runEditProject(this.getExecutionCourseID(), this.getProjectID(), this.getName(), DateFormatUtil.parse("dd/MM/yyyy HH:mm", this.getBeginString()), DateFormatUtil.parse("dd/MM/yyyy HH:mm", this.getEndString()), this.getDescription(), this.getOnlineSubmissionsAllowed(), this.getMaxSubmissionsToKeep(), this.getGroupingID(), this.getGradeScale(), this.getSelectDepartments());
            this.setAssociatedProjects(null);
        }
        catch (NotAuthorizedException notAuthorizedException) {
        }
        catch (FenixServiceException e) {
            this.setErrorMessage(e.getMessage());
            return "";
        }
        catch (ParseException e) {
            this.setErrorMessage("error.invalidDate");
            return "";
        }
        catch (DomainException e) {
            this.setErrorMessage(e.getKey());
            return "";
        }
        return "projectsIndex";
    }

    public String deleteProject() {
        try {
            DeleteEvaluation.runDeleteEvaluation(this.getExecutionCourseID(), this.getProjectID());
            this.setAssociatedProjects(null);
        }
        catch (NotAuthorizedException notAuthorizedException) {
        }
        catch (FenixServiceException e) {
            this.setErrorMessage(e.getMessage());
        }
        catch (DomainException e) {
            this.setErrorMessage(e.getKey());
        }
        return "projectsIndex";
    }

    private Project getProject() {
        if (this.project == null && this.getProjectID() != null) {
            this.project = (Project)FenixFramework.getDomainObject((String)this.getProjectID());
        }
        return this.project;
    }

    public List<Project> getAssociatedProjects() throws FenixServiceException {
        if (this.associatedProjects == null) {
            ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)this.getExecutionCourseID());
            this.associatedProjects = executionCourse.getAssociatedProjects();
            Collections.sort(this.associatedProjects, new BeanComparator("begin"));
        }
        return this.associatedProjects;
    }

    public void setAssociatedProjects(List<Project> associatedProjects) {
        this.associatedProjects = associatedProjects;
    }

    public String getBeginProjectDate() {
        if (this.beginProjectDate == null && this.getProject() != null) {
            this.beginProjectDate = DateFormatUtil.format("dd/MM/yyyy", this.getProject().getBegin());
        }
        return this.beginProjectDate;
    }

    public void setBeginProjectDate(String beginProjectDate) {
        this.beginProjectDate = beginProjectDate;
    }

    public String getEndProjectDate() {
        if (this.endProjectDate == null && this.getProject() != null) {
            this.endProjectDate = DateFormatUtil.format("dd/MM/yyyy", this.getProject().getEnd());
        }
        return this.endProjectDate;
    }

    public void setEndProjectDate(String endProjectDate) {
        this.endProjectDate = endProjectDate;
    }

    public String getName() {
        if (this.name == null && this.getProject() != null) {
            this.name = this.getProject().getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        if (this.description == null && this.getProject() != null) {
            this.description = this.getProject().getDescription();
        }
        return this.description;
    }

    public String getProjectID() {
        if (this.projectID == null && this.getRequestParameter("projectID") != null && !this.getRequestParameter("projectID").equals("")) {
            this.projectID = this.getRequestParameter("projectID");
        }
        return this.projectID;
    }

    public void setProjectID(String projectID) {
        this.projectID = projectID;
    }

    public String getBeginProjectHour() {
        if (this.beginProjectHour == null && this.getProject() != null) {
            this.beginProjectHour = DateFormatUtil.format("HH:mm", this.getProject().getBegin());
        }
        return this.beginProjectHour;
    }

    public void setBeginProjectHour(String beginProjectHour) {
        this.beginProjectHour = beginProjectHour;
    }

    public String getEndProjectHour() {
        if (this.endProjectHour == null && this.getProject() != null) {
            this.endProjectHour = DateFormatUtil.format("HH:mm", this.getProject().getEnd());
        }
        return this.endProjectHour;
    }

    public void setEndProjectHour(String endProjectHour) {
        this.endProjectHour = endProjectHour;
    }

    public String getGroupingID() {
        if (this.groupingID == null && this.getProject() != null) {
            Grouping grouping = this.getProject().getGrouping();
            this.groupingID = grouping != null ? grouping.getExternalId() : null;
        }
        return this.groupingID;
    }

    public void setGroupingID(String groupingID) {
        this.groupingID = groupingID;
    }

    public Integer getMaxSubmissionsToKeep() {
        if (this.maxSubmissionsToKeep == null && this.getProject() != null) {
            this.maxSubmissionsToKeep = this.getProject().getMaxSubmissionsToKeep();
        }
        return this.maxSubmissionsToKeep;
    }

    public void setMaxSubmissionsToKeep(Integer maxSubmissionsToKeep) {
        this.maxSubmissionsToKeep = maxSubmissionsToKeep;
    }

    public Boolean getOnlineSubmissionsAllowed() {
        if (this.onlineSubmissionsAllowed == null && this.getProject() != null) {
            this.onlineSubmissionsAllowed = this.getProject().getOnlineSubmissionsAllowed();
        }
        return this.onlineSubmissionsAllowed;
    }

    public void setOnlineSubmissionsAllowed(Boolean onlineSubmissionsAllowed) {
        this.onlineSubmissionsAllowed = onlineSubmissionsAllowed;
    }

    public List<SelectItem> getExecutionCourseGroupings() throws FenixServiceException {
        if (this.executionCourseGroupings == null) {
            this.executionCourseGroupings = new ArrayList<SelectItem>();
            for (Grouping grouping : this.getExecutionCourse().getGroupings()) {
                this.executionCourseGroupings.add(new SelectItem((Object)grouping.getExternalId(), grouping.getName()));
            }
        }
        return this.executionCourseGroupings;
    }

    @Override
    public GradeScale getGradeScale() {
        if (this.gradeScale == null && this.getProject() != null) {
            this.gradeScale = this.getProject().getGradeScale();
        }
        return this.gradeScale;
    }

    public List<SelectItem> getDepartments() {
        ArrayList<SelectItem> departments = new ArrayList<SelectItem>();
        for (Department department : Bennu.getInstance().getDepartmentsSet()) {
            SelectItem e = new SelectItem((Object)department.getExternalId(), department.getName());
            departments.add(e);
        }
        return departments;
    }

    public void setSelectedDepartments(List<String> departments) {
        this.selectedDepartments = departments;
    }

    public List<Department> getSelectDepartments() {
        ArrayList<Department> departments = new ArrayList<Department>();
        for (String departmentExtId : this.selectedDepartments) {
            departments.add((Department)FenixFramework.getDomainObject((String)departmentExtId));
        }
        return departments;
    }

    public List<String> getSelectedDepartments() {
        return this.selectedDepartments;
    }
}

