/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.teacher.executionCourse;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.LessonInstance;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.util.HourMinuteSecond;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.FenixFramework;

public class NextPossibleSummaryLessonsAndDatesBean
implements Serializable,
Comparable<NextPossibleSummaryLessonsAndDatesBean> {
    public static final Comparator<NextPossibleSummaryLessonsAndDatesBean> COMPARATOR_BY_DATE_AND_HOUR = new ComparatorChain();
    private ShiftType lessonType;
    private Lesson lessonReference;
    private Shift shiftReference;
    private YearMonthDay date;
    private Integer studentsNumber;
    private boolean extraLesson;
    private HourMinuteSecond time;
    private Space roomReference;

    public NextPossibleSummaryLessonsAndDatesBean() {
    }

    public NextPossibleSummaryLessonsAndDatesBean(Lesson lesson, YearMonthDay date) {
        this.setLesson(lesson);
        this.setShift(lesson.getShift());
        this.setDate(date);
        this.setExtraLesson(false);
        this.setTime(lesson.getBeginHourMinuteSecond());
    }

    public NextPossibleSummaryLessonsAndDatesBean(Shift shift, YearMonthDay date, HourMinuteSecond time, Space room) {
        this.setShift(shift);
        this.setDate(date);
        this.setExtraLesson(true);
        this.setTime(time);
        this.setRoom(room);
    }

    public boolean getHasLessonInstance() {
        return this.getLesson().getLessonInstanceFor(this.getDate()) != null;
    }

    public String getLessonInstancePrettyPrint() {
        if (this.isExtraLesson()) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getDate().toDateTimeAtMidnight().toString("E")).append(" (");
            builder.append(this.getTime().toString("HH:mm")).append(")");
            Space room = this.getRoom();
            if (room != null) {
                builder.append(" ").append(room.getName());
            }
            return builder.toString();
        }
        Lesson lesson = this.getLesson();
        LessonInstance lessonInstance = lesson.getLessonInstanceFor(this.getDate());
        return lessonInstance != null ? lessonInstance.prettyPrint() : lesson.prettyPrint();
    }

    public String getShiftTypesPrettyPrint() {
        return this.isExtraLesson() ? BundleUtil.getString((String)"resources.EnumerationResources", (String)"EXTRA_SUMMARY", (String[])new String[0]) : this.getShift().getShiftTypesPrettyPrint();
    }

    public boolean getWrittenSummary() {
        return this.isExtraLesson() ? true : this.getLesson().getSummaryByDate(this.getDate()) != null;
    }

    public String getMonthString() {
        return this.getDate().toDateTimeAtMidnight().toString("MMMM");
    }

    public boolean getWithoutSummary() {
        if (this.isExtraLesson()) {
            return false;
        }
        Lesson lesson = this.getLesson();
        return lesson.isDateValidToInsertSummary(this.getDate()) && lesson.isTimeValidToInsertSummary(new HourMinuteSecond(), this.getDate()) && !this.getWrittenSummary();
    }

    public boolean getIsPossibleDeleteLessonInstance() {
        return this.isExtraLesson() ? false : this.getLesson().getSummaryByDate(this.getDate()) == null;
    }

    public String getCheckBoxValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getDate().toString("yyyyMMdd"));
        stringBuilder.append(this.getLesson().getExternalId());
        return stringBuilder.toString();
    }

    public static NextPossibleSummaryLessonsAndDatesBean getNewInstance(String value) {
        int year = Integer.parseInt(value.substring(0, 4));
        int month = Integer.parseInt(value.substring(4, 6));
        int day = Integer.parseInt(value.substring(6, 8));
        if (year == 0 || month == 0 || day == 0) {
            return null;
        }
        YearMonthDay date = new YearMonthDay(year, month, day);
        Lesson lesson = (Lesson)FenixFramework.getDomainObject((String)value.substring(8));
        NextPossibleSummaryLessonsAndDatesBean bean = new NextPossibleSummaryLessonsAndDatesBean(lesson, date);
        return bean;
    }

    public HourMinuteSecond getTime() {
        return this.time;
    }

    public void setTime(HourMinuteSecond time) {
        this.time = time;
    }

    public boolean isExtraLesson() {
        return this.extraLesson;
    }

    public void setExtraLesson(boolean extraLesson) {
        this.extraLesson = extraLesson;
    }

    public Integer getStudentsNumber() {
        return this.studentsNumber;
    }

    public void setStudentsNumber(Integer studentsNumber) {
        this.studentsNumber = studentsNumber;
    }

    public YearMonthDay getDate() {
        return this.date;
    }

    public void setDate(YearMonthDay date) {
        this.date = date;
    }

    public Lesson getLesson() {
        return this.lessonReference;
    }

    public void setLesson(Lesson lesson) {
        this.lessonReference = lesson;
    }

    public Space getRoom() {
        return this.roomReference;
    }

    public void setRoom(Space room) {
        this.roomReference = room;
    }

    public Shift getShift() {
        return this.shiftReference;
    }

    public void setShift(Shift shift) {
        this.shiftReference = shift;
    }

    public ShiftType getLessonType() {
        return this.lessonType;
    }

    public void setLessonType(ShiftType lessonType) {
        this.lessonType = lessonType;
    }

    @Override
    public int compareTo(NextPossibleSummaryLessonsAndDatesBean o) {
        return this.date.compareTo((ReadablePartial)o.getDate());
    }

    static {
        ((ComparatorChain)COMPARATOR_BY_DATE_AND_HOUR).addComparator((Comparator)new BeanComparator("date"), true);
        ((ComparatorChain)COMPARATOR_BY_DATE_AND_HOUR).addComparator((Comparator)new BeanComparator("time"), true);
        ((ComparatorChain)COMPARATOR_BY_DATE_AND_HOUR).addComparator((Comparator)new BeanComparator("shift.externalId"));
    }
}

