/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.student;

import java.io.Serializable;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.student.SeniorStatute;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academic.domain.student.StudentStatute;

public class StudentStatuteBean
implements Serializable {
    private StatuteType statuteType;
    private ExecutionSemester executionSemester;
    private StudentStatute studentStatute;

    public StudentStatuteBean(StatuteType statuteType, ExecutionSemester executionSemester) {
        this.statuteType = statuteType;
        this.executionSemester = executionSemester;
    }

    public StudentStatuteBean(StatuteType statuteType) {
        this.statuteType = statuteType;
    }

    public StudentStatuteBean(StudentStatute studentStatute, ExecutionSemester executionSemester) {
        this.executionSemester = executionSemester;
        this.studentStatute = studentStatute;
    }

    public StudentStatuteBean(StudentStatute studentStatute) {
        this.studentStatute = studentStatute;
    }

    public ExecutionSemester getExecutionPeriod() {
        return this.executionSemester;
    }

    public StatuteType getStatuteType() {
        return this.statuteType != null ? this.statuteType : this.getStudentStatute().getType();
    }

    public StudentStatute getStudentStatute() {
        return this.studentStatute;
    }

    public String getBeginPeriodFormatted() {
        return this.getStudentStatute() != null && this.getStudentStatute().getBeginExecutionPeriod() != null ? this.getStudentStatute().getBeginExecutionPeriod().getQualifiedName() : " ... ";
    }

    public String getEndPeriodFormatted() {
        return this.getStudentStatute() != null && this.getStudentStatute().getEndExecutionPeriod() != null ? this.getStudentStatute().getEndExecutionPeriod().getQualifiedName() : " ... ";
    }

    public String getDescription() {
        return this.getStatuteType().getName().getContent() + (this.studentStatute instanceof SeniorStatute ? " (" + ((SeniorStatute)((Object)this.studentStatute)).getRegistration().getDegree().getPresentationName() + ") " : "");
    }
}

