/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.serviceRequests.documentRequests;

import java.util.List;
import java.util.Locale;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.documents.DocumentRequestGeneratedDocument;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdAcademicServiceRequestCreateBean;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdDocumentRequestCreateBean;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdDiplomaRequest;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdDiplomaSupplementRequest;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdRegistryDiplomaRequest_Base;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisFinalGrade;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.IRegistryDiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IRectorateSubmissionBatchDocumentEntry;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.academic.util.report.ReportsUtils;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhdRegistryDiplomaRequest
extends PhdRegistryDiplomaRequest_Base
implements IRegistryDiplomaRequest,
IRectorateSubmissionBatchDocumentEntry {
    private static final Logger logger = LoggerFactory.getLogger(PhdRegistryDiplomaRequest.class);

    protected PhdRegistryDiplomaRequest() {
    }

    protected PhdRegistryDiplomaRequest(PhdDocumentRequestCreateBean bean) {
        this();
        this.init(bean);
    }

    protected void init(PhdAcademicServiceRequestCreateBean bean) {
        throw new DomainException("invoke init(PhdDocumentRequestCreateBean)", new String[0]);
    }

    protected void init(PhdDocumentRequestCreateBean bean) {
        this.checkParameters(bean);
        super.init(bean);
        this.setDiplomaSupplement(PhdDiplomaSupplementRequest.create(bean));
    }

    private void checkParameters(PhdDocumentRequestCreateBean bean) {
        PhdIndividualProgramProcess process2 = bean.getPhdIndividualProgramProcess();
        if (process2.hasRegistryDiplomaRequest()) {
            throw new PhdDomainOperationException("error.registryDiploma.alreadyRequested", new String[0]);
        }
        if (!process2.isBolonha().booleanValue()) {
            return;
        }
        if (process2.hasDiplomaRequest()) {
            throw new PhdDomainOperationException("error.registryDiploma.alreadyHasDiplomaRequest", new String[0]);
        }
    }

    public boolean isPayedUponCreation() {
        return false;
    }

    public boolean isToPrint() {
        return false;
    }

    public boolean isPossibleToSendToOtherEntity() {
        return true;
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return true;
    }

    @Override
    public EventType getEventType() {
        return EventType.BOLONHA_PHD_REGISTRY_DIPLOMA_REQUEST;
    }

    public boolean hasPersonalInfo() {
        return true;
    }

    @Override
    public CycleType getRequestedCycle() {
        return CycleType.THIRD_CYCLE;
    }

    @Override
    public DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.REGISTRY_DIPLOMA_REQUEST;
    }

    @Override
    public String getDocumentTemplateKey() {
        return this.getClass().getName();
    }

    @Override
    public String getFinalAverage(Locale locale) {
        PhdThesisFinalGrade finalGrade = this.getPhdIndividualProgramProcess().getFinalGrade();
        return finalGrade.getLocalizedName(locale);
    }

    @Override
    public String getQualifiedAverageGrade(Locale locale) {
        String qualifiedAverageGrade;
        PhdThesisFinalGrade grade = this.getPhdIndividualProgramProcess().getFinalGrade();
        switch (grade) {
            case APPROVED: 
            case PRE_BOLONHA_APPROVED: {
                qualifiedAverageGrade = "sufficient";
                break;
            }
            case APPROVED_WITH_PLUS: 
            case PRE_BOLONHA_APPROVED_WITH_PLUS: {
                qualifiedAverageGrade = "good";
                break;
            }
            case APPROVED_WITH_PLUS_PLUS: 
            case PRE_BOLONHA_APPROVED_WITH_PLUS_PLUS: {
                qualifiedAverageGrade = "verygood";
                break;
            }
            default: {
                throw new DomainException("docs.academicAdministrativeOffice.RegistryDiploma.unknown.grade", new String[0]);
            }
        }
        return "diploma.supplement.qualifiedgrade." + qualifiedAverageGrade;
    }

    @Override
    public LocalDate getConclusionDate() {
        return this.getPhdIndividualProgramProcess().getConclusionDate();
    }

    @Override
    public ExecutionYear getConclusionYear() {
        return this.getPhdIndividualProgramProcess().getConclusionYear();
    }

    @Override
    public String getGraduateTitle(Locale locale) {
        return this.getPhdIndividualProgramProcess().getGraduateTitle(locale);
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        try {
            this.verifyIsToProcessAndHasPersonalInfo(academicServiceRequestBean);
            this.verifyIsToDeliveredAndIsPayed(academicServiceRequestBean);
        }
        catch (DomainException e) {
            throw new PhdDomainOperationException(e.getKey(), (Throwable)((Object)e), e.getArgs());
        }
        super.internalChangeState(academicServiceRequestBean);
        if (academicServiceRequestBean.isToProcess()) {
            if (!this.getPhdIndividualProgramProcess().isConclusionProcessed()) {
                throw new PhdDomainOperationException("error.registryDiploma.registrationNotSubmitedToConclusionProcess", new String[0]);
            }
            if (this.getRegistryCode() == null) {
                PhdDiplomaRequest diplomaRequest = this.getPhdIndividualProgramProcess().getDiplomaRequest();
                if (diplomaRequest != null && diplomaRequest.hasRegistryCode()) {
                    diplomaRequest.getRegistryCode().addDocumentRequest((AcademicServiceRequest)((Object)this));
                } else {
                    this.getRootDomainObject().getInstitutionUnit().getRegistryCodeGenerator().createRegistryFor((AcademicServiceRequest)((Object)this));
                }
                this.getAdministrativeOffice().getCurrentRectorateSubmissionBatch().addDocumentRequest((AcademicServiceRequest)((Object)this));
            }
            if (this.getLastGeneratedDocument() == null) {
                this.generateDocument();
            }
            this.getDiplomaSupplement().process();
        } else if (academicServiceRequestBean.isToConclude()) {
            if (this.getDiplomaSupplement().isConcludedSituationAccepted()) {
                this.getDiplomaSupplement().concludeServiceRequest();
            }
        } else if (academicServiceRequestBean.isToCancelOrReject()) {
            if (academicServiceRequestBean.isToCancel()) {
                this.getDiplomaSupplement().cancel(academicServiceRequestBean.getJustification());
            }
            if (academicServiceRequestBean.isToReject()) {
                this.getDiplomaSupplement().reject(academicServiceRequestBean.getJustification());
            }
        }
    }

    @Override
    public String getDescription() {
        return this.getDescription(this.getAcademicServiceRequestType(), "DocumentRequestType.REGISTRY_DIPLOMA_REQUEST.THIRD_CYCLE");
    }

    public static PhdRegistryDiplomaRequest create(PhdDocumentRequestCreateBean bean) {
        return new PhdRegistryDiplomaRequest(bean);
    }

    @Override
    public byte[] generateDocument() {
        try {
            List<AdministrativeOfficeDocument> documents = AdministrativeOfficeDocument.AdministrativeOfficeDocumentCreator.create(this);
            AdministrativeOfficeDocument[] array = new AdministrativeOfficeDocument[]{};
            byte[] data = ReportsUtils.generateReport(documents.toArray(array)).getData();
            DocumentRequestGeneratedDocument.store(this, ((AdministrativeOfficeDocument)documents.iterator().next()).getReportFileName() + ".pdf", data);
            return data;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DomainException("error.phdDiplomaRequest.errorGeneratingDocument", new String[0]);
        }
    }

    @Override
    public String getProgrammeTypeDescription() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)"label.php.program", (String[])new String[0]);
    }

    @Override
    public String getViewStudentProgrammeLink() {
        return "/phdIndividualProgramProcess.do?method=viewProcess&amp;processId=" + this.getPhdIndividualProgramProcess().getExternalId();
    }

    @Override
    public String getReceivedActionLink() {
        return String.format("/phdAcademicServiceRequestManagement.do?method=prepareReceiveOnRectorate&amp;phdAcademicServiceRequestId=%s&amp;batchOid=%s", this.getExternalId(), this.getRectorateSubmissionBatch().getExternalId());
    }

    @Override
    public boolean isProgrammeLinkVisible() {
        return this.getPhdIndividualProgramProcess().isCurrentUserAllowedToManageProcess();
    }

    @Override
    public String getDegreeName(ExecutionYear year) {
        Degree degree = this.getPhdIndividualProgramProcess().getRegistration() != null ? this.getPhdIndividualProgramProcess().getRegistration().getDegree() : this.getPhdIndividualProgramProcess().getPhdProgram().getDegree();
        return degree.getNameI18N(year).getContent(this.getLanguage());
    }
}

