/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.ExternalPhdProgram;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramCollaborationType;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.PhdProgramFocusArea_Base;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import pt.ist.fenixframework.DomainObject;

public class PhdProgramFocusArea
extends PhdProgramFocusArea_Base {
    public static Comparator<PhdProgramFocusArea> COMPARATOR_BY_NAME = new Comparator<PhdProgramFocusArea>(){

        @Override
        public int compare(PhdProgramFocusArea o1, PhdProgramFocusArea o2) {
            int result = o1.getName().compareTo(o2.getName());
            return result != 0 ? result : DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2);
        }
    };

    private PhdProgramFocusArea() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setWhenCreated(new DateTime());
        this.setActive(Boolean.TRUE);
    }

    public PhdProgramFocusArea(MultiLanguageString name) {
        this();
        String[] args = new String[]{};
        if (name == null) {
            throw new DomainException("error.PhdProgramFocusArea.invalid.name", args);
        }
        this.checkForEqualFocusArea(name);
        this.setName(name);
    }

    private void checkForEqualFocusArea(MultiLanguageString name) {
        for (PhdProgramFocusArea focusArea : Bennu.getInstance().getPhdProgramFocusAreasSet()) {
            if (focusArea == this || !focusArea.getName().equalInAnyLanguage(name)) continue;
            throw new DomainException("error.PhdProgramFocusArea.found.area.with.same.name", new String[0]);
        }
    }

    public void delete() {
        this.getPhdProgramsSet().clear();
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public boolean hasPhdProgramFor(Degree degree) {
        for (PhdProgram program : this.getPhdProgramsSet()) {
            if (program.getDegree() == null || !program.getDegree().equals(degree)) continue;
            return true;
        }
        return false;
    }

    public List<ExternalPhdProgram> getAssociatedExternalPhdProgramsForCollaborationType(final PhdIndividualProgramCollaborationType type) {
        ArrayList<ExternalPhdProgram> externalPhdProgramList = new ArrayList<ExternalPhdProgram>();
        CollectionUtils.select((Collection)this.getExternalPhdProgramsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((ExternalPhdProgram)((Object)object)).isForCollaborationType(type);
            }
        }, externalPhdProgramList);
        return externalPhdProgramList;
    }

    public static PhdProgramFocusArea readPhdProgramFocusAreaByName(final String name) {
        return (PhdProgramFocusArea)((Object)CollectionUtils.find((Collection)Bennu.getInstance().getPhdProgramFocusAreasSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return name.equals(((PhdProgramFocusArea)((Object)arg0)).getName().getContent());
            }
        }));
    }

    public static Set<PhdProgramFocusArea> getActivePhdProgramFocusAreas() {
        HashSet<PhdProgramFocusArea> result = new HashSet<PhdProgramFocusArea>();
        for (PhdProgramFocusArea area : Bennu.getInstance().getPhdProgramFocusAreasSet()) {
            if (area.getActive() == null || !area.getActive().booleanValue()) continue;
            result.add(area);
        }
        return result;
    }
}

