/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.report.events;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.Installment;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEventWithPaymentPlan;
import org.fenixedu.academic.domain.accounting.report.events.GratuityEventInstallmentWrapper;
import org.fenixedu.academic.domain.accounting.report.events.InstallmentWrapper;
import org.fenixedu.academic.domain.accounting.report.events.Wrapper;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.student.EnrolmentModel;
import org.fenixedu.academic.util.MultiLanguageString;

public class GratuityEventWrapper
implements Wrapper {
    private final GratuityEvent event;

    public GratuityEventWrapper(GratuityEvent event) {
        this.event = event;
    }

    @Override
    public String getStudentNumber() {
        if (this.event.getPerson().getStudent() != null) {
            return this.event.getPerson().getStudent().getNumber().toString();
        }
        return "--";
    }

    @Override
    public String getStudentName() {
        return this.event.getPerson().getName();
    }

    @Override
    public String getStudentEmail() {
        return this.event.getPerson().getDefaultEmailAddressValue();
    }

    @Override
    public String getRegistrationStartDate() {
        return this.event.getRegistration().getStartDate().toString("dd/MM/yyyy");
    }

    @Override
    public String getExecutionYear() {
        return this.getForExecutionYear().getName();
    }

    @Override
    public String getDegreeName() {
        return this.event.getRegistration().getDegree().getNameI18N().getContent(MultiLanguageString.pt);
    }

    @Override
    public String getDegreeType() {
        return this.event.getRegistration().getDegreeType().getName().getContent();
    }

    @Override
    public String getPhdProgramName() {
        return "--";
    }

    @Override
    public String getEnrolledECTS() {
        return new BigDecimal(this.event.getRegistration().getLastStudentCurricularPlan().getEnrolmentsEctsCredits(this.event.getExecutionYear())).toString();
    }

    @Override
    public String getRegime() {
        return this.event.getRegistration().getRegimeType(this.event.getExecutionYear()).getLocalizedName();
    }

    @Override
    public String getEnrolmentModel() {
        EnrolmentModel enrolmentModelForExecutionYear;
        if (this.event.isDfaGratuityEvent() && (enrolmentModelForExecutionYear = this.event.getRegistration().getEnrolmentModelForExecutionYear(this.event.getExecutionYear())) != null) {
            return enrolmentModelForExecutionYear.getLocalizedName();
        }
        return "--";
    }

    @Override
    public String getResidenceYear() {
        return "--";
    }

    @Override
    public String getResidenceMonth() {
        return "--";
    }

    @Override
    public String getStudiesType() {
        return "Curso";
    }

    @Override
    public String getTotalDiscount() {
        return this.event.getTotalDiscount().toPlainString();
    }

    @Override
    public boolean isAfterOrEqualExecutionYear(ExecutionYear executionYear) {
        return !this.event.getExecutionYear().isBefore(executionYear);
    }

    @Override
    public ExecutionYear getForExecutionYear() {
        return this.event.getExecutionYear();
    }

    @Override
    public AdministrativeOffice getRelatedAcademicOffice() {
        return this.event.getAdministrativeOffice();
    }

    public List<InstallmentWrapper> getInstallments() {
        ArrayList<InstallmentWrapper> wrappers = new ArrayList<InstallmentWrapper>();
        if (this.event.isGratuityEventWithPaymentPlan()) {
            GratuityEventWithPaymentPlan gratuityEventWithPaymentPlan = (GratuityEventWithPaymentPlan)((Object)this.event);
            List<Installment> installments = gratuityEventWithPaymentPlan.getInstallments();
            for (Installment installment : installments) {
                wrappers.add(new GratuityEventInstallmentWrapper(gratuityEventWithPaymentPlan, installment));
            }
        }
        return wrappers;
    }

    @Override
    public String getRelatedEventExternalId() {
        return "--";
    }

    @Override
    public String getDebtorFiscalId() {
        return "--";
    }

    @Override
    public String getDebtorName() {
        return "--";
    }
}

