/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.gratuity;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.SpecializationDegreeGratuityByAmountPerEctsPR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class SpecializationDegreeGratuityByAmountPerEctsPR
extends SpecializationDegreeGratuityByAmountPerEctsPR_Base {
    protected SpecializationDegreeGratuityByAmountPerEctsPR() {
    }

    public SpecializationDegreeGratuityByAmountPerEctsPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money specializationDegreeTotalAmount, BigDecimal partialAcceptedPercentage, Money specializationDegreeAmountPerEctsCredit) {
        this.init(EntryType.GRATUITY_FEE, EventType.GRATUITY, startDate, endDate, serviceAgreementTemplate, specializationDegreeTotalAmount, partialAcceptedPercentage, specializationDegreeAmountPerEctsCredit);
    }

    protected void init(EntryType entryType, EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money specializationDegreeTotalAmount, BigDecimal specializationDegreePartialAcceptedPercentage, Money specializationDegreeAmountPerEctsCredit) {
        super.init(entryType, eventType, startDate, endDate, serviceAgreementTemplate, specializationDegreeTotalAmount, specializationDegreePartialAcceptedPercentage);
        this.checkParameters(specializationDegreeAmountPerEctsCredit);
        super.setSpecializationDegreeAmountPerEctsCredit(specializationDegreeAmountPerEctsCredit);
    }

    private void checkParameters(Money specializationDegreeAmountPerEctsCredit) {
        if (specializationDegreeAmountPerEctsCredit == null) {
            throw new DomainException("error.accounting.postingRules.gratuity.SpecializationDegreeGratuityByAmountPerEctsPR.specializationDegreeAmountPerEctsCredit.cannot.be.null", new String[0]);
        }
    }

    public void setSpecializationDegreeAmountPerEctsCredit(Money specializationDegreeAmountPerEctsCredit) {
        throw new DomainException("error.accounting.postingRules.gratuity.SpecializationDegreeGratuityByAmountPerEctsPR.cannot.modify.specializationDegreeAmountPerEctsCredit", new String[0]);
    }

    protected Money calculateSpecializationDegreeGratuityTotalAmountToPay(Event event) {
        double enrolmentsEctsForRegistration = ((GratuityEvent)((Object)event)).getEnrolmentsEctsForRegistration();
        Money result = this.getSpecializationDegreeAmountPerEctsCredit().multiply(new BigDecimal(enrolmentsEctsForRegistration));
        return result;
    }

    public SpecializationDegreeGratuityByAmountPerEctsPR edit(Money specializationDegreeTotalAmount, Money specializationDegreeAmountPerEctsCredit, BigDecimal partialAcceptedPercentage) {
        return this.edit(new DateTime(), specializationDegreeTotalAmount, specializationDegreeAmountPerEctsCredit, partialAcceptedPercentage);
    }

    public SpecializationDegreeGratuityByAmountPerEctsPR edit(DateTime startDate, Money specializationDegreeTotalAmount, Money specializationDegreeAmountPerEctsCredit, BigDecimal partialAcceptedPercentage) {
        this.deactivate(startDate);
        return new SpecializationDegreeGratuityByAmountPerEctsPR(startDate, null, this.getServiceAgreementTemplate(), specializationDegreeTotalAmount, partialAcceptedPercentage, specializationDegreeAmountPerEctsCredit);
    }
}

