/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.gratuity;

import java.util.Collections;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.events.gratuity.PastDegreeGratuityEvent_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.Money;

public class PastDegreeGratuityEvent
extends PastDegreeGratuityEvent_Base {
    protected PastDegreeGratuityEvent() {
    }

    public PastDegreeGratuityEvent(AdministrativeOffice administrativeOffice, Person person, StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear, Money pastDegreeGratuityAmount) {
        this();
        this.init(administrativeOffice, person, studentCurricularPlan, executionYear, pastDegreeGratuityAmount);
    }

    private void init(AdministrativeOffice administrativeOffice, Person person, StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear, Money pastDegreeGratuityAmount) {
        super.init(administrativeOffice, person, studentCurricularPlan, executionYear);
        this.checkParameters(studentCurricularPlan, pastDegreeGratuityAmount);
        super.setPastDegreeGratuityAmount(pastDegreeGratuityAmount);
    }

    private void checkParameters(StudentCurricularPlan studentCurricularPlan, Money pastDegreeGratuityAmount) {
        if (!studentCurricularPlan.getDegreeType().isPreBolonhaDegree()) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.events.gratuity.PastDegreeGratuityEvent.invalid.degree.type.for.student.curricular.plan", new String[0]);
        }
        if (pastDegreeGratuityAmount == null || pastDegreeGratuityAmount.isZero()) {
            throw new DomainException("error.org.fenixedu.academic.domain.accounting.events.gratuity.PastDegreeGratuityEvent.pastDegreeGratuityAmount.cannot.be.null.and.must.be.greather.than.zero", new String[0]);
        }
    }

    public boolean isExemptionAppliable() {
        return true;
    }

    public Set<EntryType> getPossibleEntryTypesForDeposit() {
        return Collections.singleton(EntryType.GRATUITY_FEE);
    }
}

