/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.dfa;

import org.fenixedu.academic.domain.CandidacyPeriodInDegreeCurricularPlan;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.RegistrationPeriodInDegreeCurricularPlan;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountType;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.events.dfa.DfaRegistrationEvent_Base;
import org.fenixedu.academic.domain.accounting.serviceAgreementTemplates.AdministrativeOfficeServiceAgreementTemplate;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.util.LabelFormatter;
import org.joda.time.DateTime;

public class DfaRegistrationEvent
extends DfaRegistrationEvent_Base {
    private DfaRegistrationEvent() {
    }

    public DfaRegistrationEvent(AdministrativeOffice administrativeOffice, Person person, Registration registration) {
        this();
        ExecutionYear executionYear = registration.getStudentCandidacy().getExecutionDegree().getExecutionYear();
        this.init(administrativeOffice, person, registration, executionYear);
    }

    public DfaRegistrationEvent(AdministrativeOffice administrativeOffice, Person person, Registration registration, ExecutionYear executionYear) {
        this();
        this.init(administrativeOffice, person, registration, executionYear);
    }

    private void init(AdministrativeOffice administrativeOffice, Person person, Registration registration, ExecutionYear executionYear) {
        super.init(administrativeOffice, EventType.DFA_REGISTRATION, person);
        this.checkParameters(registration, executionYear);
        super.setRegistration(registration);
        super.setExecutionYear(executionYear);
    }

    private void checkParameters(Registration registration, ExecutionYear executionYear) {
        if (registration == null) {
            throw new DomainException("error.accounting.events.dfa.DfaRegistrationEvent.registration.cannot.be.null", new String[0]);
        }
        if (executionYear == null) {
            throw new DomainException("error.accounting.events.dfa.DfaRegistrationEvent.execution.year.cannot.be.null", new String[0]);
        }
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources").appendLabel(" (").appendLabel(this.getDegree().getDegreeType().getName().getContent()).appendLabel(" - ").appendLabel(this.getDegree().getNameFor(this.getExecutionYear()).getContent()).appendLabel(" - ").appendLabel(this.getExecutionYear().getYear()).appendLabel(")");
        return labelFormatter;
    }

    private ExecutionDegree getExecutionDegree() {
        return this.getRegistration().getStudentCandidacy().getExecutionDegree();
    }

    private Degree getDegree() {
        return this.getExecutionDegree().getDegree();
    }

    public PostingRule getPostingRule() {
        return this.getServiceAgreementTemplate().findPostingRuleByEventTypeAndDate(this.getEventType(), this.getExecutionYear().getBeginDateYearMonthDay().toDateMidnight().toDateTime().plusSeconds(1));
    }

    private AdministrativeOfficeServiceAgreementTemplate getServiceAgreementTemplate() {
        return this.getAdministrativeOffice().getServiceAgreementTemplate();
    }

    public Account getToAccount() {
        return this.getAdministrativeOffice().getUnit().getAccountBy(AccountType.INTERNAL);
    }

    protected Account getFromAccount() {
        return this.getPerson().getAccountBy(AccountType.EXTERNAL);
    }

    public void setRegistration(Registration registration) {
        throw new DomainException("error.accounting.events.dfa.DfaRegistrationEvent.cannot.modify.registration", new String[0]);
    }

    public DateTime getRegistrationDate() {
        return this.getRegistration().getStartDate().toDateTimeAtMidnight();
    }

    public RegistrationPeriodInDegreeCurricularPlan getRegistrationPeriodInDegreeCurricularPlan() {
        return this.getExecutionDegree().getDegreeCurricularPlan().getRegistrationPeriod(this.getExecutionYear());
    }

    public boolean hasRegistrationPeriodInDegreeCurricularPlan() {
        return this.getExecutionDegree().getDegreeCurricularPlan().hasRegistrationPeriodFor(this.getExecutionYear());
    }

    public CandidacyPeriodInDegreeCurricularPlan getCandidacyPeriodInDegreeCurricularPlan() {
        return this.getExecutionDegree().getDegreeCurricularPlan().getCandidacyPeriod(this.getExecutionYear());
    }

    public boolean hasCandidacyPeriodInDegreeCurricularPlan() {
        return this.getExecutionDegree().getDegreeCurricularPlan().hasCandidacyPeriodFor(this.getExecutionYear());
    }

    private StudentCandidacy getCandidacy() {
        return this.getRegistration().getStudentCandidacy();
    }

    public DateTime getCandidacyDate() {
        return this.getCandidacy().getCandidacyDate();
    }

    public ExecutionYear getObsoleteExecutionYear() {
        return this.getExecutionDegree().getExecutionYear();
    }

    public LabelFormatter getDescription() {
        LabelFormatter labelFormatter = super.getDescription();
        labelFormatter.appendLabel(" ");
        labelFormatter.appendLabel(this.getDegree().getDegreeType().getName().getContent()).appendLabel(" - ");
        labelFormatter.appendLabel(this.getDegree().getNameFor(this.getExecutionYear()).getContent()).appendLabel(" - ");
        labelFormatter.appendLabel(this.getExecutionYear().getYear());
        return labelFormatter;
    }

    public boolean isDfaRegistrationEvent() {
        return true;
    }

    public boolean isExemptionAppliable() {
        return true;
    }
}

