/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Money
implements Comparable<Money>,
Serializable {
    private static final BigDecimal CONVERSION_RATE_ESCUDOS_TO_EURO = BigDecimal.valueOf(200.482);
    private static final int EURO_SCALE = 2;
    public static final Money ZERO = new Money(0L);
    private final BigDecimal amount;

    public Money(long amount) {
        this.amount = this.round(BigDecimal.valueOf(amount));
    }

    public Money(BigDecimal amount) {
        this.amount = this.round(amount);
    }

    public Money(String amount) {
        this.amount = this.round(new BigDecimal(amount));
    }

    public Money(Double amount) {
        this.amount = this.round(new BigDecimal(amount));
    }

    private BigDecimal round(BigDecimal amountToRound) {
        return amountToRound.setScale(2, RoundingMode.HALF_EVEN);
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getAmountAsString() {
        return this.toPlainString();
    }

    @Override
    public int compareTo(Money otherMoney) {
        return this.amount.compareTo(otherMoney.getAmount());
    }

    public boolean equals(Object obj) {
        return obj instanceof Money ? this.compareTo((Money)obj) == 0 : false;
    }

    public int hashCode() {
        return this.amount.hashCode();
    }

    public Money add(Money money) {
        return new Money(this.amount.add(money.getAmount()));
    }

    public Money add(BigDecimal amount) {
        return new Money(this.amount.add(amount));
    }

    public Money subtract(Money money) {
        if (money != null) {
            return new Money(this.amount.subtract(money.getAmount()));
        }
        return this;
    }

    public Money subtract(BigDecimal amount) {
        return new Money(this.amount.subtract(amount));
    }

    public Money multiply(Money money) {
        if (money != null) {
            return new Money(this.amount.multiply(money.getAmount()));
        }
        return this;
    }

    public Money multiply(BigDecimal amount) {
        return new Money(this.amount.multiply(amount));
    }

    public Money multiply(int value) {
        return this.multiply(BigDecimal.valueOf(value));
    }

    public Money divide(Money money) {
        if (money != null) {
            return new Money(this.amount.divide(money.getAmount()));
        }
        return this;
    }

    public Money divide(BigDecimal amount) {
        return new Money(this.amount.divide(amount));
    }

    public String toPlainString() {
        return this.amount.toPlainString();
    }

    public String toString() {
        return this.amount.toString();
    }

    public static Money valueOf(long value) {
        return new Money(BigDecimal.valueOf(value));
    }

    public boolean greaterThan(Money money) {
        return this.compareTo(money) > 0;
    }

    public boolean greaterOrEqualThan(Money money) {
        return this.compareTo(money) >= 0;
    }

    public boolean lessThan(Money money) {
        return this.compareTo(money) < 0;
    }

    public boolean lessOrEqualThan(Money money) {
        return this.compareTo(money) <= 0;
    }

    public boolean isPositive() {
        return this.amount.signum() == 1;
    }

    public boolean isZero() {
        return this.amount.signum() == 0;
    }

    public boolean isNegative() {
        return this.amount.signum() == -1;
    }

    public Money negate() {
        return new Money(this.amount.negate());
    }

    public long longValue() {
        return this.amount.longValueExact();
    }

    public Money abs() {
        return new Money(this.amount.abs());
    }

    public Money escudosToEuros() {
        return new Money(this.amount.divide(CONVERSION_RATE_ESCUDOS_TO_EURO, 2, RoundingMode.HALF_UP));
    }

    public static Money min(Money value1, Money value2) {
        return value1.lessThan(value2) ? value1 : value2;
    }

    public static Money max(Money value1, Money value2) {
        return value1.lessThan(value2) ? value2 : value1;
    }
}

