/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.util.LabelFormatter;

public class InvocationResult {
    private boolean success = false;
    private final List<LabelFormatter> messages = new ArrayList<LabelFormatter>();

    public boolean isSuccess() {
        return this.success;
    }

    public InvocationResult setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public InvocationResult addMesssage(LabelFormatter message) {
        this.messages.add(message);
        return this;
    }

    public InvocationResult addMessages(List<LabelFormatter> messages) {
        this.messages.addAll(messages);
        return this;
    }

    public InvocationResult addMessage(String bundle, String key, String ... args) {
        this.messages.add(new LabelFormatter(bundle, key, args));
        return this;
    }

    public InvocationResult addMessage(String text) {
        this.messages.add(new LabelFormatter(text));
        return this;
    }

    public List<LabelFormatter> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public LabelFormatter[] getMessagesAsArray() {
        return this.messages.toArray(new LabelFormatter[0]);
    }

    public InvocationResult and(InvocationResult other) {
        InvocationResult result = new InvocationResult();
        result.setSuccess(this.isSuccess() && other.isSuccess());
        result.addMessages(this.getMessages());
        result.addMessages(other.getMessages());
        return result;
    }

    public static InvocationResult createSuccess() {
        return new InvocationResult().setSuccess(true);
    }

    public static InvocationResult createInsuccess() {
        return new InvocationResult().setSuccess(false);
    }
}

