/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.teacher.executionCourse;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.teacher.DeleteProfessorshipWithPerson;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.teacher.ManageExecutionCourseDA;
import org.fenixedu.academic.ui.struts.action.teacher.executionCourse.ExecutionCourseBaseAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Input;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(path="/teachersManagerDA", module="teacher", functionality=ManageExecutionCourseDA.class)
@Forwards(value={@Forward(name="viewTeachers_bd", path="/teacher/viewTeachers_bd.jsp"), @Forward(name="viewProfessorshipProperties", path="/teacher/viewProfessorshipProperties.jsp"), @Forward(name="associateTeacher_bd", path="/teacher/associateTeacher_bd.jsp")})
public class TeachersManagerDA
extends ExecutionCourseBaseAction {
    public ActionForward viewTeachersByProfessorship(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("viewTeachers_bd");
    }

    public ActionForward viewProfessorshipProperties(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("professorship", this.getDomainObject(request, "teacherOID"));
        return mapping.findForward("viewProfessorshipProperties");
    }

    public ActionForward removeTeacher(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Professorship professorship = (Professorship)((Object)this.getDomainObject(request, "teacherOID"));
        try {
            DeleteProfessorshipWithPerson.run(professorship.getPerson(), this.getExecutionCourse(request));
        }
        catch (NotAuthorizedException e) {
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add("error", new ActionMessage("label.not.authorized.action"));
            this.saveErrors(request, (ActionMessages)actionErrors);
        }
        catch (DomainException domainException) {
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add("error", new ActionMessage(domainException.getMessage()));
            this.saveErrors(request, (ActionMessages)actionErrors);
        }
        return this.viewTeachersByProfessorship(mapping, form, request, response);
    }

    @Input
    public ActionForward prepareAssociateTeacher(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("associateTeacher_bd");
    }

    public ActionForward associateTeacher(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        if (this.isCancelled(request)) {
            RenderUtils.invalidateViewState();
            return this.prepareAssociateTeacher(mapping, form, request, response);
        }
        Person person = Person.readPersonByUsername(request.getParameter("teacherId"));
        ExecutionCourse executionCourse = this.getExecutionCourse(request);
        if (person != null) {
            if (person.getTeacher() == null || !person.getTeacher().hasTeacherAuthorization(executionCourse.getAcademicInterval())) {
                ActionErrors actionErrors = new ActionErrors();
                actionErrors.add("error", new ActionMessage("label.invalid.teacher.without.auth"));
                this.saveErrors(request, (ActionMessages)actionErrors);
                return this.prepareAssociateTeacher(mapping, form, request, response);
            }
        } else {
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add("error", new ActionMessage("label.invalid.teacher.number"));
            this.saveErrors(request, (ActionMessages)actionErrors);
            return this.prepareAssociateTeacher(mapping, form, request, response);
        }
        Professorship professorship = Professorship.create(false, executionCourse, person);
        request.setAttribute("teacherOID", (Object)professorship.getExternalId());
        return this.viewProfessorshipProperties(mapping, form, request, response);
    }
}

