/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student.administrativeOfficeServices;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.student.administrativeOfficeServices.StudentAcademicOfficeServices;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;

@StrutsFunctionality(app=StudentAcademicOfficeServices.class, path="payments", titleKey="link.title.payments")
@Mapping(module="student", path="/payments")
@Forwards(value={@Forward(name="showEvents", path="/student/administrativeOfficeServices/payments/showStudentEvents.jsp"), @Forward(name="showEventDetails", path="/student/administrativeOfficeServices/payments/showEventDetails.jsp")})
public class StudentPaymentsDispatchAction
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward showEvents(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Person person = StudentPaymentsDispatchAction.getUserView(request).getPerson();
        request.setAttribute("person", (Object)person);
        request.setAttribute("notPayedEvents", this.calculateNotPayedEvents(person));
        request.setAttribute("payedEntries", person.getPayments());
        request.setAttribute("totalPayed", (Object)person.getTotalPaymentsAmountWithAdjustment());
        return mapping.findForward("showEvents");
    }

    private List<Event> calculateNotPayedEvents(Person person) {
        ArrayList<Event> result = new ArrayList<Event>();
        result.addAll(person.getNotPayedEventsPayableOn(null, false));
        result.addAll(person.getNotPayedEventsPayableOn(null, true));
        return result;
    }

    public ActionForward showEventDetails(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Event event = this.readEvent(request);
        request.setAttribute("person", (Object)StudentPaymentsDispatchAction.getUserView(request).getPerson());
        request.setAttribute("event", (Object)event);
        request.setAttribute("entryDTOs", event.calculateEntries());
        request.setAttribute("accountingEventPaymentCodes", event.getNonProcessedPaymentCodes());
        return mapping.findForward("showEventDetails");
    }

    private Event readEvent(HttpServletRequest request) {
        Person person = StudentPaymentsDispatchAction.getUserView(request).getPerson();
        String eventId = this.getStringFromRequest(request, "eventId");
        for (Event event : person.getEventsSet()) {
            if (!event.getExternalId().equals(eventId)) continue;
            return event;
        }
        return null;
    }
}

