/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.publico.alumni;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Alumni;
import org.fenixedu.academic.domain.AlumniRequestType;
import org.fenixedu.academic.domain.Installation;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.alumni.AlumniIdentityCheckRequestBean;
import org.fenixedu.academic.dto.alumni.publicAccess.AlumniLinkRequestBean;
import org.fenixedu.academic.dto.alumni.publicAccess.AlumniPasswordBean;
import org.fenixedu.academic.dto.alumni.publicAccess.AlumniPublicAccessBean;
import org.fenixedu.academic.service.services.alumni.RegisterAlumniData;
import org.fenixedu.academic.service.services.commons.alumni.AlumniNotificationService;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.publico.KaptchaAction;
import org.fenixedu.academic.ui.struts.action.publico.PublicApplication;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=PublicApplication.class, path="alumni", titleKey="label.alumni.main.title", bundle="AlumniResources")
@Mapping(module="publico", path="/alumni")
@Forwards(value={@Forward(name="alumniPublicAccessInner", path="/publico/alumni/alumniPublicAccessInner.jsp"), @Forward(name="alumniCreatePasswordRequest", path="/publico/alumni/alumniCreatePasswordRequest.jsp"), @Forward(name="alumniPublicAccessInformationInquiry", path="/publico/alumni/alumniPublicAccessInformationInquiry.jsp"), @Forward(name="alumniPublicAccessIdentityCheck", path="/publico/alumni/alumniPublicAccessIdentityCheck.jsp"), @Forward(name="alumniPublicAccess", path="/publico/alumni/alumniPublicAccess.jsp"), @Forward(name="alumniErrorSendMail", path="/publico/alumni/alumniPublicAccessErrorSendMail.jsp"), @Forward(name="alumniRegistrationResult", path="/publico/alumni/alumniRegistrationResult.jsp"), @Forward(name="alumniPasswordRequired", path="/publico/alumni/alumniPasswordRequired.jsp"), @Forward(name="alumniPublicAccessMessage", path="/publico/alumni/alumniPublicAccessMessage.jsp"), @Forward(name="alumniPublicAccessRegistrationEmail", path="/publico/alumni/alumniPublicAccessRegistrationEmail.jsp")})
public class AlumniPublicAccessDA
extends FenixDispatchAction {
    private static final Logger logger = LoggerFactory.getLogger(AlumniPublicAccessDA.class);

    @EntryPoint
    public ActionForward initFenixPublicAccess(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.getSession(true);
        if (this.getFromRequest(request, "showForm") != null) {
            request.setAttribute("showForm", (Object)"true");
            request.setAttribute("alumniBean", this.getFromRequest(request, "alumniBean"));
        } else {
            request.setAttribute("showForm", (Object)"false");
            request.setAttribute("alumniBean", (Object)new AlumniLinkRequestBean());
        }
        return mapping.findForward("alumniPublicAccess");
    }

    public ActionForward requestIdentityCheck(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("alumniBean", (Object)new AlumniIdentityCheckRequestBean(AlumniRequestType.STUDENT_NUMBER_RECOVERY));
        return mapping.findForward("alumniPublicAccessIdentityCheck");
    }

    public ActionForward processRequestIdentityCheckError(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("alumniBean", this.getFromRequest(request, "alumniBean"));
        return mapping.findForward("alumniPublicAccessIdentityCheck");
    }

    public ActionForward processRequestIdentityCheck(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.validateCaptcha(mapping, request)) {
            return this.requestIdentityCheck(mapping, actionForm, request, response);
        }
        try {
            RegisterAlumniData.run((AlumniIdentityCheckRequestBean)this.getObjectFromViewState("alumniBean"));
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
            return this.processRequestIdentityCheckError(mapping, actionForm, request, response);
        }
        request.setAttribute("alumniPublicAccessTitle", (Object)"identity.check.request.successful.creation.title");
        request.setAttribute("alumniPublicAccessMessage", (Object)"identity.check.request.successful.creation.message");
        return mapping.findForward("alumniPublicAccessMessage");
    }

    private boolean validateCaptcha(ActionMapping mapping, HttpServletRequest request) {
        String captchaResponse = request.getParameter("j_captcha_response");
        try {
            if (!KaptchaAction.validateResponse(request.getSession(), captchaResponse)) {
                this.addActionMessage("error", request, "captcha.wrong.word");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            request.setAttribute("captcha.unknown.error", (Object)"captcha.unknown.error");
            request.setAttribute("showForm", (Object)"true");
            request.setAttribute("alumniBean", this.getObjectFromViewState("alumniBean"));
            return false;
        }
    }

    public ActionForward validateFenixAcessData(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AlumniLinkRequestBean alumniBean = (AlumniLinkRequestBean)this.getObjectFromViewState("alumniBean");
        if (!alumniBean.getPrivacyPolicy().booleanValue()) {
            request.setAttribute("showForm", (Object)"true");
            request.setAttribute("privacyPolicyPublicAccessMessage", (Object)"privacy.policy.acceptance");
            request.setAttribute("alumniBean", (Object)alumniBean);
            return mapping.findForward("alumniPublicAccess");
        }
        if (!this.validateCaptcha(mapping, request)) {
            return mapping.findForward("alumniPublicAccess");
        }
        try {
            Alumni alumni = RegisterAlumniData.run(alumniBean.getStudentNumber(), alumniBean.getDocumentIdNumber().trim(), alumniBean.getEmail());
            String url = AlumniNotificationService.getRegisterConclusionURL(alumni);
            request.setAttribute("alumniEmailSuccessMessage", (Object)("http" + url.split("http")[1]));
            request.setAttribute("alumni", (Object)alumni);
        }
        catch (DomainException e) {
            if ("error.no.registrations".equals(e.getKey())) {
                request.setAttribute("showReportError", (Object)"true");
                String alumniEmail = Installation.getInstance().getInstituitionalEmailAddress("alumni");
                request.setAttribute("errorMessage", (Object)this.getResources(request).getMessage(e.getKey(), (Object)e.getArgs(), (Object)alumniEmail));
            } else if ("error.no.concluded.registrations".equals(e.getKey()) || "error.person.no.student".equals(e.getKey())) {
                request.setAttribute("showReportError", (Object)"true");
                request.setAttribute("errorMessage", (Object)this.getResources(request).getMessage(e.getKey(), (Object[])e.getArgs()));
            }
            this.addActionMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("showForm", (Object)"true");
            request.setAttribute("alumniBean", (Object)alumniBean);
            return mapping.findForward("alumniPublicAccess");
        }
        return mapping.findForward("alumniPublicAccessRegistrationEmail");
    }

    public ActionForward innerFenixPublicAccessValidation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String alumniId = BundleUtil.getString((String)"resources.AlumniResources", (String)"alumni.public.registration.first.argument", (String[])new String[0]);
        String urlToken = BundleUtil.getString((String)"resources.AlumniResources", (String)"alumni.public.registration.second.argument", (String[])new String[0]);
        Alumni alumni = (Alumni)((Object)this.getDomainObject(request, alumniId));
        if (StringUtils.isEmpty((String)alumniId) || StringUtils.isEmpty((String)urlToken) || alumni == null) {
            request.setAttribute("alumniPublicAccessTitle", (Object)"registration.error.old.request.link.title");
            request.setAttribute("alumniPublicAccessMessage", (Object)"error.alumni.wrong.arguments");
            return mapping.findForward("alumniPublicAccessMessage");
        }
        if (alumni.isRegistered() && !alumni.isRecoveringPassword()) {
            request.setAttribute("alumniPublicAccessTitle", (Object)"registration.error.old.request.link.title");
            request.setAttribute("alumniPublicAccessMessage", (Object)"error.alumni.already.registered");
            return mapping.findForward("alumniPublicAccessMessage");
        }
        if (!alumni.getUrlRequestToken().equals(UUID.fromString(request.getParameter(urlToken)))) {
            request.setAttribute("alumniPublicAccessTitle", (Object)"registration.error.old.request.link.title");
            request.setAttribute("alumniPublicAccessMessage", (Object)"registration.error.old.request.link.message");
            return mapping.findForward("alumniPublicAccessMessage");
        }
        request.setAttribute("alumniBean", (Object)new AlumniLinkRequestBean(alumni));
        request.setAttribute("alumniId", this.getFromRequest(request, alumniId));
        request.setAttribute("urlToken", (Object)request.getParameter(urlToken));
        return mapping.findForward("alumniPublicAccessInner");
    }

    public ActionForward registrationConclusion(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Alumni alumni = ((AlumniLinkRequestBean)this.getObjectFromViewState("alumniBean")).getAlumni();
        RenderUtils.invalidateViewState();
        alumni.validateEmailFromRegistrationProcess();
        if (alumni.hasPastLogin()) {
            try {
                RegisterAlumniData.run(alumni, Boolean.TRUE);
                request.setAttribute("loginAlias", (Object)alumni.getLoginUsername());
                request.setAttribute("registrationResult", (Object)"true");
            }
            catch (FenixServiceException e) {
                request.setAttribute("registrationResult", (Object)"false");
            }
            request.setAttribute("passwordAccessBean", (Object)new AlumniPasswordBean(alumni));
            request.setAttribute("alumni", (Object)alumni);
            return mapping.findForward("alumniRegistrationResult");
        }
        request.setAttribute("passwordAccessBean", (Object)new AlumniPasswordBean(alumni, AlumniRequestType.PASSWORD_REQUEST));
        if (alumni.hasAnyPendingIdentityRequests()) {
            request.setAttribute("pendingRequests", (Object)"true");
        }
        return mapping.findForward("alumniCreatePasswordRequest");
    }

    public ActionForward createPasswordRequestInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("publicAccessBean", this.getObjectFromViewState("publicAccessBean"));
        return mapping.findForward("alumniCreatePasswordRequest");
    }

    public ActionForward createPasswordRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AlumniPasswordBean alumniBean = (AlumniPasswordBean)this.getObjectFromViewState("passwordAccessBean");
        try {
            RegisterAlumniData.run(alumniBean);
            request.setAttribute("loginAlias", (Object)alumniBean.getAlumni().getLoginUsername());
            request.setAttribute("registrationResult", (Object)"true");
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getKey());
            request.setAttribute("registrationResult", (Object)"false");
            return mapping.findForward("alumniCreatePasswordRequest");
        }
        request.setAttribute("publicAccessBean", (Object)new AlumniPublicAccessBean(alumniBean.getAlumni()));
        request.setAttribute("alumni", (Object)alumniBean.getAlumni());
        return mapping.findForward("alumniPasswordRequired");
    }
}

