/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.candidacy.publicProgram.institution;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PublicCandidacyHashCode;
import org.fenixedu.academic.domain.QualificationBean;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessBean;
import org.fenixedu.academic.domain.phd.PhdParticipantBean;
import org.fenixedu.academic.domain.phd.PhdProgramCandidacyProcessState;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.candidacy.InstitutionPhdCandidacyPeriod;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyPeriod;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyReferee;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeBean;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetterBean;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcessBean;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramPublicCandidacyHashCode;
import org.fenixedu.academic.domain.phd.candidacy.activities.RemoveCandidacyDocument;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddAssistantGuidingInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddCandidacyReferees;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddGuidingsInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddQualification;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteAssistantGuiding;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteGuiding;
import org.fenixedu.academic.domain.phd.individualProcess.activities.EditIndividualProcessInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.EditPersonalInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.RemoveCandidacyReferee;
import org.fenixedu.academic.domain.phd.individualProcess.activities.UploadDocuments;
import org.fenixedu.academic.domain.phd.individualProcess.activities.ValidatedByCandidate;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.dto.person.PhotographUploadBean;
import org.fenixedu.academic.service.services.caseHandling.CreateNewProcess;
import org.fenixedu.academic.service.services.caseHandling.ExecuteProcessActivity;
import org.fenixedu.academic.service.services.fileManager.UploadOwnPhoto;
import org.fenixedu.academic.service.services.person.qualification.DeleteQualification;
import org.fenixedu.academic.ui.struts.action.phd.candidacy.publicProgram.PublicPhdProgramCandidacyProcessDA;
import org.fenixedu.academic.ui.struts.action.publico.PublicApplication;
import org.fenixedu.academic.util.ContentType;
import org.fenixedu.academic.util.phd.InstitutionPhdCandidacyProcessProperties;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.i18n.I18N;
import org.joda.time.DateTime;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=PublicApplication.PublicPhdApp.class, path="candidacy", titleKey="title.public.phd.program.candidacy")
@Mapping(path="/applications/phd/phdProgramApplicationProcess", module="publico")
@Forwards(value={@Forward(name="outOfCandidacyPeriod", path="/phd/candidacy/publicProgram/institution/outOfCandidacyPeriod.jsp"), @Forward(name="createIdentification", path="/phd/candidacy/publicProgram/institution/createIdentification.jsp"), @Forward(name="createIdentificationSuccess", path="/phd/candidacy/publicProgram/institution/createIdentificationSuccess.jsp"), @Forward(name="applicationSubmissionGuide", path="/phd/candidacy/publicProgram/institution/applicationSubmissionGuide.jsp"), @Forward(name="fillPersonalData", path="/phd/candidacy/publicProgram/institution/fillPersonalData.jsp"), @Forward(name="fillPhdProgramData", path="/phd/candidacy/publicProgram/institution/fillPhdProgramData.jsp"), @Forward(name="applicationCreationReport", path="/phd/candidacy/publicProgram/institution/applicationCreationReport.jsp"), @Forward(name="view", path="/phd/candidacy/publicProgram/institution/view.jsp"), @Forward(name="editPersonalData", path="/phd/candidacy/publicProgram/institution/editPersonalData.jsp"), @Forward(name="editPhdInformationData", path="/phd/candidacy/publicProgram/institution/editPhdInformationData.jsp"), @Forward(name="editQualifications", path="/phd/candidacy/publicProgram/institution/editQualifications.jsp"), @Forward(name="uploadDocuments", path="/phd/candidacy/publicProgram/institution/uploadDocuments.jsp"), @Forward(name="editReferees", path="/phd/candidacy/publicProgram/institution/editReferees.jsp"), @Forward(name="createRefereeLetter", path="/phd/candidacy/publicProgram/institution/createRefereeLetter.jsp"), @Forward(name="createRefereeLetterSuccess", path="/phd/candidacy/publicProgram/institution/createRefereeLetterSuccess.jsp"), @Forward(name="editGuidings", path="/phd/candidacy/publicProgram/institution/editGuidings.jsp"), @Forward(name="validateApplication", path="/phd/candidacy/publicProgram/institution/validateApplication.jsp"), @Forward(name="uploadPhoto", path="/phd/candidacy/publicProgram/institution/uploadPhoto.jsp"), @Forward(name="identificationRecovery", path="/phd/candidacy/publicProgram/institution/identificationRecovery.jsp"), @Forward(name="emailSentForIdentificationRecovery", path="/phd/candidacy/publicProgram/institution/emailSentForIdentificationRecovery.jsp")})
public class PublicInstitutionPhdProgramsCandidacyProcessDA
extends PublicPhdProgramCandidacyProcessDA {
    private static final List<String> DO_NOT_VALIDATE_CANDIDACY_PERIOD_IN_METHODS = Arrays.asList("viewCandidacy", "backToViewCandidacy", "prepareCreateRefereeLetter", "createRefereeLetterInvalid", "createRefereeLetter");

    @Override
    protected ActionForward filterDispatchMethod(PhdProgramCandidacyProcessBean bean, ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PhdProgramPublicCandidacyHashCode hashCode = bean != null ? bean.getCandidacyHashCode() : null;
        String methodName = this.getMethodName(mapping, actionForm, request, response, mapping.getParameter());
        if ((methodName == null || !DO_NOT_VALIDATE_CANDIDACY_PERIOD_IN_METHODS.contains(methodName)) && this.isOutOfCandidacyPeriod(hashCode)) {
            InstitutionPhdCandidacyPeriod nextCandidacyPeriod = InstitutionPhdCandidacyPeriod.readNextCandidacyPeriod();
            request.setAttribute("candidacyPeriod", (Object)this.getPhdCandidacyPeriod(hashCode));
            request.setAttribute("nextCandidacyPeriod", (Object)nextCandidacyPeriod);
            return mapping.findForward("outOfCandidacyPeriod");
        }
        return null;
    }

    private boolean isOutOfCandidacyPeriod(PhdProgramPublicCandidacyHashCode hashCode) {
        PhdCandidacyPeriod phdCandidacyPeriod = this.getPhdCandidacyPeriod(hashCode);
        return phdCandidacyPeriod == null || !phdCandidacyPeriod.contains(new DateTime());
    }

    private PhdCandidacyPeriod getPhdCandidacyPeriod(PhdProgramPublicCandidacyHashCode hashCode) {
        DateTime date = hashCode != null && hashCode.hasCandidacyProcess() ? hashCode.getPhdProgramCandidacyProcess().getCandidacyDate().toDateMidnight().toDateTime() : new DateTime();
        return InstitutionPhdCandidacyPeriod.readInstitutionPhdCandidacyPeriodForDate(date);
    }

    @EntryPoint
    public ActionForward prepareCreateIdentification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String hash = request.getParameter("hash");
        PhdProgramPublicCandidacyHashCode hashCode = (PhdProgramPublicCandidacyHashCode)((Object)PublicCandidacyHashCode.getPublicCandidacyCodeByHash(hash));
        if (hashCode != null) {
            return this.viewCandidacy(mapping, form, request, response, hashCode);
        }
        request.setAttribute("candidacyBean", (Object)new PhdProgramCandidacyProcessBean());
        return mapping.findForward("createIdentification");
    }

    public ActionForward createIdentificationInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", this.getRenderedObject("candidacyBean"));
        return mapping.findForward("createIdentification");
    }

    public ActionForward createIdentification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        if (bean == null) {
            return this.prepareCreateIdentification(mapping, form, request, response);
        }
        PhdProgramPublicCandidacyHashCode hashCode = PhdProgramPublicCandidacyHashCode.getOrCreatePhdProgramCandidacyHashCode(bean.getEmail());
        if (hashCode.hasCandidacyProcess() && hashCode.getPhdProgramCandidacyProcess().getCandidacy().getDegreeCurricularPlan().equals((Object)bean.getProcess().getCandidacy().getDegreeCurricularPlan())) {
            this.addErrorMessage(request, "error.PhdProgramPublicCandidacyHashCode.already.has.candidacy", new String[0]);
            return this.prepareCreateIdentification(mapping, form, request, response);
        }
        this.sendSubmissionEmailForCandidacy((PublicCandidacyHashCode)((Object)hashCode), request);
        String url = String.format("%s?hash=%s", InstitutionPhdCandidacyProcessProperties.getPublicCandidacySubmissionLink(I18N.getLocale()), hashCode.getValue());
        request.setAttribute("processLink", (Object)url);
        return mapping.findForward("createIdentificationSuccess");
    }

    private void sendSubmissionEmailForCandidacy(PublicCandidacyHashCode hashCode, HttpServletRequest request) {
        String subject = BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.institution.application.email.subject.send.link.to.submission", (String[])new String[]{Unit.getInstitutionAcronym()});
        String body = BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.institution.email.body.send.link.to.submission", (String[])new String[]{Unit.getInstitutionAcronym()});
        hashCode.sendEmail(subject, String.format(body, InstitutionPhdCandidacyProcessProperties.getPublicCandidacySubmissionLink(I18N.getLocale()), hashCode.getValue()));
    }

    public ActionForward prepareIdentificationRecovery(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", (Object)new PhdProgramCandidacyProcessBean());
        return mapping.findForward("identificationRecovery");
    }

    public ActionForward identificationRecoveryInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        return mapping.findForward("identificationRecovery");
    }

    public ActionForward identificationRecovery(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        PhdProgramPublicCandidacyHashCode hashCode = PhdProgramPublicCandidacyHashCode.getPhdProgramCandidacyHashCode(bean.getEmail(), bean.getProgram());
        if (hashCode != null) {
            if (hashCode.hasCandidacyProcess()) {
                this.sendRecoveryEmailForCandidate(hashCode, request);
            } else {
                this.sendSubmissionEmailForCandidacy((PublicCandidacyHashCode)((Object)hashCode), request);
            }
        }
        return mapping.findForward("emailSentForIdentificationRecovery");
    }

    private void sendRecoveryEmailForCandidate(PhdProgramPublicCandidacyHashCode candidacyHashCode, HttpServletRequest request) {
        String subject = BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.email.subject.recovery.access", (String[])new String[]{Unit.getInstitutionAcronym()});
        String body = BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.institution.email.body.recovery.access", (String[])new String[]{Unit.getInstitutionAcronym()});
        candidacyHashCode.sendEmail(subject, String.format(body, InstitutionPhdCandidacyProcessProperties.getPublicCandidacyAccessLink(I18N.getLocale()), candidacyHashCode.getValue()));
    }

    public ActionForward beginSubmission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("applicationSubmissionGuide");
    }

    public ActionForward prepareFillPersonalData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramPublicCandidacyHashCode hashCode = (PhdProgramPublicCandidacyHashCode)((Object)PublicCandidacyHashCode.getPublicCandidacyCodeByHash(request.getParameter("hash")));
        if (hashCode == null) {
            return this.prepareCreateIdentification(mapping, form, request, response);
        }
        if (hashCode.hasCandidacyProcess()) {
            return this.viewCandidacy(mapping, form, request, response, hashCode);
        }
        PhdProgramCandidacyProcessBean bean = new PhdProgramCandidacyProcessBean();
        PhdCandidacyPeriod phdCandidacyPeriod = this.getPhdCandidacyPeriod(hashCode);
        bean.setPersonBean(new PersonBean());
        bean.getPersonBean().setEmail(hashCode.getEmail());
        bean.setCandidacyHashCode(hashCode);
        bean.setExecutionYear(phdCandidacyPeriod.getExecutionInterval());
        bean.setState(PhdProgramCandidacyProcessState.PRE_CANDIDATE);
        bean.setMigratedProcess(Boolean.FALSE);
        bean.setPhdCandidacyPeriod(phdCandidacyPeriod);
        request.setAttribute("candidacyBean", (Object)bean);
        return mapping.findForward("fillPersonalData");
    }

    @Override
    public ActionForward fillPersonalDataInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        return mapping.findForward("fillPersonalData");
    }

    private ActionForward returnToPersonalData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        return mapping.findForward("fillPersonalData");
    }

    private ActionForward prepareFillPhdProgramData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        return mapping.findForward("fillPhdProgramData");
    }

    private ActionForward fillPhdProgramDataInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        return mapping.findForward("fillPhdProgramData");
    }

    private ActionForward fillPhdProgramDataPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        return mapping.findForward("fillPhdProgramData");
    }

    public ActionForward createApplication(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward checkPersonalDataForward = this.checkPersonalData(mapping, form, request, response);
        if (checkPersonalDataForward != null) {
            return checkPersonalDataForward;
        }
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        if (PhdProgramPublicCandidacyHashCode.getPhdProgramCandidacyHashCode(bean.getCandidacyHashCode().getEmail(), bean.getProgram()) != null) {
            this.addErrorMessage(request, "error.PhdProgramPublicCandidacyHashCode.already.has.candidacy", new String[0]);
            return this.fillPersonalDataInvalid(mapping, form, request, response);
        }
        PhdIndividualProgramProcess process2 = (PhdIndividualProgramProcess)((Object)CreateNewProcess.run(PhdIndividualProgramProcess.PublicPhdIndividualProgramProcess.class, (Object)bean));
        this.sendApplicationSuccessfullySubmitedEmail(bean.getCandidacyHashCode(), request);
        request.setAttribute("phdIndividualProgramProcess", (Object)process2);
        request.setAttribute("candidacyHashCode", (Object)bean.getCandidacyHashCode());
        PhdProgramPublicCandidacyHashCode candidacyProcessHashCode = process2.getCandidacyProcessHashCode();
        String processLink = InstitutionPhdCandidacyProcessProperties.getPublicCandidacyAccessLink(candidacyProcessHashCode, I18N.getLocale());
        request.setAttribute("processLink", (Object)processLink);
        return mapping.findForward("applicationCreationReport");
    }

    private void sendApplicationSuccessfullySubmitedEmail(PhdProgramPublicCandidacyHashCode hashCode, HttpServletRequest request) {
        String subject = BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.institution.email.subject.application.submited", (String[])new String[]{Unit.getInstitutionAcronym()});
        String body = BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.institution.email.body.application.submited", (String[])new String[]{Unit.getInstitutionAcronym()});
        hashCode.sendEmail(subject, String.format(body, hashCode.getPhdProgramCandidacyProcess().getProcessNumber(), InstitutionPhdCandidacyProcessProperties.getPublicCandidacyAccessLink(I18N.getLocale()), hashCode.getValue()));
    }

    public ActionForward viewApplication(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.viewCandidacy(mapping, form, request, response, (PhdProgramPublicCandidacyHashCode)((Object)PublicCandidacyHashCode.getPublicCandidacyCodeByHash(request.getParameter("hash"))));
    }

    private ActionForward viewCandidacy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, PhdProgramPublicCandidacyHashCode hashCode) {
        if (hashCode == null || !hashCode.hasCandidacyProcess()) {
            return this.prepareFillPersonalData(mapping, form, request, response);
        }
        PhdIndividualProgramProcess individualProgramProcess = hashCode.getIndividualProgramProcess();
        request.setAttribute("process", (Object)individualProgramProcess.getCandidacyProcess());
        this.canEditCandidacy(request, hashCode);
        this.canEditPersonalInformation(request, hashCode.getPerson());
        PersonBean personBean = new PersonBean(individualProgramProcess.getPerson());
        this.initPersonBeanUglyHack(personBean, individualProgramProcess.getPerson());
        request.setAttribute("personBean", (Object)personBean);
        this.validateProcess(request, individualProgramProcess);
        return mapping.findForward("view");
    }

    private boolean validateProcess(HttpServletRequest request, PhdIndividualProgramProcess process2) {
        boolean result = true;
        return this.validateProcessDocuments(request, process2) && result;
    }

    private boolean validateProcessDocuments(HttpServletRequest request, PhdIndividualProgramProcess process2) {
        boolean result = true;
        boolean hasPaymentFees = process2.getCandidacyProcess().hasPaymentCodeToPay();
        request.setAttribute("hasPaymentFees", (Object)hasPaymentFees);
        int totalDocuments = 5;
        if (!hasPaymentFees) {
            totalDocuments = 4;
        }
        BigDecimal numberOfDocumentsToSubmit = new BigDecimal(totalDocuments + process2.getQualifications().size());
        BigDecimal numberOfDocumentsSubmitted = new BigDecimal(0);
        if (!process2.hasCandidacyProcessDocument(PhdIndividualProgramDocumentType.ID_DOCUMENT)) {
            this.addValidationMessage(request, "message.validation.missing.id.document", new String[0]);
            result &= false;
        } else {
            numberOfDocumentsSubmitted = numberOfDocumentsSubmitted.add(new BigDecimal(1));
        }
        if (hasPaymentFees) {
            if (!process2.hasCandidacyProcessDocument(PhdIndividualProgramDocumentType.PAYMENT_DOCUMENT)) {
                this.addValidationMessage(request, "message.validation.missing.payment.document", new String[0]);
                result &= false;
            } else {
                numberOfDocumentsSubmitted = numberOfDocumentsSubmitted.add(new BigDecimal(1));
            }
        }
        if (!process2.hasCandidacyProcessDocument(PhdIndividualProgramDocumentType.SOCIAL_SECURITY)) {
            this.addValidationMessage(request, "message.validation.missing.social.security.document", new String[0]);
            result &= false;
        } else {
            numberOfDocumentsSubmitted = numberOfDocumentsSubmitted.add(new BigDecimal(1));
        }
        if (!process2.hasCandidacyProcessDocument(PhdIndividualProgramDocumentType.CV)) {
            this.addValidationMessage(request, "message.validation.missing.cv", new String[0]);
            result &= false;
        } else {
            numberOfDocumentsSubmitted = numberOfDocumentsSubmitted.add(new BigDecimal(1));
        }
        if (process2.getCandidacyProcessDocumentsCount(PhdIndividualProgramDocumentType.HABILITATION_CERTIFICATE_DOCUMENT) < process2.getQualifications().size()) {
            this.addValidationMessage(request, "message.validation.missing.qualification.documents", String.valueOf(process2.getQualifications().size()));
            result &= false;
        } else {
            numberOfDocumentsSubmitted = numberOfDocumentsSubmitted.add(new BigDecimal(process2.getCandidacyProcessDocumentsCount(PhdIndividualProgramDocumentType.HABILITATION_CERTIFICATE_DOCUMENT)));
        }
        if (!process2.hasCandidacyProcessDocument(PhdIndividualProgramDocumentType.MOTIVATION_LETTER)) {
            this.addValidationMessage(request, "message.validation.missing.motivation.letter", new String[0]);
            result &= false;
        } else {
            numberOfDocumentsSubmitted = numberOfDocumentsSubmitted.add(new BigDecimal(1));
        }
        request.setAttribute("documentsSubmittedPercentage", (Object)numberOfDocumentsSubmitted.divide(numberOfDocumentsToSubmit, 2, RoundingMode.HALF_EVEN).multiply(new BigDecimal(100)).intValue());
        request.setAttribute("numberOfDocumentsToSubmit", (Object)numberOfDocumentsToSubmit.intValue());
        request.setAttribute("numberOfDocumentsSubmitted", (Object)numberOfDocumentsSubmitted.intValue());
        return result;
    }

    public ActionForward prepareEditPersonalData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        PhdProgramCandidacyProcessBean bean = new PhdProgramCandidacyProcessBean(process2);
        Person person = process2.getPerson();
        PersonBean personBean = new PersonBean(person);
        bean.setPersonBean(personBean);
        this.initPersonBeanUglyHack(personBean, person);
        this.canEditCandidacy(request, process2.getCandidacyHashCode());
        this.canEditPersonalInformation(request, person);
        request.setAttribute("candidacyBean", (Object)bean);
        return mapping.findForward("editPersonalData");
    }

    public ActionForward editPersonalDataInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        PhdProgramCandidacyProcessBean candidacyBean = this.getCandidacyBean();
        request.setAttribute("candidacyBean", (Object)candidacyBean);
        this.canEditCandidacy(request, process2.getCandidacyHashCode());
        this.canEditPersonalInformation(request, process2.getPerson());
        return mapping.findForward("editPersonalData");
    }

    public ActionForward editPersonalData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        this.canEditCandidacy(request, process2.getCandidacyHashCode());
        this.canEditPersonalInformation(request, process2.getPerson());
        try {
            ExecuteProcessActivity.run((Process)((Object)process2.getIndividualProgramProcess()), EditPersonalInformation.class, (Object)bean.getPersonBean());
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("candidacyBean", (Object)bean);
            return mapping.findForward("editPersonalData");
        }
        return this.viewCandidacy(mapping, form, request, response, process2.getCandidacyHashCode());
    }

    public ActionForward prepareEditPhdInformationData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        PhdProgramCandidacyProcessBean candidacyBean = new PhdProgramCandidacyProcessBean(process2);
        request.setAttribute("candidacyBean", (Object)candidacyBean);
        request.setAttribute("individualProcessBean", (Object)new PhdIndividualProgramProcessBean(process2.getIndividualProgramProcess()));
        this.canEditCandidacy(request, process2.getCandidacyHashCode());
        return mapping.findForward("editPhdInformationData");
    }

    public ActionForward prepareEditPhdInformationDataFocusAreaPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        PhdProgramCandidacyProcessBean candidacyBean = this.getCandidacyBean();
        PhdIndividualProgramProcessBean bean = this.getIndividualProcessBean();
        request.setAttribute("candidacyBean", (Object)candidacyBean);
        request.setAttribute("individualProcessBean", (Object)bean);
        this.canEditCandidacy(request, process2.getCandidacyHashCode());
        return mapping.findForward("editPhdInformationData");
    }

    public ActionForward editPhdInformationDataInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        PhdProgramCandidacyProcessBean candidacyBean = this.getCandidacyBean();
        PhdIndividualProgramProcessBean bean = this.getIndividualProcessBean();
        request.setAttribute("candidacyBean", (Object)candidacyBean);
        request.setAttribute("individualProcessBean", (Object)bean);
        this.canEditCandidacy(request, process2.getCandidacyHashCode());
        return mapping.findForward("editPhdInformationData");
    }

    public ActionForward editPhdInformationData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcessBean bean = this.getIndividualProcessBean();
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        this.canEditCandidacy(request, process2.getCandidacyHashCode());
        try {
            ExecuteProcessActivity.run((Process)((Object)process2.getIndividualProgramProcess()), EditIndividualProcessInformation.class, (Object)bean);
            this.addSuccessMessage(request, "message.phdIndividualProgramProcessInformation.edit.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
            request.setAttribute("individualProcessBean", (Object)bean);
            return mapping.findForward("editPhdInformationData");
        }
        return this.viewCandidacy(mapping, form, request, response, process2.getCandidacyHashCode());
    }

    public ActionForward prepareEditQualifications(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        this.canEditCandidacy(request, process2.getCandidacyHashCode());
        PhdProgramCandidacyProcessBean bean = new PhdProgramCandidacyProcessBean(process2);
        QualificationBean qualificationBean = new QualificationBean();
        request.setAttribute("candidacyBean", (Object)bean);
        request.setAttribute("qualificationBean", (Object)qualificationBean);
        return mapping.findForward("editQualifications");
    }

    public ActionForward editQualificationsInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        QualificationBean qualificationBean = this.getQualificationBean();
        request.setAttribute("candidacyBean", (Object)bean);
        request.setAttribute("qualificationBean", (Object)qualificationBean);
        return this.prepareEditQualifications(mapping, form, request, response);
    }

    public ActionForward addQualification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        this.canEditCandidacy(request, process2.getCandidacyHashCode());
        try {
            ExecuteProcessActivity.run((Process)((Object)process2.getIndividualProgramProcess()), AddQualification.class, (Object)this.getQualificationBean());
            this.addSuccessMessage(request, "message.qualification.information.create.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.editQualificationsInvalid(mapping, form, request, response);
        }
        RenderUtils.invalidateViewState();
        return this.prepareEditQualifications(mapping, form, request, response);
    }

    public ActionForward removeQualification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        this.canEditCandidacy(request, process2.getCandidacyHashCode());
        try {
            ExecuteProcessActivity.run((Process)((Object)process2.getIndividualProgramProcess()), DeleteQualification.class, this.getDomainObject(request, "qualificationId"));
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.editQualificationsInvalid(mapping, form, request, response);
        }
        RenderUtils.invalidateViewState();
        return this.prepareEditQualifications(mapping, form, request, response);
    }

    public ActionForward prepareUploadDocuments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        PhdProgramCandidacyProcessBean bean = new PhdProgramCandidacyProcessBean(process2);
        this.canEditCandidacy(request, process2.getCandidacyHashCode());
        RenderUtils.invalidateViewState();
        request.setAttribute("candidacyBean", (Object)bean);
        request.setAttribute("candidacyProcessDocuments", (Object)process2.getLatestDocumentVersions());
        request.setAttribute("hasPaymentFees", (Object)process2.hasPaymentCodeToPay());
        PhdProgramDocumentUploadBean uploadBean = new PhdProgramDocumentUploadBean();
        uploadBean.setIndividualProgramProcess(process2.getIndividualProgramProcess());
        request.setAttribute("documentByType", (Object)uploadBean);
        this.validateProcessDocuments(request, process2.getIndividualProgramProcess());
        return mapping.findForward("uploadDocuments");
    }

    @Override
    public ActionForward uploadDocumentsInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        PhdProgramDocumentUploadBean uploadBean = this.getUploadBean();
        this.canEditCandidacy(request, process2.getCandidacyHashCode());
        request.setAttribute("candidacyProcessDocuments", (Object)process2.getLatestDocumentVersions());
        request.setAttribute("candidacyBean", (Object)bean);
        request.setAttribute("documentByType", (Object)uploadBean);
        this.validateProcessDocuments(request, process2.getIndividualProgramProcess());
        return mapping.findForward("uploadDocuments");
    }

    @Override
    public ActionForward uploadDocuments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        if (!RenderUtils.getViewState((String)"documentByType").isValid()) {
            return this.uploadDocumentsInvalid(mapping, form, request, response);
        }
        PhdProgramDocumentUploadBean uploadBean = this.getUploadBean();
        if (!uploadBean.hasAnyInformation()) {
            this.addErrorMessage(request, "message.no.documents.to.upload", new String[0]);
            return this.uploadDocumentsInvalid(mapping, form, request, response);
        }
        try {
            ExecuteProcessActivity.run((Process)((Object)process2.getIndividualProgramProcess()), UploadDocuments.class, Collections.singletonList(uploadBean));
            this.addSuccessMessage(request, "message.documents.uploaded.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, "message.no.documents.to.upload", new String[0]);
            return this.uploadDocumentsInvalid(mapping, form, request, response);
        }
        return this.prepareUploadDocuments(mapping, form, request, response);
    }

    public ActionForward removeDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        PhdProgramProcessDocument document = (PhdProgramProcessDocument)((Object)this.getDomainObject(request, "documentId"));
        try {
            ExecuteProcessActivity.run((Process)((Object)process2), RemoveCandidacyDocument.class, (Object)document);
            this.addSuccessMessage(request, "message.documents.uploaded.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, "message.no.documents.to.upload", new String[0]);
            return this.uploadDocumentsInvalid(mapping, form, request, response);
        }
        return this.prepareUploadDocuments(mapping, form, request, response);
    }

    public ActionForward prepareEditReferees(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        PhdProgramCandidacyProcessBean bean = new PhdProgramCandidacyProcessBean(process2);
        this.canEditCandidacy(request, process2.getCandidacyHashCode());
        request.setAttribute("candidacyBean", (Object)bean);
        request.setAttribute("refereeBean", (Object)new PhdCandidacyRefereeBean());
        return mapping.findForward("editReferees");
    }

    public ActionForward addReferee(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        try {
            ExecuteProcessActivity.run((Process)((Object)process2.getIndividualProgramProcess()), AddCandidacyReferees.class, Collections.singletonList(this.getRenderedObject("refereeBean")));
            this.addSuccessMessage(request, "message.referee.information.create.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.editRefereesInvalid(mapping, form, request, response);
        }
        RenderUtils.invalidateViewState();
        return this.prepareEditReferees(mapping, form, request, response);
    }

    public ActionForward editRefereesInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        request.setAttribute("refereeBean", (Object)this.getPhdCandidacyReferee());
        this.canEditCandidacy(request, process2.getCandidacyHashCode());
        return mapping.findForward("editReferees");
    }

    public ActionForward sendCandidacyRefereeEmail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdCandidacyReferee referee = (PhdCandidacyReferee)((Object)this.getDomainObject(request, "candidacyRefereeId"));
        referee.sendEmail();
        this.addSuccessMessage(request, "message.candidacy.referee.email.sent.with.success", referee.getName());
        return this.prepareEditReferees(mapping, form, request, response);
    }

    public ActionForward prepareCreateRefereeLetter(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdCandidacyReferee hashCode = (PhdCandidacyReferee)((Object)PublicCandidacyHashCode.getPublicCandidacyCodeByHash(request.getParameter("hash")));
        request.setAttribute("refereeLetterHash", (Object)hashCode);
        if (hashCode == null) {
            request.setAttribute("no-information", (Object)Boolean.TRUE);
            return mapping.findForward("createRefereeLetterSuccess");
        }
        if (hashCode.getLetter() != null) {
            request.setAttribute("has-letter", (Object)Boolean.TRUE);
            request.setAttribute("letter", (Object)hashCode.getLetter());
            return mapping.findForward("createRefereeLetterSuccess");
        }
        PhdCandidacyRefereeLetterBean bean = new PhdCandidacyRefereeLetterBean();
        bean.setCandidacyReferee(hashCode);
        bean.setRefereeName(hashCode.getName());
        request.setAttribute("createRefereeLetterBean", (Object)bean);
        return mapping.findForward("createRefereeLetter");
    }

    public ActionForward createRefereeLetterInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdCandidacyReferee hashCode = (PhdCandidacyReferee)((Object)PublicCandidacyHashCode.getPublicCandidacyCodeByHash(request.getParameter("hash")));
        request.setAttribute("refereeLetterHash", (Object)hashCode);
        PhdCandidacyRefereeLetterBean bean = new PhdCandidacyRefereeLetterBean();
        bean.setCandidacyReferee(hashCode);
        bean.setRefereeName(hashCode.getName());
        request.setAttribute("createRefereeLetterBean", (Object)bean);
        return mapping.findForward("createRefereeLetter");
    }

    public ActionForward createRefereeLetter(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdCandidacyReferee hashCode = (PhdCandidacyReferee)((Object)PublicCandidacyHashCode.getPublicCandidacyCodeByHash(request.getParameter("hash")));
        request.setAttribute("refereeLetterHash", (Object)hashCode);
        PhdCandidacyRefereeLetterBean bean = (PhdCandidacyRefereeLetterBean)this.getRenderedObject("createRefereeLetterBean");
        if (this.hasAnyRefereeLetterViewStateInvalid()) {
            return this.createRefereeLetterInvalid(mapping, actionForm, request, response);
        }
        try {
            PhdCandidacyRefereeLetter.create(bean);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("createRefereeLetterBean", (Object)bean);
            return mapping.findForward("createRefereeLetter");
        }
        request.setAttribute("created-with-success", (Object)Boolean.TRUE);
        return mapping.findForward("createRefereeLetterSuccess");
    }

    public ActionForward removeReferee(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        PhdCandidacyReferee referee = (PhdCandidacyReferee)((Object)this.getDomainObject(request, "candidacyRefereeId"));
        try {
            ExecuteProcessActivity.run((Process)((Object)process2.getIndividualProgramProcess()), RemoveCandidacyReferee.class, (Object)referee);
            this.addSuccessMessage(request, "message.referee.information.remove.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.editRefereesInvalid(mapping, form, request, response);
        }
        RenderUtils.invalidateViewState();
        return this.prepareEditReferees(mapping, form, request, response);
    }

    public ActionForward prepareEditCandidacyGuidings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        PhdProgramCandidacyProcessBean bean = new PhdProgramCandidacyProcessBean(process2);
        this.canEditCandidacy(request, process2.getCandidacyHashCode());
        request.setAttribute("candidacyBean", (Object)bean);
        PhdParticipantBean guidingBean = new PhdParticipantBean();
        guidingBean.setParticipantType(PhdParticipantBean.PhdParticipantType.EXTERNAL);
        PhdProgramDocumentUploadBean guidingAcceptanceLetter = new PhdProgramDocumentUploadBean();
        guidingAcceptanceLetter.setType(PhdIndividualProgramDocumentType.GUIDER_ACCEPTANCE_LETTER);
        guidingBean.setGuidingAcceptanceLetter(guidingAcceptanceLetter);
        request.setAttribute("guidingBean", (Object)guidingBean);
        PhdParticipantBean assistantGuidingBean = new PhdParticipantBean();
        assistantGuidingBean.setParticipantType(PhdParticipantBean.PhdParticipantType.EXTERNAL);
        PhdProgramDocumentUploadBean assistantGuidingAcceptanceLetter = new PhdProgramDocumentUploadBean();
        assistantGuidingAcceptanceLetter.setType(PhdIndividualProgramDocumentType.ASSISTENT_GUIDER_ACCEPTANCE_LETTER);
        assistantGuidingBean.setGuidingAcceptanceLetter(assistantGuidingAcceptanceLetter);
        request.setAttribute("assistantGuidingBean", (Object)assistantGuidingBean);
        return mapping.findForward("editGuidings");
    }

    public ActionForward addGuiding(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        PhdParticipantBean bean = this.getGuidingBean();
        try {
            ExecuteProcessActivity.run((Process)((Object)process2.getIndividualProgramProcess()), AddGuidingsInformation.class, Collections.singletonList(bean));
            this.addSuccessMessage(request, "message.guiding.created.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.addGuidingInvalid(mapping, form, request, response);
        }
        RenderUtils.invalidateViewState();
        return this.prepareEditCandidacyGuidings(mapping, form, request, response);
    }

    public ActionForward addGuidingInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        request.setAttribute("guidingBean", (Object)this.getGuidingBean());
        request.setAttribute("assistantGuidingBean", (Object)this.getAssistantGuidingBean());
        this.canEditCandidacy(request, process2.getCandidacyHashCode());
        return mapping.findForward("editGuidings");
    }

    public ActionForward addAssistantGuiding(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        PhdParticipantBean bean = this.getAssistantGuidingBean();
        try {
            ExecuteProcessActivity.run((Process)((Object)process2.getIndividualProgramProcess()), AddAssistantGuidingInformation.class, (Object)bean);
            this.addSuccessMessage(request, "message.assistant.guiding.created.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.addGuidingInvalid(mapping, form, request, response);
        }
        RenderUtils.invalidateViewState();
        return this.prepareEditCandidacyGuidings(mapping, form, request, response);
    }

    public ActionForward removeGuiding(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        try {
            ExecuteProcessActivity.run((Process)((Object)process2.getIndividualProgramProcess()), DeleteGuiding.class, this.getDomainObject(request, "guidingId"));
            this.addSuccessMessage(request, "message.guiding.deleted.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
        }
        return this.prepareEditCandidacyGuidings(mapping, form, request, response);
    }

    public ActionForward removeAssistantGuiding(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        try {
            ExecuteProcessActivity.run((Process)((Object)process2.getIndividualProgramProcess()), DeleteAssistantGuiding.class, this.getDomainObject(request, "guidingId"));
            this.addSuccessMessage(request, "message.guiding.deleted.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
        }
        return this.prepareEditCandidacyGuidings(mapping, form, request, response);
    }

    private boolean hasAnyRefereeLetterViewStateInvalid() {
        for (IViewState viewState : this.getViewStatesWithPrefixId("createRefereeLetterBean.")) {
            if (viewState.isValid()) continue;
            return true;
        }
        return false;
    }

    public ActionForward prepareValidateApplication(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        PhdProgramCandidacyProcessBean bean = new PhdProgramCandidacyProcessBean(process2);
        this.canEditCandidacy(request, process2.getCandidacyHashCode());
        this.validateProcess(request, process2.getIndividualProgramProcess());
        request.setAttribute("candidacyBean", (Object)bean);
        return mapping.findForward("validateApplication");
    }

    public ActionForward validateApplication(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        if (!this.validateProcess(request, process2.getIndividualProgramProcess())) {
            return this.prepareValidateApplication(mapping, form, request, response);
        }
        try {
            ExecuteProcessActivity.run((Process)((Object)process2.getIndividualProgramProcess()), ValidatedByCandidate.class, null);
            this.addSuccessMessage(request, "message.validation.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.prepareValidateApplication(mapping, form, request, response);
        }
        return this.viewCandidacy(mapping, form, request, response, process2.getCandidacyHashCode());
    }

    public ActionForward prepareUploadPhoto(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        PhdProgramCandidacyProcessBean bean = new PhdProgramCandidacyProcessBean(process2);
        request.setAttribute("candidacyBean", (Object)bean);
        request.setAttribute("uploadPhotoBean", (Object)new PhotographUploadBean());
        return mapping.findForward("uploadPhoto");
    }

    public ActionForward uploadPhotoInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        request.setAttribute("uploadPhotoBean", this.getRenderedObject("uploadPhotoBean"));
        RenderUtils.invalidateViewState((String)"uploadPhotoBean");
        return mapping.findForward("uploadPhoto");
    }

    public ActionForward uploadPhoto(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        PhotographUploadBean photo = (PhotographUploadBean)this.getRenderedObject("uploadPhotoBean");
        if (!RenderUtils.getViewState((String)"uploadPhotoBean").isValid()) {
            this.addErrorMessage(request, "error.photo.upload.invalid.information", new String[0]);
            return this.uploadPhotoInvalid(mapping, actionForm, request, response);
        }
        if (ContentType.getContentType(photo.getContentType()) == null) {
            this.addErrorMessage(request, "error.photo.upload.unsupported.file", new String[0]);
            return this.uploadPhotoInvalid(mapping, actionForm, request, response);
        }
        try {
            photo.processImage();
            UploadOwnPhoto.upload(photo, bean.getIndividualProgramProcess().getPerson());
        }
        catch (PhotographUploadBean.UnableToProcessTheImage e) {
            this.addErrorMessage(request, "error.photo.upload.unable.to.process.image", new String[0]);
            photo.deleteTemporaryFiles();
            return this.uploadPhotoInvalid(mapping, actionForm, request, response);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            photo.deleteTemporaryFiles();
            return this.uploadPhotoInvalid(mapping, actionForm, request, response);
        }
        return this.viewCandidacy(mapping, actionForm, request, response, bean.getProcess().getCandidacyHashCode());
    }

    private QualificationBean getQualificationBean() {
        return (QualificationBean)this.getRenderedObject("qualificationBean");
    }

    private PhdIndividualProgramProcessBean getIndividualProcessBean() {
        return (PhdIndividualProgramProcessBean)this.getRenderedObject("individualProcessBean");
    }

    private PhdProgramDocumentUploadBean getUploadBean() {
        return (PhdProgramDocumentUploadBean)this.getRenderedObject("documentByType");
    }

    private PhdCandidacyRefereeBean getPhdCandidacyReferee() {
        return (PhdCandidacyRefereeBean)this.getRenderedObject("refereeBean");
    }

    private PhdParticipantBean getGuidingBean() {
        return (PhdParticipantBean)this.getRenderedObject("guidingBean");
    }

    private PhdParticipantBean getAssistantGuidingBean() {
        return (PhdParticipantBean)this.getRenderedObject("assistantGuidingBean");
    }
}

