/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.candidacy.academicAdminOffice;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.candidacy.EPFLPhdCandidacyPeriod;
import org.fenixedu.academic.domain.phd.candidacy.InstitutionPhdCandidacyPeriod;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyPeriod;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyPeriodBean;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminPhdApp.class, path="candidacy-period-management", titleKey="label.phd.candidacy.periods.management", accessGroup="academic(MANAGE_PHD_PROCESSES)")
@Mapping(path="/phdCandidacyPeriodManagement", module="academicAdministration")
@Forwards(value={@Forward(name="list", path="/phd/candidacy/academicAdminOffice/periods/list.jsp"), @Forward(name="createPhdCandidacyPeriod", path="/phd/candidacy/academicAdminOffice/periods/createPhdCandidacyPeriod.jsp"), @Forward(name="editPhdCandidacyPeriod", path="/phd/candidacy/academicAdminOffice/periods/editPhdCandidacyPeriod.jsp"), @Forward(name="view", path="/phd/candidacy/academicAdminOffice/periods/view.jsp")})
public class PhdCandidacyPeriodManagementDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward list(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("phdCandidacyPeriods", PhdCandidacyPeriod.readPhdCandidacyPeriods());
        return mapping.findForward("list");
    }

    public ActionForward prepareCreatePhdCandidacyPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdCandidacyPeriodBean bean = new PhdCandidacyPeriodBean();
        request.setAttribute("phdCandidacyPeriodBean", (Object)bean);
        return mapping.findForward("createPhdCandidacyPeriod");
    }

    public ActionForward createPhdCandidacyPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdCandidacyPeriodBean bean = this.readPhdCandidacyPeriodBean();
        switch (bean.getType()) {
            case EPFL: {
                try {
                    EPFLPhdCandidacyPeriod.create(bean);
                    break;
                }
                catch (DomainException e) {
                    this.addActionMessage("error", request, e.getKey(), e.getArgs());
                    return this.createPhdCandidacyPeriodInvalid(mapping, form, request, response);
                }
            }
            case INSTITUTION: {
                try {
                    InstitutionPhdCandidacyPeriod.create(bean);
                    break;
                }
                catch (DomainException e) {
                    this.addActionMessage("error", request, e.getKey(), e.getArgs());
                    return this.createPhdCandidacyPeriodInvalid(mapping, form, request, response);
                }
            }
            default: {
                throw new DomainException("error.PhdCandidacyPeriodBean.type.missing", new String[0]);
            }
        }
        return this.list(mapping, form, request, response);
    }

    public ActionForward createPhdCandidacyPeriodInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("phdCandidacyPeriodBean", (Object)this.readPhdCandidacyPeriodBean());
        request.setAttribute("phdCandidacyPeriod", (Object)this.readPhdCandidacyPeriod(request));
        return mapping.findForward("createPhdCandidacyPeriod");
    }

    public ActionForward prepareEditPhdCandidacyPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdCandidacyPeriod phdCandidacyPeriod = this.readPhdCandidacyPeriod(request);
        request.setAttribute("phdCandidacyPeriodBean", (Object)new PhdCandidacyPeriodBean(phdCandidacyPeriod));
        request.setAttribute("phdCandidacyPeriod", (Object)this.readPhdCandidacyPeriod(request));
        return mapping.findForward("editPhdCandidacyPeriod");
    }

    public ActionForward editPhdCandidacyPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdCandidacyPeriod phdCandidacyPeriod = this.readPhdCandidacyPeriod(request);
        PhdCandidacyPeriodBean bean = this.readPhdCandidacyPeriodBean();
        try {
            phdCandidacyPeriod.edit(bean.getStart(), bean.getEnd());
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getKey(), e.getArgs());
            return this.editPhdCandidacyPeriodInvalid(mapping, form, request, response);
        }
        return this.list(mapping, form, request, response);
    }

    public ActionForward editPhdCandidacyPeriodInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("phdCandidacyPeriodBean", (Object)this.readPhdCandidacyPeriodBean());
        request.setAttribute("phdCandidacyPeriod", (Object)this.readPhdCandidacyPeriod(request));
        return mapping.findForward("editPhdCandidacyPeriod");
    }

    public ActionForward addPhdProgram(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdCandidacyPeriodBean phdCandidacyPeriodBean = this.readPhdCandidacyPeriodBean();
        InstitutionPhdCandidacyPeriod phdCandidacyPeriod = (InstitutionPhdCandidacyPeriod)((Object)this.readPhdCandidacyPeriod(request));
        phdCandidacyPeriod.addPhdProgramListToPeriod(phdCandidacyPeriodBean.getPhdProgramList());
        return this.prepareEditPhdCandidacyPeriod(mapping, form, request, response);
    }

    public ActionForward removePhdProgram(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        InstitutionPhdCandidacyPeriod phdCandidacyPeriod = (InstitutionPhdCandidacyPeriod)((Object)this.readPhdCandidacyPeriod(request));
        phdCandidacyPeriod.removePhdProgramInPeriod(this.readPhdProgram(request));
        return this.prepareEditPhdCandidacyPeriod(mapping, form, request, response);
    }

    public ActionForward view(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdCandidacyPeriod period = this.readPhdCandidacyPeriod(request);
        request.setAttribute("phdCandidacyPeriod", (Object)period);
        return mapping.findForward("view");
    }

    private PhdProgram readPhdProgram(HttpServletRequest request) {
        return (PhdProgram)((Object)this.getDomainObject(request, "phdProgramId"));
    }

    private PhdCandidacyPeriodBean readPhdCandidacyPeriodBean() {
        return (PhdCandidacyPeriodBean)this.getRenderedObject("phdCandidacyPeriodBean");
    }

    private PhdCandidacyPeriod readPhdCandidacyPeriod(HttpServletRequest request) {
        return (PhdCandidacyPeriod)((Object)this.getDomainObject(request, "phdCandidacyPeriodId"));
    }
}

