/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.person;

import java.io.IOException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactValidation;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.contacts.WebAddress;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.dto.contacts.EmailAddressBean;
import org.fenixedu.academic.dto.contacts.MobilePhoneBean;
import org.fenixedu.academic.dto.contacts.PartyContactBean;
import org.fenixedu.academic.dto.contacts.PhoneBean;
import org.fenixedu.academic.dto.contacts.PhysicalAddressBean;
import org.fenixedu.academic.dto.contacts.PhysicalAddressValidationBean;
import org.fenixedu.academic.dto.contacts.WebAddressBean;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.services.contacts.CreatePartyContact;
import org.fenixedu.academic.service.services.contacts.DeletePartyContact;
import org.fenixedu.academic.service.services.contacts.EditPartyContact;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.person.UpdateEmergencyContactDA;
import org.fenixedu.academic.ui.struts.action.person.VisualizePersonalInfo;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Mapping(module="person", path="/partyContacts", functionality=VisualizePersonalInfo.class)
@Forwards(value={@Forward(name="visualizePersonalInformation", path="/person/visualizePersonalInfo.jsp"), @Forward(name="editPartyContact", path="/person/contacts/editPartyContact.jsp"), @Forward(name="createPartyContact", path="/person/contacts/createPartyContact.jsp"), @Forward(name="inputValidationCode", path="/person/contacts/inputValidationCode.jsp"), @Forward(name="viewStudentLogChanges", path="/person/contacts/viewStudentLogChanges.jsp")})
public class PartyContactsManagementDispatchAction
extends FenixDispatchAction {
    public ActionForward postbackSetPublic(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PartyContactBean contact = (PartyContactBean)this.getRenderedObject("edit-contact");
        RenderUtils.invalidateViewState();
        if (contact.getVisibleToPublic().booleanValue()) {
            contact.setVisibleToStudents(Boolean.TRUE);
            contact.setVisibleToStaff(Boolean.TRUE);
        }
        contact.setVisibleToManagement(Boolean.TRUE);
        request.setAttribute("partyContact", (Object)contact);
        request.setAttribute("partyContactClass", (Object)contact.getContactName());
        return this.backToEditOrCreate(mapping, actionForm, request, response);
    }

    public boolean editContact(PartyContactBean contact) {
        return EditPartyContact.run(contact, !(contact instanceof WebAddressBean));
    }

    public PartyContact createContact(PartyContactBean contact) {
        return CreatePartyContact.run(contact, !(contact instanceof WebAddressBean));
    }

    public ActionForward postbackSetElements(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PartyContactBean contact = (PartyContactBean)this.getRenderedObject("edit-contact");
        RenderUtils.invalidateViewState();
        if (contact.getVisibleToPublic().booleanValue()) {
            contact.setVisibleToPublic(new Boolean(contact.getVisibleToStudents() != false && contact.getVisibleToStaff() != false));
        }
        contact.setVisibleToManagement(Boolean.TRUE);
        request.setAttribute("partyContact", (Object)contact);
        request.setAttribute("partyContactClass", (Object)contact.getContactName());
        return this.backToEditOrCreate(mapping, actionForm, request, response);
    }

    public ActionForward invalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Object rendered = this.getRenderedObject("edit-contact");
        if (rendered instanceof PartyContactBean) {
            PartyContactBean contact = (PartyContactBean)rendered;
            contact.setVisibleToManagement(Boolean.TRUE);
            request.setAttribute("partyContact", (Object)contact);
            request.setAttribute("partyContactClass", (Object)contact.getContactName());
        } else if (rendered instanceof PhysicalAddress) {
            PhysicalAddress contact = (PhysicalAddress)((Object)rendered);
            request.setAttribute("partyContact", (Object)contact);
            request.setAttribute("partyContactClass", (Object)((Object)((Object)contact)).getClass().getSimpleName());
        }
        return this.backToEditOrCreate(mapping, actionForm, request, response);
    }

    private ActionForward backToEditOrCreate(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        if (request.getParameter("form").equals("create")) {
            return mapping.findForward("createPartyContact");
        }
        if (request.getParameter("form").equals("edit")) {
            return mapping.findForward("editPartyContact");
        }
        return null;
    }

    public ActionForward prepareCreatePhysicalAddress(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhysicalAddressBean bean = new PhysicalAddressBean(this.getParty(request));
        request.setAttribute("partyContact", (Object)bean);
        return this.prepareCreatePartyContact(mapping, actionForm, request, response, bean);
    }

    public ActionForward prepareCreatePhone(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhoneBean bean = new PhoneBean(this.getParty(request));
        request.setAttribute("partyContact", (Object)bean);
        return this.prepareCreatePartyContact(mapping, actionForm, request, response, bean);
    }

    public ActionForward prepareCreateMobilePhone(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MobilePhoneBean bean = new MobilePhoneBean(this.getParty(request));
        request.setAttribute("partyContact", (Object)bean);
        return this.prepareCreatePartyContact(mapping, actionForm, request, response, bean);
    }

    public ActionForward prepareCreateEmailAddress(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        EmailAddressBean bean = new EmailAddressBean(this.getParty(request));
        request.setAttribute("partyContact", (Object)bean);
        return this.prepareCreatePartyContact(mapping, actionForm, request, response, bean);
    }

    public ActionForward prepareCreateWebAddress(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        WebAddressBean bean = new WebAddressBean(this.getParty(request));
        request.setAttribute("partyContact", (Object)bean);
        return this.prepareCreatePartyContact(mapping, actionForm, request, response, bean);
    }

    private ActionForward prepareCreatePartyContact(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response, PartyContactBean bean) {
        request.setAttribute("person", (Object)this.getParty(request));
        request.setAttribute("partyContactClass", (Object)bean.getContactName());
        return mapping.findForward("createPartyContact");
    }

    public ActionForward createPartyContact(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        if (this.getRenderedObject("edit-contact") instanceof PartyContactBean) {
            PartyContactBean contact = (PartyContactBean)this.getRenderedObject("edit-contact");
            PartyContact newPartyContact = null;
            try {
                newPartyContact = this.createContact(contact);
                if (newPartyContact == null) {
                    this.addActionMessage("contacts", request, "label.contact.validate.already", contact.getValue());
                    return this.backToShowInformation(mapping, actionForm, request, response);
                }
                this.addWarningMessage(request, contact);
            }
            catch (DomainException e) {
                this.addActionMessage("contacts", request, e.getMessage(), e.getArgs());
            }
            return this.forwardToInputValidationCode(mapping, actionForm, request, response, newPartyContact);
        }
        return null;
    }

    protected void addWarningMessage(HttpServletRequest request, PartyContact partyContact) {
        PartyContactBean contactBean = PartyContactBean.createFromDomain(partyContact);
        this.addActionMessage("contacts", request, contactBean.getValidationMessageKey(), contactBean.getValue());
    }

    protected void addWarningMessage(HttpServletRequest request, PartyContactBean contactBean) {
        this.addActionMessage("contacts", request, contactBean.getValidationMessageKey(), contactBean.getValue());
    }

    public ActionForward prepareEditPartyContact(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PartyContact contact = this.getPartyContact(request);
        PartyContactBean contactBean = PartyContactBean.createFromDomain(contact);
        request.setAttribute("partyContact", (Object)contactBean);
        request.setAttribute("partyContactClass", (Object)contactBean.getContactName());
        return mapping.findForward("editPartyContact");
    }

    protected PartyContact getPartyContact(HttpServletRequest request) {
        this.getParty(request);
        String contactId = (String)this.getFromRequest(request, "contactId");
        return (PartyContact)FenixFramework.getDomainObject((String)contactId);
    }

    public ActionForward forwardToInputValidationCode(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response, PartyContact partyContact) {
        if (partyContact == null || partyContact instanceof WebAddress) {
            return this.backToShowInformation(mapping, actionForm, request, response);
        }
        PartyContactValidation partyContactValidation = partyContact.getPartyContactValidation();
        request.setAttribute("partyContactValidation", (Object)partyContactValidation.getExternalId());
        request.setAttribute("valid", (Object)partyContactValidation.isValid());
        request.setAttribute("tries", (Object)partyContactValidation.getAvailableTries());
        if (partyContact instanceof PhysicalAddress) {
            request.setAttribute("isPhysicalAddress", (Object)true);
            request.setAttribute("physicalAddressBean", (Object)new PhysicalAddressBean((PhysicalAddress)((Object)partyContact)));
        }
        request.setAttribute("partyContact", (Object)PartyContactBean.createFromDomain(partyContact));
        request.setAttribute("canValidateRequests", (Object)((Person)((Object)partyContact.getParty())).getCanValidateContacts());
        return mapping.findForward("inputValidationCode");
    }

    public ActionForward editPartyContact(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        if (this.getRenderedObject("edit-contact") instanceof PartyContactBean) {
            PartyContactBean contact = (PartyContactBean)this.getRenderedObject("edit-contact");
            Boolean wasValidated = false;
            try {
                if (contact.hasPartyContact()) {
                    this.addActionMessage("contacts", request, "label.contact.validate.already", contact.getValue());
                    return this.backToShowInformation(mapping, actionForm, request, response);
                }
                wasValidated = this.editContact(contact);
            }
            catch (DomainException e) {
                this.addActionMessage("contacts", request, e.getMessage(), e.getArgs());
            }
            if (wasValidated.booleanValue()) {
                this.addWarningMessage(request, contact);
                return this.forwardToInputValidationCode(mapping, actionForm, request, response, contact.getContact());
            }
            return this.backToShowInformation(mapping, actionForm, request, response);
        }
        return null;
    }

    public ActionForward prepareValidate(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        String partyContactExtId = request.getParameter("partyContact");
        PartyContact partyContact = (PartyContact)FenixFramework.getDomainObject((String)partyContactExtId);
        partyContact.triggerValidationProcessIfNeeded();
        PartyContactBean contactBean = PartyContactBean.createFromDomain(partyContact);
        this.addWarningMessage(request, contactBean);
        return this.forwardToInputValidationCode(mapping, actionForm, request, response, partyContact);
    }

    public ActionForward validatePhysicalAddress(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PhysicalAddressBean physicalAddressBean = (PhysicalAddressBean)this.getRenderedObject("physicalAddressBean");
        PhysicalAddressValidationBean validationBean = physicalAddressBean.getValidationBean();
        validationBean.getValidation().setFile(validationBean.getFileName(), validationBean.getFileName(), validationBean.readStream());
        return this.backToShowInformation(mapping, actionForm, request, response);
    }

    public ActionForward validatePhysicalAddressInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PhysicalAddressBean physicalAddressBean = (PhysicalAddressBean)this.getRenderedObject("physicalAddressBean");
        if (physicalAddressBean == null) {
            return this.backToShowInformation(mapping, actionForm, request, response);
        }
        return this.forwardToInputValidationCode(mapping, actionForm, request, response, physicalAddressBean.getContact());
    }

    public ActionForward inputValidationCode(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Object partyContactValidation;
        String code = (String)this.getFromRequest(request, "validationCode");
        String extId = (String)this.getFromRequest(request, "partyContactValidation");
        if (StringUtils.isEmpty((String)code) || StringUtils.isEmpty((String)extId)) {
            this.addActionMessage("contacts", request, "error.contacts.validation.token.empty");
            return mapping.findForward("inputValidationCode");
        }
        PhysicalAddressValidationBean validationBean = (PhysicalAddressValidationBean)this.getRenderedObject("physicalAddressValidationBean");
        if (validationBean != null) {
            partyContactValidation = validationBean.getValidation();
        } else {
            partyContactValidation = (PartyContactValidation)FenixFramework.getDomainObject((String)extId);
            ((PartyContactValidation)((Object)partyContactValidation)).processValidation(code);
        }
        return this.forwardToInputValidationCode(mapping, actionForm, request, response, partyContactValidation.getPartyContact());
    }

    public ActionForward deletePartyContact(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            PartyContact partyContact = this.getPartyContact(request);
            this.deleteContact(partyContact);
        }
        catch (DomainException e) {
            this.addActionMessage("contacts", request, e.getMessage(), e.getArgs());
        }
        return this.backToShowInformation(mapping, actionForm, request, response);
    }

    public void deleteContact(PartyContact partyContact) {
        DeletePartyContact.run(partyContact);
    }

    protected Party getParty(HttpServletRequest request) {
        return AccessControl.getPerson();
    }

    public ActionForward backToShowInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Person person = Authenticate.getUser().getPerson();
        request.setAttribute("personBean", (Object)new PersonBean(person));
        UpdateEmergencyContactDA.EmergencyContactBean emergencyContactBean = new UpdateEmergencyContactDA.EmergencyContactBean(person);
        request.setAttribute("emergencyContactBean", (Object)emergencyContactBean);
        return mapping.findForward("visualizePersonalInformation");
    }

    public ActionForward requestValidationToken(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        String partyContactExtId = request.getParameter("partyContactValidation");
        PartyContactValidation partyContactValidation = (PartyContactValidation)FenixFramework.getDomainObject((String)partyContactExtId);
        PartyContact partyContact = partyContactValidation.getPartyContact();
        PartyContactBean contactBean = PartyContactBean.createFromDomain(partyContact);
        partyContact.triggerValidationProcess();
        this.addWarningMessage(request, contactBean);
        return this.forwardToInputValidationCode(mapping, actionForm, request, response, partyContact);
    }

    public ActionForward requestOptOut(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.backToShowInformation(mapping, actionForm, request, response);
    }

    public ActionForward viewStudentLog(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Person person = AccessControl.getPerson();
        Set logsList = person.getPersonInformationLogsSet();
        request.setAttribute("person", (Object)person);
        request.setAttribute("logsList", (Object)logsList);
        return mapping.findForward("viewStudentLogChanges");
    }
}

