/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator.thesis;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.thesis.ThesisEvaluationParticipant;
import org.fenixedu.academic.domain.thesis.ThesisParticipationType;
import org.fenixedu.academic.report.thesis.ApproveJuryDocument;
import org.fenixedu.academic.report.thesis.StudentThesisIdentificationDocument;
import org.fenixedu.academic.report.thesis.ThesisJuryReportDocument;
import org.fenixedu.academic.service.services.scientificCouncil.thesis.ApproveThesisProposal;
import org.fenixedu.academic.service.services.thesis.CancelSubmitThesis;
import org.fenixedu.academic.service.services.thesis.ChangeThesisPerson;
import org.fenixedu.academic.service.services.thesis.CreateThesisProposal;
import org.fenixedu.academic.service.services.thesis.DeleteThesis;
import org.fenixedu.academic.service.services.thesis.ReviseThesis;
import org.fenixedu.academic.service.services.thesis.SubmitThesis;
import org.fenixedu.academic.ui.struts.action.commons.AbstractManageThesisDA;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeCoordinatorIndex;
import org.fenixedu.academic.ui.struts.action.coordinator.ThesisSummaryBean;
import org.fenixedu.academic.ui.struts.action.coordinator.thesis.StudentThesisInfo;
import org.fenixedu.academic.ui.struts.action.coordinator.thesis.ThesisBean;
import org.fenixedu.academic.ui.struts.action.coordinator.thesis.ThesisContextBean;
import org.fenixedu.academic.ui.struts.action.coordinator.thesis.ThesisPresentationState;
import org.fenixedu.academic.util.report.ReportsUtils;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@Mapping(module="coordinator", path="/manageThesis", functionality=DegreeCoordinatorIndex.class)
@Forwards(value={@Forward(name="search-student", path="/coordinator/thesis/searchStudent.jsp"), @Forward(name="review-proposal", path="/coordinator/thesis/reviewProposal.jsp"), @Forward(name="change-information", path="/coordinator/thesis/changeInformation.jsp"), @Forward(name="editParticipant", path="/coordinator/thesis/editParticipant.jsp"), @Forward(name="view-submitted", path="/coordinator/thesis/viewSubmitted.jsp"), @Forward(name="change-information-with-docs", path="/coordinator/thesis/changeInformationWithDocs.jsp"), @Forward(name="viewOperationsThesis", path="/coordinator/thesis/viewOperationsThesis.jsp"), @Forward(name="select-unit", path="/coordinator/thesis/selectUnit.jsp"), @Forward(name="view-confirmed", path="/coordinator/thesis/viewConfirmed.jsp"), @Forward(name="list-thesis", path="/coordinator/thesis/listThesis.jsp"), @Forward(name="select-person", path="/coordinator/thesis/selectPerson.jsp"), @Forward(name="select-externalPerson", path="/coordinator/thesis/selectExternalPerson.jsp"), @Forward(name="view-approved", path="/coordinator/thesis/viewApproved.jsp"), @Forward(name="view-evaluated", path="/coordinator/thesis/viewEvaluated.jsp"), @Forward(name="collect-basic-information", path="/coordinator/thesis/collectBasicInformation.jsp"), @Forward(name="edit-thesis", path="/coordinator/thesis/editThesis.jsp")})
public class ManageThesisDA
extends AbstractManageThesisDA {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeCoordinatorIndex.setCoordinatorContext(request);
        request.setAttribute("degreeCurricularPlan", (Object)this.getDegreeCurricularPlan(request));
        request.setAttribute("thesis", (Object)this.getThesis(request));
        request.setAttribute("student", (Object)this.getStudent(request));
        ThesisContextBean bean = (ThesisContextBean)this.getRenderedObject("contextBean");
        ExecutionYear executionYear = bean == null ? this.getExecutionYear(request) : bean.getExecutionYear();
        this.setFilterContext(request, executionYear);
        return super.execute(mapping, actionForm, request, response);
    }

    private void setFilterContext(HttpServletRequest request, ExecutionYear executionYear) {
        request.setAttribute("executionYear", (Object)executionYear);
        request.setAttribute("executionYearId", (Object)(executionYear == null ? "" : executionYear.getExternalId()));
    }

    @Override
    protected Thesis getThesis(HttpServletRequest request) {
        Thesis thesis = (Thesis)((Object)request.getAttribute("thesis"));
        if (thesis != null) {
            return thesis;
        }
        return (Thesis)FenixFramework.getDomainObject((String)request.getParameter("thesisID"));
    }

    private Enrolment getEnrolment(HttpServletRequest request) {
        return (Enrolment)FenixFramework.getDomainObject((String)request.getParameter("enrolmentOID"));
    }

    private Student getStudent(HttpServletRequest request) {
        Student student = (Student)((Object)request.getAttribute("student"));
        if (student != null) {
            return student;
        }
        return (Student)FenixFramework.getDomainObject((String)request.getParameter("studentID"));
    }

    private ExecutionYear getExecutionYear(HttpServletRequest request) {
        String id = request.getParameter("executionYearId");
        if (id == null) {
            id = request.getParameter("executionYear");
        }
        if (id == null) {
            TreeSet<ExecutionYear> executionYears = new TreeSet<ExecutionYear>((Comparator<ExecutionYear>)new ReverseComparator());
            executionYears.addAll(this.getDegreeCurricularPlan(request).getExecutionYears());
            if (executionYears.isEmpty()) {
                return ExecutionYear.readCurrentExecutionYear();
            }
            return (ExecutionYear)executionYears.first();
        }
        return (ExecutionYear)FenixFramework.getDomainObject((String)id);
    }

    private ThesisContextBean getContextBean(HttpServletRequest request) {
        ThesisContextBean bean = (ThesisContextBean)this.getRenderedObject("contextBean");
        RenderUtils.invalidateViewState((String)"contextBean");
        if (bean != null) {
            return bean;
        }
        ExecutionYear executionYear = this.getExecutionYear(request);
        if (executionYear == null) {
            executionYear = ExecutionYear.readCurrentExecutionYear();
        }
        TreeSet<ExecutionYear> executionYears = new TreeSet<ExecutionYear>((Comparator<ExecutionYear>)new ReverseComparator());
        executionYears.addAll(this.getDegreeCurricularPlan(request).getExecutionYears());
        return new ThesisContextBean(executionYears, executionYear);
    }

    public ActionForward selectStudent(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisBean bean = (ThesisBean)this.getRenderedObject("student");
        if (bean == null) {
            return this.searchStudent(mapping, actionForm, request, response);
        }
        request.setAttribute("bean", (Object)bean);
        Student student = bean.getStudent();
        if (student == null) {
            this.addActionMessage(request, "thesis.selectStudent.notFound");
            return mapping.findForward("search-student");
        }
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        if (student.isCurrentlyEnroled(degreeCurricularPlan)) {
            Enrolment enrolment = student.getDissertationEnrolment(degreeCurricularPlan);
            if (enrolment != null) {
                Thesis thesis = enrolment.getThesis();
                if (thesis == null) {
                    request.setAttribute("proposeStartProcess", (Object)true);
                    return mapping.findForward("search-student");
                }
                request.setAttribute("hasThesis", (Object)true);
                request.setAttribute("thesis", (Object)thesis);
                return mapping.findForward("search-student");
            }
            this.addActionMessage(request, "thesis.selectStudent.dissertation.notEnroled");
            return mapping.findForward("search-student");
        }
        this.addActionMessage(request, "thesis.selectStudent.degreeCurricularPlan.notEnroled", degreeCurricularPlan.getName());
        return mapping.findForward("search-student");
    }

    public ActionForward viewThesis(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        if (thesis.isDraft()) {
            return this.editProposal(mapping, actionForm, request, response);
        }
        if (thesis.isSubmitted()) {
            return this.viewSubmitted(mapping, actionForm, request, response);
        }
        if (thesis.isWaitingConfirmation()) {
            return this.viewApproved(mapping, actionForm, request, response);
        }
        if (thesis.isConfirmed()) {
            return this.viewConfirmed(mapping, actionForm, request, response);
        }
        if (thesis.isEvaluated()) {
            return this.viewEvaluated(mapping, actionForm, request, response);
        }
        return this.searchStudent(mapping, actionForm, request, response);
    }

    public ThesisPresentationState getFilterFromRequest(HttpServletRequest request) {
        String filter = request.getParameter("filter");
        return filter != null && !filter.isEmpty() && !filter.equals("null") ? ThesisPresentationState.valueOf(filter) : null;
    }

    public ActionForward listThesis(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        ThesisContextBean bean = this.getContextBean(request);
        ThesisPresentationState filter = bean.getPresentationState();
        if (filter == null) {
            filter = this.getFilterFromRequest(request);
            bean.setPresentationState(filter);
        }
        request.setAttribute("filter", filter != null ? filter : "null");
        ArrayList<StudentThesisInfo> result = new ArrayList<StudentThesisInfo>();
        for (CurricularCourse curricularCourse : degreeCurricularPlan.getDissertationCurricularCourses(bean.getExecutionYear())) {
            for (Enrolment enrolment : curricularCourse.getEnrolmentsByExecutionYear(bean.getExecutionYear())) {
                ThesisPresentationState state;
                StudentCurricularPlan studentCurricularPlan = enrolment.getStudentCurricularPlan();
                if (studentCurricularPlan.getDegreeCurricularPlan() != degreeCurricularPlan) continue;
                Thesis thesis = enrolment.getThesis();
                if (filter != null && !(state = ThesisPresentationState.getThesisPresentationState(thesis)).equals((Object)filter)) continue;
                result.add(new StudentThesisInfo(enrolment));
            }
        }
        request.setAttribute("theses", result);
        request.setAttribute("contextBean", (Object)bean);
        ExecutionDegree executionDegree = degreeCurricularPlan.getExecutionDegreeByYear(bean.getExecutionYear().getPreviousExecutionYear());
        if (executionDegree != null) {
            request.setAttribute("summary", (Object)new ThesisSummaryBean(executionDegree, degreeCurricularPlan));
        }
        return mapping.findForward("list-thesis");
    }

    public ActionForward prepareCreateProposal(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Student student = this.getStudent(request);
        if (student == null) {
            return this.listThesis(mapping, actionForm, request, response);
        }
        Enrolment enrolment = this.getEnrolment(request);
        Thesis thesis = this.getThesis(request);
        if (thesis == null) {
            thesis = enrolment.getPossibleThesis();
        }
        ThesisBean bean = new ThesisBean();
        bean.setStudent(student);
        this.fillLastThesisInfo(bean, student, enrolment);
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("collect-basic-information");
    }

    private void fillLastThesisInfo(ThesisBean bean, Student student, Enrolment enrolment) {
        Thesis previous;
        TreeSet<Enrolment> dissertationEnrolments = student.getDissertationEnrolments(null);
        dissertationEnrolments.remove(enrolment);
        if (!dissertationEnrolments.isEmpty() && (previous = this.findPreviousThesis(dissertationEnrolments)) != null) {
            bean.setTitle(previous.getTitle());
            return;
        }
    }

    private Thesis findPreviousThesis(SortedSet<Enrolment> dissertationEnrolments) {
        if (dissertationEnrolments.isEmpty()) {
            return null;
        }
        Enrolment previous = dissertationEnrolments.last();
        if (previous != null) {
            if (!previous.getThesesSet().isEmpty()) {
                return previous.getThesis();
            }
            dissertationEnrolments.remove(previous);
            return this.findPreviousThesis(dissertationEnrolments);
        }
        return null;
    }

    public ActionForward createProposal(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        ThesisBean bean = (ThesisBean)this.getRenderedObject("bean");
        RenderUtils.invalidateViewState((String)"bean");
        if (bean == null) {
            return this.selectStudent(mapping, actionForm, request, response);
        }
        try {
            Thesis thesis = CreateThesisProposal.run(degreeCurricularPlan, bean.getStudent(), bean.getTitle(), bean.getComment());
            request.setAttribute("thesis", (Object)thesis);
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getKey(), e.getArgs());
            return this.listThesis(mapping, actionForm, request, response);
        }
        return this.editProposal(mapping, actionForm, request, response);
    }

    @Override
    public ActionForward editProposal(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        if (thesis == null) {
            return this.listThesis(mapping, actionForm, request, response);
        }
        request.setAttribute("conditions", thesis.getConditions());
        return mapping.findForward("edit-thesis");
    }

    public ActionForward editProposalWithDocs(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        if (thesis == null) {
            return this.listThesis(mapping, actionForm, request, response);
        }
        return this.viewApproved(mapping, actionForm, request, response);
    }

    public ActionForward editProposalDiscussion(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("changeDiscussion", (Object)true);
        return this.editProposal(mapping, actionForm, request, response);
    }

    public ActionForward changeInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("change-information");
    }

    public ActionForward changeInformationWithDocs(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("change-information-with-docs");
    }

    public ActionForward changeCredits(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String target = request.getParameter("target");
        if (target == null) {
            return this.editProposal(mapping, actionForm, request, response);
        }
        request.setAttribute("editOrientatorCreditsDistribution", (Object)target);
        return this.editProposal(mapping, actionForm, request, response);
    }

    public ActionForward changeParticipationInfo(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String target = request.getParameter("target");
        if (target == null) {
            return this.editProposal(mapping, actionForm, request, response);
        }
        Thesis thesis = this.getThesis(request);
        ThesisEvaluationParticipant participant = (ThesisEvaluationParticipant)FenixFramework.getDomainObject((String)target);
        ChangeThesisPerson.PersonTarget targetType = this.getPersonTarget(participant.getType());
        request.setAttribute("targetType", (Object)targetType);
        request.setAttribute("participant", (Object)participant);
        return mapping.findForward("editParticipant");
    }

    private ChangeThesisPerson.PersonTarget getPersonTarget(ThesisParticipationType type) {
        if (type.equals((Object)ThesisParticipationType.ORIENTATOR)) {
            return ChangeThesisPerson.PersonTarget.orientator;
        }
        if (type.equals((Object)ThesisParticipationType.COORIENTATOR)) {
            return ChangeThesisPerson.PersonTarget.coorientator;
        }
        if (type.equals((Object)ThesisParticipationType.PRESIDENT)) {
            return ChangeThesisPerson.PersonTarget.president;
        }
        if (type.equals((Object)ThesisParticipationType.VOWEL)) {
            return ChangeThesisPerson.PersonTarget.vowel;
        }
        return null;
    }

    public ActionForward changePerson(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean remove2;
        String target = request.getParameter("target");
        boolean bl = remove2 = request.getParameter("remove") != null;
        if (target == null) {
            return this.editProposal(mapping, actionForm, request, response);
        }
        Thesis thesis = this.getThesis(request);
        ThesisBean bean = new ThesisBean(thesis);
        Degree degree = this.getDegreeCurricularPlan(request).getDegree();
        bean.setDegree(degree);
        ChangeThesisPerson.PersonTarget targetType = ChangeThesisPerson.PersonTarget.valueOf(target);
        bean.setTargetType(targetType);
        if (targetType.equals((Object)ChangeThesisPerson.PersonTarget.vowel)) {
            ThesisEvaluationParticipant targetVowel = this.getVowel(request);
            if (targetVowel != null) {
                bean.setTarget(targetVowel);
            } else {
                bean.setTarget(null);
            }
        }
        if (remove2) {
            DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
            ChangeThesisPerson.run(degreeCurricularPlan, thesis, new ChangeThesisPerson.PersonChange(bean.getTargetType(), null, bean.getTarget()));
            return this.editProposal(mapping, actionForm, request, response);
        }
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("select-person");
    }

    public ActionForward addExternal(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean remove2;
        String target = request.getParameter("target");
        boolean bl = remove2 = request.getParameter("remove") != null;
        if (target == null) {
            return this.editProposal(mapping, actionForm, request, response);
        }
        Thesis thesis = this.getThesis(request);
        ThesisBean bean = new ThesisBean(thesis);
        Degree degree = this.getDegreeCurricularPlan(request).getDegree();
        bean.setDegree(degree);
        ChangeThesisPerson.PersonTarget targetType = ChangeThesisPerson.PersonTarget.valueOf(target);
        bean.setTargetType(targetType);
        if (targetType.equals((Object)ChangeThesisPerson.PersonTarget.vowel)) {
            ThesisEvaluationParticipant targetVowel = this.getVowel(request);
            if (targetVowel != null) {
                bean.setTarget(targetVowel);
            } else {
                bean.setTarget(null);
            }
        }
        if (remove2) {
            DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
            ChangeThesisPerson.run(degreeCurricularPlan, thesis, new ChangeThesisPerson.PersonChange(bean.getTargetType(), null, bean.getTarget()));
            return this.editProposal(mapping, actionForm, request, response);
        }
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("select-externalPerson");
    }

    public ActionForward deleteParticipant(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String target = request.getParameter("target");
        ThesisEvaluationParticipant participant = (ThesisEvaluationParticipant)FenixFramework.getDomainObject((String)target);
        ChangeThesisPerson.remove(participant);
        return this.editProposal(mapping, actionForm, request, response);
    }

    private ThesisEvaluationParticipant getVowel(HttpServletRequest request) {
        String parameter = request.getParameter("vowelID");
        if (parameter == null) {
            return null;
        }
        String id = parameter;
        Thesis thesis = this.getThesis(request);
        for (ThesisEvaluationParticipant participant : thesis.getVowels()) {
            if (!participant.getExternalId().equals(id)) continue;
            return participant;
        }
        return null;
    }

    public ActionForward changePersonInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThesisBean bean = (ThesisBean)this.getRenderedObject("bean");
        if (bean == null) {
            return this.editProposal(mapping, actionForm, request, response);
        }
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("select-person");
    }

    public ActionForward submitProposal(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        if (thesis == null) {
            return this.listThesis(mapping, actionForm, request, response);
        }
        try {
            DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
            SubmitThesis.run(degreeCurricularPlan, thesis);
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getKey(), e.getArgs());
            return this.editProposal(mapping, actionForm, request, response);
        }
        return this.listThesis(mapping, actionForm, request, response);
    }

    public ActionForward confirmDeleteProposal(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("confirmDelete", (Object)true);
        return this.editProposal(mapping, actionForm, request, response);
    }

    public ActionForward deleteProposal(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        if (thesis == null) {
            return this.listThesis(mapping, actionForm, request, response);
        }
        try {
            DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
            DeleteThesis.run(degreeCurricularPlan, thesis);
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getKey(), e.getArgs());
        }
        return this.listThesis(mapping, actionForm, request, response);
    }

    public ActionForward viewSubmitted(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        if (thesis == null) {
            return this.listThesis(mapping, actionForm, request, response);
        }
        return mapping.findForward("view-submitted");
    }

    public ActionForward cancelApprovalRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        if (thesis == null) {
            return this.listThesis(mapping, actionForm, request, response);
        }
        try {
            DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
            CancelSubmitThesis.run(degreeCurricularPlan, thesis);
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getKey(), e.getArgs());
            return this.viewSubmitted(mapping, actionForm, request, response);
        }
        return this.listThesis(mapping, actionForm, request, response);
    }

    public ActionForward viewApproved(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("view-approved");
    }

    public ActionForward printApprovalDocument(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        try {
            ApproveJuryDocument document = new ApproveJuryDocument(thesis);
            byte[] data = ReportsUtils.generateReport(document).getData();
            response.setContentLength(data.length);
            response.setContentType("application/pdf");
            response.addHeader("Content-Disposition", String.format("attachment; filename=%s.pdf", document.getReportFileName()));
            response.getOutputStream().write(data);
            return null;
        }
        catch (Exception e) {
            this.addActionMessage("error", request, "coordinator.thesis.approved.print.failed");
            return this.viewSubmitted(mapping, actionForm, request, response);
        }
    }

    public ActionForward viewConfirmed(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("view-confirmed");
    }

    public ActionForward confirmRevision(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("confirmRevision", (Object)true);
        return this.viewConfirmed(mapping, actionForm, request, response);
    }

    public ActionForward enterRevision(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        if (thesis == null) {
            return this.listThesis(mapping, actionForm, request, response);
        }
        try {
            ReviseThesis.run(thesis);
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getKey(), e.getArgs());
        }
        return this.listThesis(mapping, actionForm, request, response);
    }

    public ActionForward viewEvaluated(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("view-evaluated");
    }

    public ActionForward approveProposal(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        if (thesis != null) {
            ApproveThesisProposal.runApproveThesisProposal(thesis);
            this.addActionMessage("mail", request, "thesis.approved.mail.sent");
            this.addActionMessage("nextAction", request, "thesis.approved.next.action");
        }
        return this.listThesis(mapping, actionForm, request, response);
    }

    public ActionForward confirmRejectProposal(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("confirmReject", (Object)true);
        return this.reviewProposal(mapping, actionForm, request, response);
    }

    public ActionForward reviewProposal(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("review-proposal");
    }

    public ActionForward downloadIdentificationSheet(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        try {
            StudentThesisIdentificationDocument document = new StudentThesisIdentificationDocument(thesis);
            byte[] data = ReportsUtils.generateReport(document).getData();
            response.setContentLength(data.length);
            response.setContentType("application/pdf");
            response.addHeader("Content-Disposition", String.format("attachment; filename=%s.pdf", document.getReportFileName()));
            response.getOutputStream().write(data);
            return null;
        }
        catch (Exception e) {
            this.addActionMessage("error", request, "student.thesis.generate.identification.failed");
            e.printStackTrace();
            return this.listThesis(mapping, actionForm, request, response);
        }
    }

    public ActionForward downloadJuryReportSheet(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Thesis thesis = this.getThesis(request);
        try {
            ThesisJuryReportDocument document = new ThesisJuryReportDocument(thesis);
            byte[] data = ReportsUtils.generateReport(document).getData();
            response.setContentLength(data.length);
            response.setContentType("application/pdf");
            response.addHeader("Content-Disposition", String.format("attachment; filename=%s.pdf", document.getReportFileName()));
            response.getOutputStream().write(data);
            return null;
        }
        catch (Exception e) {
            this.addActionMessage("error", request, "student.thesis.generate.juryreport.failed");
            return this.listThesis(mapping, actionForm, request, response);
        }
    }
}

