/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.student;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.InternalCreditsSourceCurriculumGroup;
import org.fenixedu.academic.dto.administrativeOffice.dismissal.DismissalBean;
import org.fenixedu.academic.dto.administrativeOffice.dismissal.InternalSubstitutionDismissalBean;
import org.fenixedu.academic.service.services.administrativeOffice.dismissal.CreateNewInternalSubstitution;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.StudentDismissalsDA;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;

@Mapping(path="/studentInternalSubstitutions", module="academicAdministration", formBean="studentDismissalForm", functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="manage", path="/academicAdminOffice/dismissal/managementDismissals.jsp"), @Forward(name="chooseDismissalEnrolments", path="/academicAdminOffice/dismissal/chooseInternalSubstitutionEnrolments.jsp"), @Forward(name="chooseEquivalents", path="/academicAdminOffice/dismissal/chooseInternalSubstitutionEquivalents.jsp"), @Forward(name="confirmCreateDismissals", path="/academicAdminOffice/dismissal/confirmCreateInternalSubstitution.jsp"), @Forward(name="chooseNotNeedToEnrol", path="/academicAdminOffice/dismissal/chooseInternalSubstitutionNotNeedToEnrol.jsp")})
public class StudentInternalSubstitutionsDA
extends StudentDismissalsDA {
    @Override
    protected Collection<DismissalBean.SelectedEnrolment> buildStudentEnrolmentsInformation(DismissalBean dismissalBean) {
        ArrayList<DismissalBean.SelectedEnrolment> enrolments = new ArrayList<DismissalBean.SelectedEnrolment>();
        this.addEnrolmentsToDismissalFromStudentCurricularPlan(dismissalBean, enrolments);
        Collections.sort(enrolments, new Comparator<DismissalBean.SelectedEnrolment>(){

            @Override
            public int compare(DismissalBean.SelectedEnrolment o1, DismissalBean.SelectedEnrolment o2) {
                return Enrolment.COMPARATOR_BY_EXECUTION_YEAR_AND_NAME_AND_ID.compare(o1.getEnrolment(), o2.getEnrolment());
            }
        });
        return enrolments;
    }

    private void addEnrolmentsToDismissalFromStudentCurricularPlan(DismissalBean bean, List<DismissalBean.SelectedEnrolment> enrolments) {
        for (Enrolment enrolment : bean.getStudentCurricularPlan().getDismissalApprovedEnrolments()) {
            if (!this.isParentAcceptable(enrolment.getCurriculumGroup())) continue;
            enrolments.add(new DismissalBean.SelectedEnrolment(enrolment));
        }
    }

    private boolean isParentAcceptable(CurriculumGroup curriculumGroup) {
        return !curriculumGroup.isNoCourseGroupCurriculumGroup() || !(curriculumGroup instanceof InternalCreditsSourceCurriculumGroup);
    }

    @Override
    protected DismissalBean createDismissalBean() {
        return new InternalSubstitutionDismissalBean();
    }

    @Override
    public ActionForward chooseEquivalents(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DismissalBean dismissalBean = (DismissalBean)this.getRenderedObject("dismissalBean");
        if (!dismissalBean.hasAnySelectedIEnrolments()) {
            this.addActionMessage(request, "error.StudentInternalSubstitutionsDA.must.select.ienrolments");
            request.setAttribute("dismissalBean", (Object)dismissalBean);
            return mapping.findForward("chooseDismissalEnrolments");
        }
        return super.chooseEquivalents(mapping, form, request, response);
    }

    @Override
    protected void executeCreateDismissalService(DismissalBean dismissalBean) {
        CreateNewInternalSubstitution.create(dismissalBean);
    }
}

