/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.student;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactValidationState;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.contacts.WebAddress;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.contacts.PartyContactBean;
import org.fenixedu.academic.service.services.contacts.CreatePartyContact;
import org.fenixedu.academic.service.services.contacts.EditPartyContact;
import org.fenixedu.academic.ui.struts.FenixActionForm;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.person.PartyContactsManagementDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/partyContacts", module="academicAdministration", formBeanClass=FenixActionForm.class, functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="createPartyContact", path="/academicAdminOffice/createPartyContact.jsp"), @Forward(name="editPartyContact", path="/academicAdminOffice/editPartyContact.jsp"), @Forward(name="inputValidationCode", path="/academicAdminOffice/inputValidationCode.jsp"), @Forward(name="editPersonalData", path="/academicAdministration/student.do?method=prepareEditPersonalData")})
public class PartyContactsAcademicAdministrativeOfficeDA
extends PartyContactsManagementDispatchAction {
    private Student getStudent(HttpServletRequest request) {
        String studentID = request.getParameter("studentID");
        Student student = (Student)FenixFramework.getDomainObject((String)studentID);
        request.setAttribute("student", (Object)student);
        return student;
    }

    protected Person getParty(HttpServletRequest request) {
        return this.getStudent(request).getPerson();
    }

    @Override
    public ActionForward postbackSetPublic(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("student", (Object)this.getStudent(request));
        return super.postbackSetPublic(mapping, actionForm, request, response);
    }

    @Override
    public ActionForward postbackSetElements(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("student", (Object)this.getStudent(request));
        return super.postbackSetElements(mapping, actionForm, request, response);
    }

    @Override
    public ActionForward invalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("student", (Object)this.getStudent(request));
        return super.invalid(mapping, actionForm, request, response);
    }

    @Override
    public ActionForward backToShowInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("editPersonalData");
    }

    @Override
    public boolean editContact(PartyContactBean contact) {
        return EditPartyContact.run(contact, false);
    }

    @Override
    public PartyContact createContact(PartyContactBean contact) {
        return CreatePartyContact.run(contact, false);
    }

    @Override
    public ActionForward forwardToInputValidationCode(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response, PartyContact partyContact) {
        if (partyContact instanceof PhysicalAddress || partyContact instanceof WebAddress) {
            if (partyContact.getPartyContactValidation() != null) {
                partyContact.getPartyContactValidation().setState(PartyContactValidationState.VALID);
            }
            return this.backToShowInformation(mapping, actionForm, request, response);
        }
        this.getStudent(request);
        return mapping.findForward("inputValidationCode");
    }

    @Override
    protected void addWarningMessage(HttpServletRequest request, PartyContact partyContact) {
    }

    @Override
    protected void addWarningMessage(HttpServletRequest request, PartyContactBean contactBean) {
    }

    @Override
    public ActionForward viewStudentLog(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Person person = this.getStudent(request).getPerson();
        Set logsList = person.getPersonInformationLogsSet();
        request.setAttribute("logsList", (Object)logsList);
        return mapping.findForward("viewStudentLogChanges");
    }
}

