/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.serviceRequests;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.IProgramConclusionRequest;
import org.fenixedu.academic.domain.serviceRequests.IRegistryDiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.RectorateSubmissionBatch;
import org.fenixedu.academic.domain.serviceRequests.RectorateSubmissionState;
import org.fenixedu.academic.domain.serviceRequests.RegistryCode;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.serviceRequests.RectorateDocumentSubmissionDispatchAction$callable$closeBatch;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.serviceRequests.RectorateDocumentSubmissionDispatchAction$callable$delayRequest;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.serviceRequests.RectorateDocumentSubmissionDispatchAction$callable$markAsReceived;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.serviceRequests.RectorateDocumentSubmissionDispatchAction$callable$markAsSent;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilder;
import org.fenixedu.commons.spreadsheet.WorkbookExportFormat;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminServicesApp.class, path="rectorate-submission", titleKey="link.rectorateSubmission", accessGroup="academic(SERVICE_REQUESTS_RECTORAL_SENDING)")
@Mapping(path="/rectorateDocumentSubmission", module="academicAdministration")
@Forwards(value={@Forward(name="index", path="/academicAdminOffice/rectorateDocumentSubmission/batchIndex.jsp"), @Forward(name="viewBatch", path="/academicAdminOffice/rectorateDocumentSubmission/showBatch.jsp")})
public class RectorateDocumentSubmissionDispatchAction
extends FenixDispatchAction {
    public static final Advice advice$closeBatch = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$markAsSent = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$markAsReceived = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delayRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @EntryPoint
    public ActionForward index(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Set<AdministrativeOffice> offices = AcademicAccessRule.getOfficesAccessibleToFunction(AcademicOperationType.SERVICE_REQUESTS_RECTORAL_SENDING, this.getLoggedPerson(request).getUser()).collect(Collectors.toSet());
        request.setAttribute("unsent", RectorateSubmissionBatch.getRectorateSubmissionBatchesByState(offices, RectorateSubmissionState.UNSENT));
        request.setAttribute("closed", RectorateSubmissionBatch.getRectorateSubmissionBatchesByState(offices, RectorateSubmissionState.CLOSED));
        request.setAttribute("sent", RectorateSubmissionBatch.getRectorateSubmissionBatchesByState(offices, RectorateSubmissionState.SENT));
        request.setAttribute("received", RectorateSubmissionBatch.getRectorateSubmissionBatchesByState(offices, RectorateSubmissionState.RECEIVED));
        return mapping.findForward("index");
    }

    public ActionForward viewBatch(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        RectorateSubmissionBatch batch = (RectorateSubmissionBatch)((Object)this.getDomainObject(request, "batchOid"));
        HashSet<String> actions = new HashSet<String>();
        HashSet<String> confirmActions = new HashSet<String>();
        switch (batch.getState()) {
            case UNSENT: {
                if (batch.getDocumentRequestSet().isEmpty()) break;
                confirmActions.add("closeBatch");
                break;
            }
            case CLOSED: {
                actions.add("generateMetadataForRegistry");
                actions.add("generateMetadataForDiplomas");
                actions.add("zipDocuments");
                confirmActions.add("markAsSent");
                break;
            }
            case SENT: {
                actions.add("generateMetadataForDiplomas");
                if (!batch.allDocumentsReceived()) break;
                confirmActions.add("markAsReceived");
                break;
            }
        }
        request.setAttribute("batch", (Object)batch);
        HashSet<AcademicServiceRequest> requests = new HashSet<AcademicServiceRequest>();
        for (AcademicServiceRequest docRequest : batch.getDocumentRequestSet()) {
            if (docRequest.isCancelled() || docRequest.isRejected()) continue;
            requests.add(docRequest);
        }
        request.setAttribute("requests", requests);
        request.setAttribute("actions", actions);
        request.setAttribute("confirmActions", confirmActions);
        return mapping.findForward("viewBatch");
    }

    public ActionForward closeBatch(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return (ActionForward)advice$closeBatch.perform((Callable)new RectorateDocumentSubmissionDispatchAction$callable$closeBatch(this, actionMapping, actionForm, httpServletRequest, httpServletResponse));
    }

    static /* synthetic */ ActionForward advised$closeBatch(RectorateDocumentSubmissionDispatchAction this_, ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        RectorateSubmissionBatch batch = (RectorateSubmissionBatch)((Object)this_.getDomainObject(request, "batchOid"));
        batch.closeBatch();
        return this_.viewBatch(mapping, actionForm, request, response);
    }

    public ActionForward markAsSent(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return (ActionForward)advice$markAsSent.perform((Callable)new RectorateDocumentSubmissionDispatchAction$callable$markAsSent(this, actionMapping, actionForm, httpServletRequest, httpServletResponse));
    }

    static /* synthetic */ ActionForward advised$markAsSent(RectorateDocumentSubmissionDispatchAction this_, ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        RectorateSubmissionBatch batch = (RectorateSubmissionBatch)((Object)this_.getDomainObject(request, "batchOid"));
        batch.markAsSent();
        return this_.viewBatch(mapping, actionForm, request, response);
    }

    public ActionForward markAsReceived(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return (ActionForward)advice$markAsReceived.perform((Callable)new RectorateDocumentSubmissionDispatchAction$callable$markAsReceived(this, actionMapping, actionForm, httpServletRequest, httpServletResponse));
    }

    static /* synthetic */ ActionForward advised$markAsReceived(RectorateDocumentSubmissionDispatchAction this_, ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        RectorateSubmissionBatch batch = (RectorateSubmissionBatch)((Object)this_.getDomainObject(request, "batchOid"));
        batch.markAsReceived();
        return this_.viewBatch(mapping, actionForm, request, response);
    }

    public ActionForward generateMetadataForRegistry(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        RectorateSubmissionBatch batch = (RectorateSubmissionBatch)((Object)this.getDomainObject(request, "batchOid"));
        HashSet<AcademicServiceRequest> docs = new HashSet<AcademicServiceRequest>();
        for (AcademicServiceRequest document : batch.getDocumentRequestSet()) {
            if (document.isDiploma() || document.isCancelled() || document.isRejected()) continue;
            docs.add(document);
        }
        return this.generateMetadata(docs, "registos-", request, response);
    }

    public ActionForward generateMetadataForDiplomas(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        RectorateSubmissionBatch batch = (RectorateSubmissionBatch)((Object)this.getDomainObject(request, "batchOid"));
        HashSet<AcademicServiceRequest> docs = new HashSet<AcademicServiceRequest>();
        for (AcademicServiceRequest document : batch.getDocumentRequestSet()) {
            if (!document.isDiploma() || document.isCancelled() || document.isRejected()) continue;
            docs.add(document);
        }
        return this.generateMetadata(docs, "cartas-", request, response);
    }

    private ActionForward generateMetadata(Set<AcademicServiceRequest> documents, String prefix, HttpServletRequest request, HttpServletResponse response) {
        TreeSet<AcademicServiceRequest> sorted = new TreeSet<AcademicServiceRequest>(DocumentRequest.COMPARATOR_BY_REGISTRY_NUMBER);
        sorted.addAll(documents);
        HashSet<RegistryCode> codes = new HashSet<RegistryCode>();
        for (AcademicServiceRequest document : documents) {
            codes.add(document.getRegistryCode());
        }
        SheetData<AcademicServiceRequest> data = new SheetData<AcademicServiceRequest>(sorted){

            protected void makeLine(AcademicServiceRequest academicServiceRequest) {
                IDocumentRequest document = (IDocumentRequest)((Object)academicServiceRequest);
                this.addCell("C\u00f3digo", document.getRegistryCode().getCode());
                this.addCell("Tipo de Documento", BundleUtil.getString((String)"resources.EnumerationResources", (String)document.getDocumentRequestType().name(), (String[])new String[0]));
                this.addCell("Apuramento", document instanceof IProgramConclusionRequest ? ((IProgramConclusionRequest)document).getProgramConclusion().getName().getContent() : null);
                if (document.isRequestForRegistration()) {
                    this.addCell("Tipo de Curso", ((DocumentRequest)document).getDegreeType().getName().getContent());
                } else if (document.isRequestForPhd()) {
                    this.addCell("Tipo de Curso", BundleUtil.getString((String)"resources.PhdResources", (String)"label.php.program", (String[])new String[0]));
                }
                this.addCell("N\u00ba de Aluno", document.getStudent().getNumber());
                this.addCell("Nome", document.getPerson().getName());
                if (!document.isDiploma()) {
                    this.addCell("Ficheiro", document.getLastGeneratedDocument().getFilename());
                }
            }
        };
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-disposition", "attachment; filename=" + prefix + "-" + "(" + codes.size() + ")" + ".xls");
            ServletOutputStream writer = response.getOutputStream();
            new SpreadsheetBuilder().addSheet("lote", (SheetData)data).build(WorkbookExportFormat.EXCEL, (OutputStream)writer);
            writer.flush();
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new DomainException("error.rectorateSubmission.errorGeneratingMetadata", e, new String[0]);
        }
        return null;
    }

    public ActionForward zipDocuments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            RectorateSubmissionBatch batch = (RectorateSubmissionBatch)((Object)this.getDomainObject(request, "batchOid"));
            HashSet<AcademicServiceRequest> requestsToZip = new HashSet<AcademicServiceRequest>();
            for (AcademicServiceRequest document : batch.getDocumentRequestSet()) {
                if (document.isDiploma() || document.isCancelled() || document.isRejected()) continue;
                requestsToZip.add(document);
            }
            if (!requestsToZip.isEmpty()) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ZipOutputStream zip = new ZipOutputStream(bout);
                for (AcademicServiceRequest document : requestsToZip) {
                    zip.putNextEntry(new ZipEntry(document.getLastGeneratedDocument().getFilename()));
                    zip.write(document.getLastGeneratedDocument().getContent());
                    zip.closeEntry();
                }
                zip.close();
                response.setContentType("application/zip");
                response.addHeader("Content-Disposition", "attachment; filename=documentos-" + batch.getRange() + ".zip");
                ServletOutputStream writer = response.getOutputStream();
                writer.write(bout.toByteArray());
                writer.flush();
                writer.close();
                response.flushBuffer();
                return null;
            }
            this.addActionMessage(request, "error.rectorateSubmission.noDocumentsToZip");
            request.setAttribute("batchOid", (Object)batch.getExternalId());
            return this.viewBatch(mapping, actionForm, request, response);
        }
        catch (IOException e) {
            throw new DomainException("error.rectorateSubmission.errorGeneratingMetadata", e, new String[0]);
        }
    }

    public ActionForward delayRequest(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return (ActionForward)advice$delayRequest.perform((Callable)new RectorateDocumentSubmissionDispatchAction$callable$delayRequest(this, actionMapping, actionForm, httpServletRequest, httpServletResponse));
    }

    static /* synthetic */ ActionForward advised$delayRequest(RectorateDocumentSubmissionDispatchAction this_, ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        AcademicServiceRequest document = (AcademicServiceRequest)this_.getDomainObject(request, "academicServiceRequestOid");
        request.setAttribute("batchOid", (Object)document.getRectorateSubmissionBatch().getExternalId());
        if (document.isPiggyBackedOnRegistry()) {
            this_.addActionMessage(request, "error.rectorateSubmissionBatch.cannotDelayPiggyBackedDocument");
        } else {
            RectorateSubmissionBatch target = document.getRectorateSubmissionBatch();
            while (!target.isUnsent()) {
                target = target.getNextRectorateSubmissionBatch();
            }
            if (document.isRegistryDiploma()) {
                IRegistryDiplomaRequest registry = (IRegistryDiplomaRequest)((Object)document);
                ((AcademicServiceRequest)((Object)registry.getDiplomaSupplement())).setRectorateSubmissionBatch(target);
            }
            document.setRectorateSubmissionBatch(target);
        }
        return this_.viewBatch(mapping, actionForm, request, response);
    }
}

