/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.accounting.reports;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.accounting.report.events.EventReportQueueJob;
import org.fenixedu.academic.domain.accounting.report.events.EventReportQueueJobBean;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminPaymentsApp.class, path="event-reports", titleKey="title.event.reports", accessGroup="academic(MANAGE_EVENT_REPORTS)")
@Mapping(path="/eventReports", module="academicAdministration")
@Forwards(value={@Forward(name="listReports", path="/academicAdminOffice/accounting/reports/events/listReports.jsp"), @Forward(name="createReportRequest", path="/academicAdminOffice/accounting/reports/events/createReportRequest.jsp"), @Forward(name="viewRequest", path="/academicAdminOffice/accounting/reports/events/viewRequest.jsp")})
public class EventReportsDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward listReports(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        List<EventReportQueueJob> doneJobs = this.readDoneReports();
        List<EventReportQueueJob> pendingOrCancelledJobs = this.readPendingOrCancelledJobs();
        request.setAttribute("doneJobs", doneJobs);
        request.setAttribute("pendingOrCancelledJobs", pendingOrCancelledJobs);
        return mapping.findForward("listReports");
    }

    protected List<EventReportQueueJob> readPendingOrCancelledJobs() {
        return EventReportQueueJob.readPendingOrCancelledJobs(this.getOffices());
    }

    protected List<EventReportQueueJob> readDoneReports() {
        return EventReportQueueJob.readDoneReports(this.getOffices());
    }

    protected EventReportQueueJobBean createEventReportQueueJobBean() {
        return EventReportQueueJobBean.createBeanForAdministrativeOffice();
    }

    private Set<AdministrativeOffice> getOffices() {
        return AcademicAccessRule.getOfficesAccessibleToFunction(AcademicOperationType.MANAGE_EVENT_REPORTS, Authenticate.getUser()).collect(Collectors.toSet());
    }

    public ActionForward prepareCreateReportRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        EventReportQueueJobBean bean = this.createEventReportQueueJobBean();
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("createReportRequest");
    }

    public ActionForward createReportRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        EventReportQueueJobBean bean = (EventReportQueueJobBean)this.getRenderedObject("bean");
        try {
            EventReportQueueJob.createRequest(bean);
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getKey(), e.getArgs());
            return this.createReportRequestInvalid(mapping, form, request, response);
        }
        return this.listReports(mapping, form, request, response);
    }

    public ActionForward createReportRequestPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        EventReportQueueJobBean bean = (EventReportQueueJobBean)this.getRenderedObject("bean");
        request.setAttribute("bean", (Object)bean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("createReportRequest");
    }

    public ActionForward createReportRequestInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        EventReportQueueJobBean bean = (EventReportQueueJobBean)this.getRenderedObject("bean");
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("createReportRequest");
    }

    public ActionForward cancelReportRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        EventReportQueueJob job = this.readEventReportQueueJob(request);
        try {
            job.cancel();
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getKey(), e.getArgs());
            return this.listReports(mapping, form, request, response);
        }
        return this.listReports(mapping, form, request, response);
    }

    public ActionForward viewRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        EventReportQueueJob queueJob = this.readEventReportQueueJob(request);
        request.setAttribute("queueJob", (Object)queueJob);
        return mapping.findForward("viewRequest");
    }

    public EventReportQueueJob readEventReportQueueJob(HttpServletRequest request) {
        return (EventReportQueueJob)((Object)this.getDomainObject(request, "queueJobId"));
    }
}

