/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration.executionCourseManagement;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.util.LabelValueBean;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.dto.InfoExecutionDegree;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.manager.executionCourseManagement.ReadExecutionCourseWithShiftsAndCurricularCoursesByOID;
import org.fenixedu.academic.service.services.manager.executionCourseManagement.ReadExecutionCoursesByExecutionDegreeIdAndExecutionPeriodIdAndCurYear;
import org.fenixedu.academic.service.services.manager.executionCourseManagement.ReadExecutionDegreesByExecutionPeriodId;
import org.fenixedu.academic.service.services.manager.executionCourseManagement.ReadInfoExecutionCourseByOID;
import org.fenixedu.academic.service.services.manager.executionCourseManagement.SeperateExecutionCourse;
import org.fenixedu.academic.ui.struts.action.academicAdministration.executionCourseManagement.EditExecutionCourseDA;
import org.fenixedu.academic.ui.struts.action.academicAdministration.executionCourseManagement.ExecutionCourseBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.utils.RequestUtils;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixframework.FenixFramework;

@Mapping(module="academicAdministration", path="/seperateExecutionCourse", input="/editExecutionCourse.do?method=prepareEditECChooseExecDegreeAndCurYear&page=0", formBean="separateExecutionCourseForm", functionality=EditExecutionCourseDA.class)
@Forwards(value={@Forward(name="returnFromTransfer", path="/academicAdministration/executionCourseManagement/listExecutionCourseActions.jsp"), @Forward(name="manageCurricularSeparation", path="/academicAdministration/executionCourseManagement/manageCurricularSeparation.jsp"), @Forward(name="showTransferPage", path="/academicAdministration/executionCourseManagement/transferCurricularCourses.jsp"), @Forward(name="showSeparationPage", path="/academicAdministration/executionCourseManagement/separateExecutionCourse.jsp")})
public class SeperateExecutionCourseDispatchAction
extends FenixDispatchAction {
    public ActionForward prepareTransfer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        String executionCourseId = RequestUtils.getAndSetStringToRequest(request, "executionCourseId");
        String originExecutionDegreeId = RequestUtils.getAndSetStringToRequest(request, "originExecutionDegreeId");
        String curricularYearId = RequestUtils.getAndSetStringToRequest(request, "curricularYearId");
        RequestUtils.getAndSetStringToRequest(request, "executionPeriodId");
        CurricularYear curYear = (CurricularYear)FenixFramework.getDomainObject((String)curricularYearId);
        request.setAttribute("curYear", (Object)curYear.getYear().toString());
        ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)originExecutionDegreeId);
        request.setAttribute("originExecutionDegreeName", (Object)executionDegree.getPresentationName());
        InfoExecutionCourse infoExecutionCourse = ReadExecutionCourseWithShiftsAndCurricularCoursesByOID.run(executionCourseId);
        request.setAttribute("infoExecutionCourse", (Object)infoExecutionCourse);
        List<InfoExecutionDegree> executionDegrees = ReadExecutionDegreesByExecutionPeriodId.runForAcademicAdminAdv(infoExecutionCourse.getInfoExecutionPeriod().getExternalId());
        this.transformExecutionDegreesIntoLabelValueBean(executionDegrees);
        request.setAttribute("executionDegrees", executionDegrees);
        List<LabelValueBean> curricularYears = RequestUtils.buildCurricularYearLabelValueBean();
        request.setAttribute("curricularYear.list", curricularYears);
        return mapping.findForward("showTransferPage");
    }

    public ActionForward prepareSeparate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        String executionCourseId = RequestUtils.getAndSetStringToRequest(request, "executionCourseId");
        String originExecutionDegreeId = RequestUtils.getAndSetStringToRequest(request, "originExecutionDegreeId");
        String curricularYearId = RequestUtils.getAndSetStringToRequest(request, "curricularYearId");
        RequestUtils.getAndSetStringToRequest(request, "executionPeriodId");
        CurricularYear curYear = (CurricularYear)FenixFramework.getDomainObject((String)curricularYearId);
        request.setAttribute("curYear", (Object)curYear.getYear().toString());
        ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)originExecutionDegreeId);
        request.setAttribute("originExecutionDegreeName", (Object)executionDegree.getPresentationName());
        InfoExecutionCourse infoExecutionCourse = ReadExecutionCourseWithShiftsAndCurricularCoursesByOID.run(executionCourseId);
        request.setAttribute("infoExecutionCourse", (Object)infoExecutionCourse);
        return mapping.findForward("showSeparationPage");
    }

    public ActionForward manageCurricularSeparation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException, FenixActionException {
        InfoExecutionCourse infoExecutionCourse;
        String executionCourseId = (String)request.getAttribute("executionCourseId");
        if (executionCourseId == null) {
            executionCourseId = RequestUtils.getAndSetStringToRequest(request, "executionCourseId");
        }
        try {
            infoExecutionCourse = ReadInfoExecutionCourseByOID.run(executionCourseId);
        }
        catch (FenixServiceException e) {
            throw new FenixActionException(e);
        }
        if (infoExecutionCourse.getAssociatedInfoCurricularCourses() != null) {
            Collections.sort(infoExecutionCourse.getAssociatedInfoCurricularCourses(), new BeanComparator("name"));
        }
        request.setAttribute("execution_course", (Object)infoExecutionCourse);
        String executionCoursesNotLinked = RequestUtils.getAndSetStringToRequest(request, "executionCoursesNotLinked");
        Boolean chooseNotLinked = false;
        if (!StringUtils.isEmpty((String)executionCoursesNotLinked) && Boolean.valueOf(executionCoursesNotLinked).booleanValue()) {
            chooseNotLinked = true;
        }
        String executionPeriodId = RequestUtils.getAndSetStringToRequest(request, "executionPeriodId");
        ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseId);
        ExecutionSemester executionPeriod = (ExecutionSemester)FenixFramework.getDomainObject((String)executionPeriodId);
        ExecutionCourseBean sessionBean = new ExecutionCourseBean();
        sessionBean.setSourceExecutionCourse(executionCourse);
        sessionBean.setExecutionSemester(executionPeriod);
        sessionBean.setChooseNotLinked(chooseNotLinked);
        if (!chooseNotLinked.booleanValue()) {
            String originExecutionDegreeId = RequestUtils.getAndSetStringToRequest(request, "originExecutionDegreeId");
            String curricularYearId = RequestUtils.getAndSetStringToRequest(request, "curricularYearId");
            ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)originExecutionDegreeId);
            CurricularYear curYear = (CurricularYear)FenixFramework.getDomainObject((String)curricularYearId);
            sessionBean.setExecutionDegree(executionDegree);
            sessionBean.setCurricularYear(curYear);
            request.setAttribute("curYear", (Object)curYear.getYear().toString());
            request.setAttribute("originExecutionDegreeName", (Object)executionDegree.getPresentationName());
        }
        request.setAttribute("sessionBean", (Object)sessionBean);
        return mapping.findForward("manageCurricularSeparation");
    }

    private void transformExecutionDegreesIntoLabelValueBean(List executionDegreeList) {
        CollectionUtils.transform((Collection)executionDegreeList, (Transformer)new Transformer(){

            public Object transform(Object arg0) {
                InfoExecutionDegree infoExecutionDegree = (InfoExecutionDegree)arg0;
                String label = infoExecutionDegree.getInfoDegreeCurricularPlan().getDegreeCurricularPlan().getPresentationName(infoExecutionDegree.getInfoExecutionYear().getExecutionYear());
                return new LabelValueBean(label, infoExecutionDegree.getExternalId().toString());
            }
        });
        Collections.sort(executionDegreeList, new BeanComparator("label"));
        executionDegreeList.add(0, new LabelValueBean(BundleUtil.getString((String)"resources.RendererResources", (String)"renderers.menu.default.title", (String[])new String[0]), ""));
    }

    public ActionForward changeDestinationContext(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        this.prepareTransfer(mapping, form, request, response);
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        String destinationExecutionDegreeId = (String)dynaActionForm.get("destinationExecutionDegreeId");
        String destinationCurricularYear = (String)dynaActionForm.get("destinationCurricularYear");
        if (this.isSet(destinationExecutionDegreeId) && this.isSet(destinationCurricularYear)) {
            InfoExecutionCourse infoExecutionCourse = (InfoExecutionCourse)request.getAttribute("infoExecutionCourse");
            List executionCourses = ReadExecutionCoursesByExecutionDegreeIdAndExecutionPeriodIdAndCurYear.run(destinationExecutionDegreeId, infoExecutionCourse.getInfoExecutionPeriod().getExternalId(), new Integer(destinationCurricularYear));
            executionCourses.remove(infoExecutionCourse);
            Collections.sort(executionCourses, new BeanComparator("nome"));
            request.setAttribute("executionCourses", (Object)executionCourses);
        }
        return mapping.findForward("showTransferPage");
    }

    public ActionForward transfer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException, FenixActionException {
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        String executionCourseId = RequestUtils.getAndSetStringToRequest(request, "executionCourseId");
        String destinationExecutionCourseIdString = (String)dynaActionForm.get("destinationExecutionCourseId");
        String originExecutionDegreeId = RequestUtils.getAndSetStringToRequest(request, "originExecutionDegreeId");
        String curricularYearId = (String)dynaActionForm.get("curricularYearId");
        String[] shiftIdsToTransfer = (String[])dynaActionForm.get("shiftIdsToTransfer");
        String[] curricularCourseIdsToTransfer = (String[])dynaActionForm.get("curricularCourseIdsToTransfer");
        ExecutionDegree originExecutionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)originExecutionDegreeId);
        ExecutionCourse originExecutionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseId);
        String originExecutionDegreesString = originExecutionCourse.getDegreePresentationString();
        String destinationExecutionCourseId = null;
        try {
            String transferedShifts;
            String successKey;
            if (StringUtils.isEmpty((String)destinationExecutionCourseIdString) || !StringUtils.isNumeric((String)destinationExecutionCourseIdString)) {
                throw new DomainException("error.selection.noDestinationExecutionCourse", new String[0]);
            }
            destinationExecutionCourseId = destinationExecutionCourseIdString;
            ExecutionCourse destinationExecutionCourse = SeperateExecutionCourse.run(executionCourseId, destinationExecutionCourseId, shiftIdsToTransfer, curricularCourseIdsToTransfer);
            String destinationExecutionCourseName = destinationExecutionCourse.getNameI18N().getContent();
            if (StringUtils.isEmpty((String)destinationExecutionCourseName)) {
                destinationExecutionCourseName = destinationExecutionCourse.getName();
            }
            String destinationExecutionCourseCode = destinationExecutionCourse.getSigla();
            String destinationDegreeName = destinationExecutionCourse.getDegreePresentationString();
            String transferedCurricularCourses = this.makeObjectStringFromArray(curricularCourseIdsToTransfer, CurricularCourse.class);
            if (shiftIdsToTransfer.length == 0) {
                successKey = "message.manager.executionCourseManagement.transferCourse.success.many.noShifts";
                transferedShifts = "";
            } else {
                successKey = "message.manager.executionCourseManagement.transferCourse.success.many";
                transferedShifts = this.makeObjectStringFromArray(shiftIdsToTransfer, Shift.class);
            }
            this.addActionMessage("success", request, successKey, transferedCurricularCourses, transferedShifts, destinationExecutionCourseName, destinationDegreeName, destinationExecutionCourseCode);
            if (!originExecutionCourse.getExecutionDegrees().contains(originExecutionDegree)) {
                String originCourseName = originExecutionCourse.getNameI18N().getContent();
                if (StringUtils.isEmpty((String)originCourseName)) {
                    originCourseName = originExecutionCourse.getName();
                }
                this.addActionMessage("info", request, "message.manager.executionCourseManagement.transferCourse.success.switchContext", originCourseName, originExecutionDegreesString, originExecutionCourse.getDegreePresentationString(), destinationExecutionCourseName, destinationExecutionCourse.getDegreePresentationString(), originExecutionDegree.getDegree().getSigla());
                request.setAttribute("executionCourseId", (Object)destinationExecutionCourse.getExternalId().toString());
            }
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage(), e.getArgs());
            if (request.getAttribute("destinationExecutionDegreeId") != null) {
                request.setAttribute("destinationExecutionDegreeId", request.getAttribute("destinationExecutionDegreeId"));
            }
            if (curricularYearId != null) {
                request.setAttribute("destinationCurricularYear", (Object)curricularYearId);
            }
            if (request.getAttribute("executionCourses") != null) {
                request.setAttribute("executionCourses", request.getAttribute("executionCourses"));
            }
            if (destinationExecutionCourseId != null) {
                request.setAttribute("destinationExecutionCourseId", (Object)destinationExecutionCourseId.toString());
            }
            return this.changeDestinationContext(mapping, (ActionForm)dynaActionForm, request, response);
        }
        return this.manageCurricularSeparation(mapping, (ActionForm)dynaActionForm, request, response);
    }

    public ActionForward separate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException, FenixActionException {
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        String executionCourseId = RequestUtils.getAndSetStringToRequest(request, "executionCourseId");
        String originExecutionDegreeId = RequestUtils.getAndSetStringToRequest(request, "originExecutionDegreeId");
        String[] shiftIdsToTransfer = (String[])dynaActionForm.get("shiftIdsToTransfer");
        String[] curricularCourseIdsToTransfer = (String[])dynaActionForm.get("curricularCourseIdsToTransfer");
        ExecutionDegree originExecutionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)originExecutionDegreeId);
        ExecutionCourse originExecutionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseId);
        String originExecutionDegreesString = originExecutionCourse.getDegreePresentationString();
        try {
            String transferedShifts;
            String successKey;
            ExecutionCourse destinationExecutionCourse = SeperateExecutionCourse.run(executionCourseId, null, shiftIdsToTransfer, curricularCourseIdsToTransfer);
            String destinationExecutionCourseName = destinationExecutionCourse.getNameI18N().getContent();
            if (StringUtils.isEmpty((String)destinationExecutionCourseName)) {
                destinationExecutionCourseName = destinationExecutionCourse.getName();
            }
            String destinationExecutionCourseCode = destinationExecutionCourse.getSigla();
            String destinationDegreeName = destinationExecutionCourse.getDegreePresentationString();
            String transferedCurricularCourses = this.makeObjectStringFromArray(curricularCourseIdsToTransfer, CurricularCourse.class);
            if (shiftIdsToTransfer.length == 0) {
                successKey = "message.manager.executionCourseManagement.separate.success.create.noShifts";
                transferedShifts = "";
            } else {
                successKey = "message.manager.executionCourseManagement.separate.success.create";
                transferedShifts = this.makeObjectStringFromArray(shiftIdsToTransfer, Shift.class);
            }
            this.addActionMessage("success", request, successKey, destinationExecutionCourseName, destinationDegreeName, destinationExecutionCourseCode, transferedCurricularCourses, transferedShifts);
            if (!originExecutionCourse.getExecutionDegrees().contains(originExecutionDegree)) {
                String originCourseName = originExecutionCourse.getNameI18N().getContent();
                if (StringUtils.isEmpty((String)originCourseName)) {
                    originCourseName = originExecutionCourse.getName();
                }
                this.addActionMessage("info", request, "message.manager.executionCourseManagement.separate.success.switchContext", originCourseName, originExecutionDegreesString, originExecutionCourse.getDegreePresentationString(), destinationExecutionCourseName, destinationExecutionCourse.getDegreePresentationString(), originExecutionDegree.getDegree().getSigla());
                request.setAttribute("executionCourseId", (Object)destinationExecutionCourse.getExternalId().toString());
            }
        }
        catch (DomainException e) {
            this.addActionMessage("error", request, e.getMessage(), e.getArgs());
            return this.prepareSeparate(mapping, (ActionForm)dynaActionForm, request, response);
        }
        return this.manageCurricularSeparation(mapping, (ActionForm)dynaActionForm, request, response);
    }

    private boolean isSet(String parameter) {
        return !StringUtils.isEmpty((String)parameter) && StringUtils.isNumeric((String)parameter);
    }

    private String makeObjectStringFromArray(String[] ids, Class objectType) {
        StringBuilder sb = new StringBuilder();
        if (objectType.equals(CurricularCourse.class)) {
            for (String id : ids) {
                sb.append(this.curricularCourseToString(id));
                sb.append(", ");
            }
        } else if (objectType.equals(Shift.class)) {
            for (String id : ids) {
                sb.append(this.shiftToString(id));
                sb.append(", ");
            }
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        } else {
            sb.append(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.empty", (String[])new String[0]));
        }
        return sb.toString();
    }

    private String curricularCourseToString(String id) {
        CurricularCourse curricularCourse = (CurricularCourse)FenixFramework.getDomainObject((String)id);
        String name = curricularCourse.getNameI18N().getContent();
        if (StringUtils.isEmpty((String)name)) {
            name = curricularCourse.getName();
        }
        return name + " [" + curricularCourse.getDegree().getSigla() + "]";
    }

    private String shiftToString(String id) {
        Shift shift = (Shift)FenixFramework.getDomainObject((String)id);
        return shift.getPresentationName();
    }
}

