/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration.executionCourseManagement;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.interfaces.HasExecutionDegree;
import org.fenixedu.academic.domain.interfaces.HasExecutionSemester;

public class ExecutionCourseBean
implements Serializable,
HasExecutionSemester,
HasExecutionDegree {
    private ExecutionDegree executionDegree;
    private CurricularYear curricularYear;
    private ExecutionCourse sourceExecutionCourse;
    private ExecutionCourse destinationExecutionCourse;
    private ExecutionSemester executionSemester;
    private Boolean chooseNotLinked;

    @Override
    public ExecutionSemester getExecutionPeriod() {
        return this.getExecutionSemester();
    }

    @Override
    public ExecutionDegree getExecutionDegree() {
        return this.executionDegree;
    }

    public void setExecutionDegree(ExecutionDegree executionDegree) {
        this.executionDegree = executionDegree;
    }

    public CurricularYear getCurricularYear() {
        return this.curricularYear;
    }

    public void setCurricularYear(CurricularYear curricularYear) {
        this.curricularYear = curricularYear;
    }

    public ExecutionSemester getExecutionSemester() {
        return this.executionSemester;
    }

    public void setExecutionSemester(ExecutionSemester executionSemester) {
        this.executionSemester = executionSemester;
    }

    public ExecutionCourse getSourceExecutionCourse() {
        return this.sourceExecutionCourse;
    }

    public void setSourceExecutionCourse(ExecutionCourse sourceExecutionCourse) {
        this.sourceExecutionCourse = sourceExecutionCourse;
    }

    public ExecutionCourse getDestinationExecutionCourse() {
        return this.destinationExecutionCourse;
    }

    public void setDestinationExecutionCourse(ExecutionCourse destinationExecutionCourse) {
        this.destinationExecutionCourse = destinationExecutionCourse;
    }

    public Boolean getChooseNotLinked() {
        return this.chooseNotLinked;
    }

    public void setChooseNotLinked(Boolean chooseNotLinked) {
        this.chooseNotLinked = chooseNotLinked;
    }

    public ExecutionCourseBean(ExecutionCourse executionCourse) {
        this.setSourceExecutionCourse(executionCourse);
    }

    public Collection<ExecutionCourse> getExecutionCourses() {
        List<Object> result = new ArrayList();
        if (this.chooseNotLinked.booleanValue()) {
            result = this.getExecutionSemester().getExecutionCoursesWithNoCurricularCourses();
        } else {
            for (CurricularCourse curricularCourse : this.getDegreeCurricularPlan().getCurricularCourses(this.getExecutionSemester())) {
                if (!curricularCourse.hasScopeInGivenSemesterAndCurricularYearInDCP(this.getCurricularYear(), this.getDegreeCurricularPlan(), this.getExecutionSemester())) continue;
                result.addAll(curricularCourse.getExecutionCoursesByExecutionPeriod(this.getExecutionSemester()));
            }
        }
        TreeSet<ExecutionCourse> finalResult = new TreeSet<ExecutionCourse>(ExecutionCourse.EXECUTION_COURSE_NAME_COMPARATOR);
        finalResult.addAll(result);
        return finalResult;
    }

    private DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.getExecutionDegree().getDegreeCurricularPlan();
    }

    public ExecutionCourseBean() {
    }
}

