/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EnrolmentInstructions;
import org.fenixedu.academic.domain.EnrolmentPeriod;
import org.fenixedu.academic.domain.EnrolmentPeriodInClasses;
import org.fenixedu.academic.domain.EnrolmentPeriodInCurricularCourses;
import org.fenixedu.academic.domain.EnrolmentPeriodInCurricularCoursesFlunkedSeason;
import org.fenixedu.academic.domain.EnrolmentPeriodInCurricularCoursesSpecialSeason;
import org.fenixedu.academic.domain.EnrolmentPeriodInImprovementOfApprovedEnrolment;
import org.fenixedu.academic.domain.EnrolmentPeriodInSpecialSeasonEvaluations;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ReingressionPeriod;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.enrolmentPeriods.EnrolmentPeriodType;
import org.fenixedu.academic.predicate.AcademicPredicates;
import org.fenixedu.academic.service.services.manager.CreateEnrolmentPeriods;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.academicAdministration.ManageEnrolementPeriodsDA$EnrolmentPeriodConfigurationForEdit$callable$save;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminExecutionsApp.class, path="manage-enrolment-periods", titleKey="title.manage.enrolement.period", accessGroup="academic(MANAGE_ENROLMENT_PERIODS)")
@Mapping(module="academicAdministration", path="/manageEnrolementPeriods", input="/manageEnrolementPeriods.do?method=prepare&page=0", formBean="enrolementPeriodsForm")
@Forwards(value={@Forward(name="editEnrolmentInstructions", path="/academicAdministration/enrolmentPeriodManagement/editEnrolmentInstructions.jsp"), @Forward(name="showEnrolementPeriods", path="/academicAdministration/enrolmentPeriodManagement/enrolementPeriods.jsp"), @Forward(name="createPeriod", path="/academicAdministration/enrolmentPeriodManagement/createPeriod.jsp"), @Forward(name="changePeriodValues", path="/academicAdministration/enrolmentPeriodManagement/changePeriodValues.jsp")})
public class ManageEnrolementPeriodsDA
extends FenixDispatchAction {
    static List<Class<? extends EnrolmentPeriod>> VALID_ENROLMENT_PERIODS = Arrays.asList(EnrolmentPeriodInCurricularCourses.class, EnrolmentPeriodInSpecialSeasonEvaluations.class, EnrolmentPeriodInClasses.class, EnrolmentPeriodInImprovementOfApprovedEnrolment.class, EnrolmentPeriodInCurricularCoursesSpecialSeason.class, EnrolmentPeriodInCurricularCoursesFlunkedSeason.class, ReingressionPeriod.class);

    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecutionSemester semester = (ExecutionSemester)this.getDomainObject(request, "semester");
        EnrolmentPeriodBean bean = new EnrolmentPeriodBean();
        if (semester != null) {
            bean.setSemester(semester);
        }
        request.setAttribute("executionSemester", (Object)bean);
        return mapping.findForward("showEnrolementPeriods");
    }

    public ActionForward selectSemester(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        EnrolmentPeriodBean bean = (EnrolmentPeriodBean)this.getRenderedObject("executionSemester");
        RenderUtils.invalidateViewState();
        request.setAttribute("executionSemester", (Object)bean);
        return mapping.findForward("showEnrolementPeriods");
    }

    public ActionForward prepareEditEnrolmentInstructions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExecutionSemester semester = (ExecutionSemester)this.getDomainObject(request, "semester");
        EnrolmentInstructions.createIfNecessary(semester);
        request.setAttribute("executionSemester", (Object)semester);
        return mapping.findForward("editEnrolmentInstructions");
    }

    public ActionForward prepareChangePeriodValues(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecutionSemester semester = (ExecutionSemester)this.getDomainObject(request, "semester");
        String periodOids = request.getParameter("periods");
        AbstractEnrolmentPeriodConfiguration conf = null;
        for (String periodOid : periodOids.split(":")) {
            EnrolmentPeriod period = (EnrolmentPeriod)FenixFramework.getDomainObject((String)periodOid);
            if (conf == null) {
                conf = new EnrolmentPeriodConfigurationForEdit(period.getInterval(), semester);
                ((EnrolmentPeriodConfigurationForEdit)conf).addPeriod(period);
                continue;
            }
            if (!conf.getInterval().equals((Object)period.getInterval())) continue;
            ((EnrolmentPeriodConfigurationForEdit)conf).addPeriod(period);
        }
        request.setAttribute("configuration", conf);
        return mapping.findForward("changePeriodValues");
    }

    public ActionForward changePeriodValues(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EnrolmentPeriodConfigurationForEdit configuration = (EnrolmentPeriodConfigurationForEdit)this.getRenderedObject("configuration");
        configuration.save();
        EnrolmentPeriodBean bean = new EnrolmentPeriodBean();
        bean.setSemester(configuration.getSemester());
        request.setAttribute("executionSemester", (Object)bean);
        return mapping.findForward("showEnrolementPeriods");
    }

    public ActionForward prepareCreatePeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecutionSemester semester = (ExecutionSemester)this.getDomainObject(request, "semester");
        EnrolmentPeriodConfigurationForCreation conf = new EnrolmentPeriodConfigurationForCreation(semester);
        request.setAttribute("configuration", (Object)conf);
        return mapping.findForward("createPeriod");
    }

    public ActionForward selectType(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        EnrolmentPeriodConfigurationForCreation configuration = (EnrolmentPeriodConfigurationForCreation)this.getRenderedObject("configuration");
        RenderUtils.invalidateViewState();
        request.setAttribute("configuration", (Object)configuration);
        return mapping.findForward("createPeriod");
    }

    public ActionForward createPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EnrolmentPeriodConfigurationForCreation configuration = (EnrolmentPeriodConfigurationForCreation)this.getRenderedObject("configuration");
        configuration.save();
        EnrolmentPeriodBean bean = new EnrolmentPeriodBean();
        bean.setSemester(configuration.getSemester());
        request.setAttribute("executionSemester", (Object)bean);
        return mapping.findForward("showEnrolementPeriods");
    }

    public static class EnrolmentPeriodConfigurationForEdit
    extends AbstractEnrolmentPeriodConfiguration {
        protected Set<EnrolmentPeriod> periods = new HashSet<EnrolmentPeriod>();
        public static final Advice advice$save = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

        public EnrolmentPeriodConfigurationForEdit(Interval interval, ExecutionSemester semester) {
            super(interval, semester);
        }

        public void addPeriod(EnrolmentPeriod period) {
            if (!AcademicPredicates.MANAGE_ENROLMENT_PERIODS.evaluate(period.getDegree())) {
                return;
            }
            this.periods.add(period);
            this.scope.add(period.getDegreeCurricularPlan());
        }

        @Override
        public SortedSet<DegreeCurricularPlan> getPossibleScope() {
            TreeSet<DegreeCurricularPlan> possible = new TreeSet<DegreeCurricularPlan>(DegreeCurricularPlan.COMPARATOR_BY_PRESENTATION_NAME);
            for (EnrolmentPeriod period : this.periods) {
                possible.add(period.getDegreeCurricularPlan());
            }
            return possible;
        }

        public Collection<String> getDegrees() {
            ArrayList<String> degrees = new ArrayList<String>();
            for (EnrolmentPeriod period : this.periods) {
                degrees.add(period.getDegree().getPresentationName(this.semester.getExecutionYear()));
            }
            Collections.sort(degrees);
            return degrees;
        }

        public String getPeriodOids() {
            Function<EnrolmentPeriod, String> f = new Function<EnrolmentPeriod, String>(){

                public String apply(EnrolmentPeriod period) {
                    return period.getExternalId();
                }
            };
            return Joiner.on((char)':').join(Iterables.transform(this.periods, (Function)f));
        }

        @Override
        public void save() {
            Object object = advice$save.perform((Callable)new ManageEnrolementPeriodsDA$EnrolmentPeriodConfigurationForEdit$callable$save(this));
        }

        static /* synthetic */ void advised$save(EnrolmentPeriodConfigurationForEdit this_) {
            for (EnrolmentPeriod period : this_.periods) {
                if (!this_.scope.contains((Object)period.getDegreeCurricularPlan())) continue;
                period.setStartDateDateTime(this_.start);
                period.setEndDateDateTime(this_.end);
            }
        }
    }

    public static class EnrolmentPeriodConfigurationForCreation
    extends AbstractEnrolmentPeriodConfiguration {
        private DegreeType degreeType;
        private EnrolmentPeriodType type;

        public EnrolmentPeriodConfigurationForCreation(ExecutionSemester semester) {
            super(null, semester);
        }

        public DegreeType getDegreeType() {
            return this.degreeType;
        }

        public void setDegreeType(DegreeType degreeType) {
            this.degreeType = degreeType;
        }

        public EnrolmentPeriodType getType() {
            return this.type;
        }

        public void setType(EnrolmentPeriodType type) {
            this.type = type;
        }

        @Override
        public SortedSet<DegreeCurricularPlan> getPossibleScope() {
            TreeSet<DegreeCurricularPlan> possible;
            block4: {
                possible = new TreeSet<DegreeCurricularPlan>(DegreeCurricularPlan.COMPARATOR_BY_PRESENTATION_NAME);
                if (this.degreeType == null || this.type == null || this.semester == null) break block4;
                if (this.degreeType.isBolonhaType()) {
                    for (ExecutionDegree execution : this.semester.getExecutionYear().getExecutionDegreesByType(this.degreeType)) {
                        DegreeCurricularPlan dcp = execution.getDegreeCurricularPlan();
                        this.addIfNotUsedInPeriod(possible, dcp);
                    }
                } else {
                    for (DegreeCurricularPlan dcp : DegreeCurricularPlan.readPreBolonhaDegreeCurricularPlans()) {
                        this.addIfNotUsedInPeriod(possible, dcp);
                    }
                }
            }
            return possible;
        }

        private void addIfNotUsedInPeriod(SortedSet<DegreeCurricularPlan> possible, DegreeCurricularPlan dcp) {
            boolean found = false;
            boolean hasAccess = AcademicPredicates.MANAGE_ENROLMENT_PERIODS.evaluate(dcp.getDegree());
            for (EnrolmentPeriod period : dcp.getEnrolmentPeriodsSet()) {
                if (!this.type.is(period) || !period.getExecutionPeriod().equals(this.semester)) continue;
                found = true;
                break;
            }
            if (!found && hasAccess) {
                possible.add(dcp);
            }
        }

        @Override
        public void save() {
            CreateEnrolmentPeriods.run(this.semester, this.degreeType, this.type, this.start, this.end, this.scope);
        }
    }

    public static abstract class AbstractEnrolmentPeriodConfiguration
    implements Serializable {
        protected DateTime start;
        protected DateTime end;
        protected ExecutionSemester semester;
        protected List<DegreeCurricularPlan> scope = new ArrayList<DegreeCurricularPlan>();

        public AbstractEnrolmentPeriodConfiguration(Interval interval, ExecutionSemester semester) {
            if (interval != null) {
                this.start = interval.getStart();
                this.end = interval.getEnd();
            }
            this.semester = semester;
        }

        public Interval getInterval() {
            return new Interval((ReadableInstant)this.start, (ReadableInstant)this.end);
        }

        public DateTime getStart() {
            return this.start;
        }

        public void setStart(DateTime start) {
            this.start = start;
        }

        public DateTime getEnd() {
            return this.end;
        }

        public void setEnd(DateTime end) {
            this.end = end;
        }

        public ExecutionSemester getSemester() {
            return this.semester;
        }

        public List<DegreeCurricularPlan> getScope() {
            return this.scope;
        }

        public void setScope(List<DegreeCurricularPlan> scope) {
            this.scope = scope;
        }

        public abstract SortedSet<DegreeCurricularPlan> getPossibleScope();

        public abstract void save();
    }

    public static class EnrolmentPeriodTypeConfiguration
    implements Serializable,
    Comparable<EnrolmentPeriodTypeConfiguration> {
        protected Class<? extends EnrolmentPeriod> type;
        protected ExecutionSemester semester;
        protected Map<Interval, EnrolmentPeriodConfigurationForEdit> configurations = new HashMap<Interval, EnrolmentPeriodConfigurationForEdit>();

        public EnrolmentPeriodTypeConfiguration(Class<? extends EnrolmentPeriod> type, ExecutionSemester semester) {
            this.type = type;
            this.semester = semester;
        }

        public void addPeriod(EnrolmentPeriod period) {
            if (!this.configurations.containsKey(period.getInterval())) {
                this.configurations.put(period.getInterval(), new EnrolmentPeriodConfigurationForEdit(period.getInterval(), this.semester));
            }
            this.configurations.get(period.getInterval()).addPeriod(period);
        }

        public Class<? extends EnrolmentPeriod> getType() {
            return this.type;
        }

        public Collection<EnrolmentPeriodConfigurationForEdit> getConfigurations() {
            return this.configurations.values();
        }

        @Override
        public int compareTo(EnrolmentPeriodTypeConfiguration o) {
            return this.getType().getSimpleName().compareTo(o.getType().getSimpleName());
        }
    }

    public static class EnrolmentPeriodBean
    implements Serializable {
        private ExecutionSemester semester;

        public ExecutionSemester getSemester() {
            return this.semester;
        }

        public void setSemester(ExecutionSemester semester) {
            this.semester = semester;
        }

        public SortedSet<ExecutionSemester> getSemesters() {
            TreeSet<ExecutionSemester> semesters = new TreeSet<ExecutionSemester>((Comparator<ExecutionSemester>)new ReverseComparator(ExecutionSemester.COMPARATOR_BY_SEMESTER_AND_YEAR));
            semesters.addAll(rootDomainObject.getExecutionPeriodsSet());
            return semesters;
        }

        public List<EnrolmentPeriodTypeConfiguration> getConfigurations() {
            ArrayList<EnrolmentPeriodTypeConfiguration> configurations = new ArrayList<EnrolmentPeriodTypeConfiguration>();
            if (this.semester != null) {
                HashMap map = new HashMap();
                for (EnrolmentPeriod period : this.semester.getEnrolmentPeriodSet()) {
                    if (!VALID_ENROLMENT_PERIODS.contains(((Object)((Object)period)).getClass()) || !AcademicPredicates.MANAGE_ENROLMENT_PERIODS.evaluate(period.getDegree())) continue;
                    if (!map.containsKey(((Object)((Object)period)).getClass())) {
                        map.put(((Object)((Object)period)).getClass(), new EnrolmentPeriodTypeConfiguration(((Object)((Object)period)).getClass(), this.semester));
                    }
                    ((EnrolmentPeriodTypeConfiguration)map.get(((Object)((Object)period)).getClass())).addPeriod(period);
                }
                configurations.addAll(map.values());
                Collections.sort(configurations);
            }
            return configurations;
        }
    }
}

