/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers.executionDegree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.bennu.core.presentationTier.renderers.autoCompleteProvider.AutoCompleteProvider;
import org.fenixedu.commons.StringNormalizer;
import pt.ist.fenixframework.FenixFramework;

public class ExecutionDegreeAutoCompleteProvider
implements AutoCompleteProvider<ExecutionDegree> {
    public Collection<ExecutionDegree> getSearchResults(Map<String, String> argsMap, String value, int maxCount) {
        String executionYearOid = argsMap.get("executionYearOid");
        ExecutionYear executionYear = (ExecutionYear)FenixFramework.getDomainObject((String)executionYearOid);
        String searchValue = StringNormalizer.normalize((String)value);
        ArrayList<ExecutionDegree> result = new ArrayList<ExecutionDegree>();
        for (ExecutionDegree executionDegree : executionYear.getExecutionDegreesSet()) {
            DegreeCurricularPlan degreeCurricularPlan = executionDegree.getDegreeCurricularPlan();
            Degree degree = degreeCurricularPlan.getDegree();
            if (!this.match(searchValue, degreeCurricularPlan.getName()) && !this.match(searchValue, degree.getNameI18N(executionYear).getContent()) && !this.match(searchValue, degree.getSigla())) continue;
            result.add(executionDegree);
            if (result.size() < maxCount) continue;
            break;
        }
        return result;
    }

    private boolean match(String stringToMatch, String content) {
        String normalizedContent = StringNormalizer.normalize((String)content);
        return normalizedContent.indexOf(stringToMatch) >= 0;
    }
}

