/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.degreeStructure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.ui.renderers.degreeStructure.DegreeCurricularPlanLayout;
import org.fenixedu.academic.ui.renderers.degreeStructure.DegreeCurricularPlanRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlTable;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;

class DegreeCurricularPlanYearsLayout
extends DegreeCurricularPlanLayout {
    private Map<CurricularPeriod, Collection<Context>> contextsToDrawInNextPeriod = new HashMap<CurricularPeriod, Collection<Context>>();

    protected DegreeCurricularPlanYearsLayout(DegreeCurricularPlanRenderer degreeCurricularPlanRenderer) {
        super(degreeCurricularPlanRenderer);
    }

    @Override
    protected void draw(DegreeCurricularPlan degreeCurricularPlan, HtmlTable mainTable) {
        CurricularPeriod degreeStructure = degreeCurricularPlan.getDegreeStructure();
        for (CurricularPeriod curricularPeriod : degreeStructure.getSortedChilds()) {
            this.drawTopCurricularPeriods(curricularPeriod, mainTable, 0);
        }
    }

    private void drawTopCurricularPeriods(CurricularPeriod curricularPeriod, HtmlTable mainTable, int level) {
        if (curricularPeriod.getChildsSet().isEmpty()) {
            return;
        }
        for (CurricularPeriod child : curricularPeriod.getSortedChilds()) {
            this.drawCurricularPeriodRow(mainTable, child, level);
            this.drawContexts(child, mainTable, level + 1);
            if (!this.contextsToDrawInNextPeriod.containsKey(child)) continue;
            this.drawExtraContextsInNextPeriod(child, mainTable, level + 1);
        }
    }

    private void drawCurricularPeriodRow(HtmlTable mainTable, CurricularPeriod child, int level) {
        HtmlTableRow groupRow = mainTable.createRow();
        groupRow.setClasses(this.getCourseGroupRowClass());
        this.addTabsToRow(groupRow, level);
        HtmlTableCell cell1 = groupRow.createCell();
        cell1.setClasses(this.getLabelCellClass());
        cell1.setBody((HtmlComponent)new HtmlText(child.getFullLabel()));
        cell1.setColspan(Integer.valueOf(this.getMaxColSpanForTextOnGroupsWithChilds()));
        HtmlTableCell cell2 = groupRow.createCell();
        cell2.setClasses(this.getLabelCellClass());
        cell2.setBody((HtmlComponent)new HtmlText(this.getLabel("label.degreeCurricularPlan.renderer.group")));
        HtmlTableCell cell3 = groupRow.createCell();
        cell3.setClasses(this.getLabelCellClass());
        cell3.setColspan(Integer.valueOf(this.getMaxLineSize() - this.getMaxColSpanForTextOnGroupsWithChilds() - 1));
    }

    private void drawContexts(CurricularPeriod child, HtmlTable mainTable, int level) {
        for (Context context : this.getSortedContextsByCurricularCourseName(child)) {
            if (this.hasExecutionInterval() && !context.isValid(this.getExecutionInterval())) continue;
            this.drawContext(context, mainTable, level);
        }
    }

    private Collection<Context> getSortedContextsByCurricularCourseName(CurricularPeriod period) {
        ArrayList<Context> contexts = new ArrayList<Context>(period.getContextsWithCurricularCourses());
        Collections.sort(contexts, Context.COMPARATOR_BY_DEGREE_MODULE_NAME);
        return contexts;
    }

    private void drawContext(Context context, HtmlTable mainTable, int level) {
        HtmlTableRow row = mainTable.createRow();
        this.addTabsToRow(row, level);
        row.setClasses(this.getCurricularCourseRowClass());
        CurricularCourse curricularCourse = (CurricularCourse)((Object)context.getChildDegreeModule());
        this.drawCurricularCourseName(curricularCourse, row, this.isCurricularCourseLinkable(), level);
        this.drawCourseGroupName(context.getParentCourseGroup(), row, level);
        if (curricularCourse.isOptionalCurricularCourse()) {
            this.drawOptionalCellInformation(row);
        } else {
            this.drawRegime(curricularCourse, row);
            this.drawCourseLoad(curricularCourse, context.getCurricularPeriod(), row);
            this.drawEctsCredits(curricularCourse, context.getCurricularPeriod(), row);
        }
        this.drawCurricularRulesRows((DegreeModule)((Object)curricularCourse), null, mainTable, level + 1);
        if (curricularCourse.isAnual(this.getExecutionInterval()) && context.getCurricularPeriod().getChildOrder() == 1) {
            this.addContextToProcessInNextPeriod(context, context.getCurricularPeriod().getNext());
        }
    }

    private void addContextToProcessInNextPeriod(Context context, CurricularPeriod period) {
        Collection<Context> collection = this.contextsToDrawInNextPeriod.get(period);
        if (collection == null) {
            collection = new HashSet<Context>();
            this.contextsToDrawInNextPeriod.put(period, collection);
        }
        collection.add(context);
    }

    private void drawCourseGroupName(CourseGroup parentCourseGroup, HtmlTableRow row, int level) {
        HtmlTableCell cell = row.createCell();
        cell.setClasses(this.getCurriclarCourseCellClass());
        cell.setBody((HtmlComponent)new HtmlText(parentCourseGroup.getName()));
    }

    private void drawExtraContextsInNextPeriod(CurricularPeriod period, HtmlTable mainTable, int level) {
        for (Context context : this.contextsToDrawInNextPeriod.get(period)) {
            HtmlTableRow row = mainTable.createRow();
            this.addTabsToRow(row, level);
            row.setClasses(this.getCurricularCourseRowClass());
            CurricularCourse curricularCourse = (CurricularCourse)((Object)context.getChildDegreeModule());
            this.drawCurricularCourseName(curricularCourse, row, false, level);
            this.drawCourseGroupName(context.getParentCourseGroup(), row, level);
            if (curricularCourse.isOptionalCurricularCourse()) {
                this.drawOptionalCellInformation(row);
            } else {
                this.drawRegime(curricularCourse, row);
                this.drawCourseLoad(curricularCourse, period, row);
                this.drawEctsCredits(curricularCourse, period, row);
            }
            this.drawCurricularRulesRows((DegreeModule)((Object)curricularCourse), null, mainTable, level + 1);
        }
    }
}

