/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.student;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.apache.struts.util.MessageResources;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Project;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.WrittenTest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.ui.faces.bean.base.FenixBackingBean;
import org.fenixedu.academic.ui.faces.components.util.CalendarLink;
import org.fenixedu.academic.util.PeriodState;
import org.fenixedu.commons.i18n.I18N;

public class StudentCalendarBackingBean
extends FenixBackingBean {
    private static final DateFormat hourFormat = new SimpleDateFormat("HH:mm");
    private static final MessageResources messages = MessageResources.getMessageResources((String)"resources.StudentResources");
    private static final Comparator<ExecutionCourse> executionCourseComparator = new Comparator<ExecutionCourse>(){

        @Override
        public int compare(ExecutionCourse o1, ExecutionCourse o2) {
            return o1.getNome().compareTo(o2.getNome());
        }
    };
    private Collection<ExecutionSemester> executionSemesters;
    private Collection<ExecutionCourse> executionCourses;
    private ExecutionSemester executionSemester;
    private Registration registration;
    boolean setExecutionCourse = true;
    private String evaluationTypeClassname;

    protected Person getPerson() {
        return this.getUserView() == null ? null : this.getUserView().getPerson();
    }

    public Collection<ExecutionSemester> getExecutionPeriods() {
        if (this.executionSemesters == null) {
            Registration registration = this.getStudent();
            this.executionSemesters = new TreeSet<ExecutionSemester>(ExecutionSemester.COMPARATOR_BY_SEMESTER_AND_YEAR);
            if (registration != null) {
                for (Attends attends : registration.getAssociatedAttendsSet()) {
                    this.executionSemesters.add(attends.getExecutionCourse().getExecutionPeriod());
                }
            }
        }
        return this.executionSemesters;
    }

    public Collection<ExecutionCourse> getExecutionCourses() {
        ExecutionSemester executionSemester = this.getExecutionPeriod();
        if (this.executionCourses == null || !this.executionCourses.isEmpty() && executionSemester != this.executionCourses.iterator().next().getExecutionPeriod()) {
            Registration registration = this.getStudent();
            this.executionCourses = new TreeSet<ExecutionCourse>(executionCourseComparator);
            if (registration != null) {
                for (Attends attends : registration.getAssociatedAttendsSet()) {
                    ExecutionCourse executionCourse = attends.getExecutionCourse();
                    if (executionCourse.getExecutionPeriod() != executionSemester) continue;
                    this.executionCourses.add(executionCourse);
                }
            }
        }
        return this.executionCourses;
    }

    public ExecutionSemester getExecutionPeriod() {
        Collection<ExecutionSemester> executionSemesters;
        String executionPeriodID = this.getExecutionPeriodID();
        if (!(this.executionSemester != null && executionPeriodID.equals(this.executionSemester.getExternalId()) || (executionSemesters = this.getExecutionPeriods()) == null)) {
            for (ExecutionSemester executionSemester : executionSemesters) {
                if (!executionSemester.getExternalId().equals(executionPeriodID)) continue;
                this.executionSemester = executionSemester;
                break;
            }
        }
        return this.executionSemester;
    }

    public List<SelectItem> getRegistrationsSelectItems() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (Registration registration : this.getPerson().getStudent().getActiveRegistrations()) {
            result.add(new SelectItem((Object)registration.getExternalId(), registration.getDegreeNameWithDegreeCurricularPlanName()));
        }
        if (!result.isEmpty()) {
            this.setRegistrationID(this.getPerson().getStudent().getLastActiveRegistration().getExternalId());
        }
        return result;
    }

    public String getRegistrationID() {
        return (String)this.getViewState().getAttribute("registrationID");
    }

    public void setRegistrationID(String registrationID) {
        this.getViewState().setAttribute("registrationID", registrationID);
    }

    public Registration getStudent() {
        if (this.registration == null) {
            for (Registration activeRegistration : this.getPerson().getStudent().getActiveRegistrations()) {
                if (!activeRegistration.getExternalId().equals(this.getRegistrationID())) continue;
                this.registration = activeRegistration;
                break;
            }
        }
        return this.registration;
    }

    public Date getCalendarStartDate() {
        ExecutionSemester executionSemester = this.getExecutionPeriod();
        String evaluationTypeClassname = this.getEvaluationTypeClassname();
        Registration registration = this.getStudent();
        StudentCurricularPlan studentCurricularPlan = registration != null ? registration.getActiveStudentCurricularPlan() : null;
        DegreeCurricularPlan degreeCurricularPlan = studentCurricularPlan != null ? studentCurricularPlan.getDegreeCurricularPlan() : null;
        ExecutionDegree executionDegree = this.findExecutinDegree(degreeCurricularPlan, executionSemester);
        if (evaluationTypeClassname == null || evaluationTypeClassname.length() == 0 || executionDegree == null) {
            if (executionDegree != null && executionSemester.getSemester() == 1 && executionDegree.getPeriodLessonsFirstSemester() != null) {
                return executionDegree.getPeriodLessonsFirstSemester().getStart();
            }
            if (executionDegree != null && executionSemester.getSemester() == 2 && executionDegree.getPeriodLessonsSecondSemester() != null) {
                return executionDegree.getPeriodLessonsSecondSemester().getStart();
            }
            if (executionSemester != null) {
                return executionSemester.getBeginDate();
            }
        } else if (evaluationTypeClassname.equals(Exam.class.getName())) {
            if (executionSemester.getSemester() == 1) {
                return executionDegree.getPeriodExamsFirstSemester().getStart();
            }
            if (executionSemester.getSemester() == 2) {
                return executionDegree.getPeriodExamsSecondSemester().getStart();
            }
        } else if (evaluationTypeClassname.equals(WrittenTest.class.getName())) {
            if (executionSemester.getSemester() == 1) {
                return executionDegree.getPeriodLessonsFirstSemester().getStart();
            }
            if (executionSemester.getSemester() == 2) {
                return executionDegree.getPeriodLessonsSecondSemester().getStart();
            }
        } else if (evaluationTypeClassname.equals(WrittenTest.class.getName()) || evaluationTypeClassname.equals(Project.class.getName())) {
            if (executionSemester.getSemester() == 1) {
                return executionDegree.getPeriodLessonsFirstSemester().getStart();
            }
            if (executionSemester.getSemester() == 2) {
                return executionDegree.getPeriodLessonsSecondSemester().getStart();
            }
        }
        return null;
    }

    public Date getCalendarEndDate() {
        ExecutionSemester executionSemester = this.getExecutionPeriod();
        String evaluationTypeClassname = this.getEvaluationTypeClassname();
        StudentCurricularPlan studentCurricularPlan = this.getStudent().getActiveStudentCurricularPlan();
        DegreeCurricularPlan degreeCurricularPlan = studentCurricularPlan != null ? studentCurricularPlan.getDegreeCurricularPlan() : null;
        ExecutionDegree executionDegree = this.findExecutinDegree(degreeCurricularPlan, executionSemester);
        if (evaluationTypeClassname == null || evaluationTypeClassname.length() == 0 || executionDegree == null) {
            if (executionDegree != null && executionSemester.getSemester() == 1 && executionDegree.getPeriodExamsFirstSemester() != null) {
                return executionDegree.getPeriodExamsFirstSemester().getEnd();
            }
            if (executionDegree != null && executionSemester.getSemester() == 2 && executionDegree.getPeriodExamsSecondSemester() != null) {
                return executionDegree.getPeriodExamsSecondSemester().getEnd();
            }
            if (executionSemester != null) {
                return executionSemester.getEndDate();
            }
        } else if (evaluationTypeClassname.equals(Exam.class.getName())) {
            if (executionSemester.getSemester() == 1) {
                return executionDegree.getPeriodExamsFirstSemester().getEnd();
            }
            if (executionSemester.getSemester() == 2) {
                return executionDegree.getPeriodExamsSecondSemester().getEnd();
            }
        } else if (evaluationTypeClassname.equals(WrittenTest.class.getName()) || evaluationTypeClassname.equals(Project.class.getName())) {
            if (executionSemester.getSemester() == 1) {
                return executionDegree.getPeriodLessonsFirstSemester().getEnd();
            }
            if (executionSemester.getSemester() == 2) {
                return executionDegree.getPeriodLessonsSecondSemester().getEnd();
            }
        }
        return null;
    }

    private ExecutionDegree findExecutinDegree(DegreeCurricularPlan degreeCurricularPlan, ExecutionSemester executionSemester) {
        if (degreeCurricularPlan != null) {
            for (ExecutionDegree executionDegree : degreeCurricularPlan.getExecutionDegreesSet()) {
                if (executionSemester == null || executionDegree.getExecutionYear() != executionSemester.getExecutionYear()) continue;
                return executionDegree;
            }
        }
        return null;
    }

    public List<CalendarLink> getCalendarLinks() {
        ArrayList<CalendarLink> calendarLinks = new ArrayList<CalendarLink>();
        ExecutionSemester executionSemester = this.getExecutionPeriod();
        Registration registration = this.getStudent();
        for (Attends attends : registration.getAssociatedAttendsSet()) {
            ExecutionCourse executionCourse = attends.getExecutionCourse();
            if (executionCourse.getExecutionPeriod() != executionSemester || this.getExecutionCourseID() != null && !this.getExecutionCourseID().equals(executionCourse.getExternalId())) continue;
            for (Evaluation evaluation : executionCourse.getAssociatedEvaluationsSet()) {
                String evaluationTypeClassname;
                if (evaluation instanceof WrittenEvaluation) {
                    Exam exam;
                    if (evaluation instanceof Exam && !(exam = (Exam)((Object)evaluation)).isExamsMapPublished()) continue;
                    WrittenEvaluation writtenEvaluation = (WrittenEvaluation)((Object)evaluation);
                    evaluationTypeClassname = this.getEvaluationTypeClassname();
                    if (evaluationTypeClassname != null && evaluationTypeClassname.length() != 0 && !evaluationTypeClassname.equals(((Object)((Object)writtenEvaluation)).getClass().getName())) continue;
                    CalendarLink calendarLink = new CalendarLink(executionCourse, writtenEvaluation, I18N.getLocale());
                    calendarLink.setAsLink(false);
                    calendarLinks.add(calendarLink);
                    calendarLink.setLinkParameters(this.constructLinkParameters(executionCourse));
                    continue;
                }
                if (!(evaluation instanceof Project)) continue;
                Project project = (Project)((Object)evaluation);
                evaluationTypeClassname = this.getEvaluationTypeClassname();
                if (evaluationTypeClassname != null && evaluationTypeClassname.length() != 0 && !evaluationTypeClassname.equals(((Object)((Object)project)).getClass().getName())) continue;
                CalendarLink calendarLinkBegin = new CalendarLink(false);
                calendarLinks.add(calendarLinkBegin);
                calendarLinkBegin.setObjectOccurrence(project.getBegin());
                calendarLinkBegin.setObjectLinkLabel(this.constructCalendarPresentation(executionCourse, project, project.getBegin(), messages.getMessage("label.evaluation.project.begin")));
                calendarLinkBegin.setLinkParameters(this.constructLinkParameters(executionCourse));
                CalendarLink calendarLinkEnd = new CalendarLink(false);
                calendarLinks.add(calendarLinkEnd);
                calendarLinkEnd.setObjectOccurrence(project.getEnd());
                calendarLinkEnd.setObjectLinkLabel(this.constructCalendarPresentation(executionCourse, project, project.getEnd(), messages.getMessage("label.evaluation.project.end")));
                calendarLinkEnd.setLinkParameters(this.constructLinkParameters(executionCourse));
            }
        }
        return calendarLinks;
    }

    public List<SelectItem> getExecutionPeriodSelectItems() {
        ArrayList<SelectItem> executionPeriodSelectItems = new ArrayList<SelectItem>();
        for (ExecutionSemester executionSemester : this.getExecutionPeriods()) {
            if (executionSemester.getState() == PeriodState.NOT_OPEN) continue;
            ExecutionYear executionYear = executionSemester.getExecutionYear();
            executionPeriodSelectItems.add(new SelectItem((Object)executionSemester.getExternalId(), executionSemester.getName() + " " + executionYear.getYear()));
        }
        return executionPeriodSelectItems;
    }

    public List<SelectItem> getExecutionCourseSelectItems() {
        ArrayList<SelectItem> executionPeriodSelectItems = new ArrayList<SelectItem>();
        for (ExecutionCourse executionCourse : this.getExecutionCourses()) {
            executionPeriodSelectItems.add(new SelectItem((Object)executionCourse.getExternalId(), executionCourse.getNome()));
        }
        return executionPeriodSelectItems;
    }

    private Map<String, String> constructLinkParameters(ExecutionCourse executionCourse) {
        HashMap<String, String> linkParameters = new HashMap<String, String>();
        linkParameters.put("method", "evaluations");
        linkParameters.put("executionPeriodOID", executionCourse.getExecutionPeriod().getExternalId().toString());
        linkParameters.put("executionCourseID", executionCourse.getExternalId().toString());
        return linkParameters;
    }

    private String constructCalendarPresentation(ExecutionCourse executionCourse, Project project, Date time, String tail) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(messages.getMessage("label.evaluation.shortname.project"));
        stringBuilder.append(" ");
        stringBuilder.append(executionCourse.getSigla());
        stringBuilder.append(" (");
        stringBuilder.append(new SimpleDateFormat("HH:mm").format(time));
        stringBuilder.append(") ");
        stringBuilder.append(tail);
        return stringBuilder.toString();
    }

    public String getApplicationContext() {
        return this.getRequest().getContextPath();
    }

    public String getExecutionPeriodID() {
        Collection<ExecutionSemester> executionSemesters;
        if (this.getViewState().getAttribute("executionPeriodID") == null && (executionSemesters = this.getExecutionPeriods()) != null) {
            for (ExecutionSemester executionSemester : executionSemesters) {
                if (!executionSemester.getState().equals(PeriodState.CURRENT)) continue;
                this.setExecutionPeriodID(executionSemester.getExternalId());
                break;
            }
        }
        return (String)this.getViewState().getAttribute("executionPeriodID");
    }

    public void setExecutionPeriodID(String executionPeriodID) {
        this.getViewState().setAttribute("executionPeriodID", executionPeriodID);
    }

    public String getExecutionCourseID() {
        return (String)this.getViewState().getAttribute("executionCourseID");
    }

    public void setExecutionCourseID(String executionCourseID) {
        if (this.setExecutionCourse) {
            this.getViewState().setAttribute("executionCourseID", executionCourseID);
        }
    }

    public String getEvaluationTypeClassname() {
        return this.evaluationTypeClassname;
    }

    public void setEvaluationTypeClassname(String evaluationTypeClassname) {
        this.evaluationTypeClassname = evaluationTypeClassname;
    }

    public void resetExecutionCourses(ValueChangeEvent event) {
        this.getViewState().removeAttribute("executionCourseID");
        this.setExecutionCourse = false;
        this.executionCourses = null;
    }

    public void resetExecutionCourse(ValueChangeEvent event) {
        if (event.getNewValue() == null) {
            this.getViewState().removeAttribute("executionCourseID");
        }
    }
}

