/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.gep;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.faces.model.SelectItem;
import org.fenixedu.academic.dto.InfoExecutionYear;
import org.fenixedu.academic.service.services.commons.ReadNotClosedExecutionYears;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.gep.ListMasterDegreeStudents;
import org.fenixedu.academic.ui.faces.bean.base.FenixBackingBean;

public class ListFirstTimeEnrolmentMasterDegreeStudents
extends FenixBackingBean {
    private String selectedExecutionYear;

    public Collection getStudentCurricularPlans() throws FenixServiceException {
        if (this.getSelectedExecutionYear() == null || this.getSelectedExecutionYear().length() == 0) {
            return new ArrayList();
        }
        return ListMasterDegreeStudents.run(this.getSelectedExecutionYear());
    }

    public List<SelectItem> getExecutionYears() throws FenixServiceException {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        List<InfoExecutionYear> executionYears = ReadNotClosedExecutionYears.run();
        Collections.sort(executionYears, new Comparator<InfoExecutionYear>(){

            @Override
            public int compare(InfoExecutionYear o1, InfoExecutionYear o2) {
                return o1.getYear().compareTo(o2.getYear()) * -1;
            }
        });
        for (InfoExecutionYear executionYear : executionYears) {
            result.add(new SelectItem((Object)executionYear.getYear(), executionYear.getYear()));
        }
        return result;
    }

    public String getSelectedExecutionYear() {
        return this.selectedExecutionYear;
    }

    public void setSelectedExecutionYear(String selectedExecutionYear) {
        this.selectedExecutionYear = selectedExecutionYear;
    }
}

