/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.resourceAllocationManager;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.dto.InfoClass;
import org.fenixedu.academic.service.filter.ResourceAllocationManagerAuthorizationFilter;
import org.fenixedu.academic.service.filter.StudentAuthorizationFilter;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.resourceAllocationManager.ReadClassesByExecutionCourse$callable$runReadClassesByExecutionCourse;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ReadClassesByExecutionCourse {
    private static final ReadClassesByExecutionCourse serviceInstance;
    public static final Advice advice$runReadClassesByExecutionCourse;

    public List<InfoClass> run(ExecutionCourse executionCourse) {
        Set<SchoolClass> classes = executionCourse.findSchoolClasses();
        ArrayList<InfoClass> infoClasses = new ArrayList<InfoClass>(classes.size());
        for (SchoolClass schoolClass : classes) {
            InfoClass infoClass = InfoClass.newInfoFromDomain(schoolClass);
            infoClasses.add(infoClass);
        }
        return infoClasses;
    }

    public static List<InfoClass> runReadClassesByExecutionCourse(ExecutionCourse executionCourse) throws NotAuthorizedException {
        return (List)advice$runReadClassesByExecutionCourse.perform((Callable)new ReadClassesByExecutionCourse$callable$runReadClassesByExecutionCourse(executionCourse));
    }

    static /* synthetic */ List<InfoClass> advised$runReadClassesByExecutionCourse(ExecutionCourse executionCourse) throws NotAuthorizedException {
        try {
            ResourceAllocationManagerAuthorizationFilter.instance.execute();
            return serviceInstance.run(executionCourse);
        }
        catch (NotAuthorizedException ex1) {
            StudentAuthorizationFilter.instance.execute();
            return serviceInstance.run(executionCourse);
        }
    }

    static {
        advice$runReadClassesByExecutionCourse = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new ReadClassesByExecutionCourse();
    }
}

