/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.manager.organizationalStructureManagement;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityType;
import org.fenixedu.academic.domain.organizationalStructure.AggregateUnit;
import org.fenixedu.academic.domain.organizationalStructure.CompetenceCourseGroupUnit;
import org.fenixedu.academic.domain.organizationalStructure.CountryUnit;
import org.fenixedu.academic.domain.organizationalStructure.DegreeUnit;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.domain.organizationalStructure.ManagementCouncilUnit;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.PlanetUnit;
import org.fenixedu.academic.domain.organizationalStructure.SchoolUnit;
import org.fenixedu.academic.domain.organizationalStructure.ScientificAreaUnit;
import org.fenixedu.academic.domain.organizationalStructure.ScientificCouncilUnit;
import org.fenixedu.academic.domain.organizationalStructure.SectionUnit;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitClassification;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.service.ServiceMonitoring;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.manager.organizationalStructureManagement.CreateUnit$callable$run;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreateUnit {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static Unit run(Unit unit, MultiLanguageString multiLanguageString, String string, String string2, String string3, YearMonthDay yearMonthDay, YearMonthDay yearMonthDay2, PartyTypeEnum partyTypeEnum, String string4, String string5, String string6, AccountabilityType accountabilityType, String string7, UnitClassification unitClassification, Boolean bl, String string8) throws FenixServiceException {
        return (Unit)((Object)advice$run.perform((Callable)new CreateUnit$callable$run(unit, multiLanguageString, string, string2, string3, yearMonthDay, yearMonthDay2, partyTypeEnum, string4, string5, string6, accountabilityType, string7, unitClassification, bl, string8)));
    }

    static /* synthetic */ Unit advised$run(Unit parentUnit, MultiLanguageString unitName, String unitNameCard, String unitCostCenter, String acronym, YearMonthDay begin, YearMonthDay end, PartyTypeEnum type, String departmentID, String degreeID, String administrativeOfficeID, AccountabilityType accountabilityType, String webAddress, UnitClassification classification, Boolean canBeResponsibleOfSpaces, String campusID) throws FenixServiceException {
        ServiceMonitoring.logService(CreateUnit.class, new Object[]{parentUnit, unitName, unitNameCard, unitCostCenter, acronym, begin, end, type, departmentID, degreeID, administrativeOfficeID, accountabilityType, webAddress, classification, canBeResponsibleOfSpaces, campusID});
        Integer costCenterCode = CreateUnit.getCostCenterCode(unitCostCenter);
        Space campus = (Space)FenixFramework.getDomainObject((String)campusID);
        if (type != null) {
            switch (type) {
                case DEPARTMENT: {
                    Department department = (Department)FenixFramework.getDomainObject((String)departmentID);
                    return DepartmentUnit.createNewInternalDepartmentUnit(unitName, unitNameCard, costCenterCode, acronym, begin, end, parentUnit, accountabilityType, webAddress, department, classification, canBeResponsibleOfSpaces, campus);
                }
                case DEGREE_UNIT: {
                    Degree degree = (Degree)FenixFramework.getDomainObject((String)degreeID);
                    return DegreeUnit.createNewInternalDegreeUnit(unitName, unitNameCard, costCenterCode, acronym, begin, end, parentUnit, accountabilityType, webAddress, degree, classification, canBeResponsibleOfSpaces, campus);
                }
                case PLANET: {
                    return PlanetUnit.createNewPlanetUnit(unitName, unitNameCard, costCenterCode, acronym, begin, end, parentUnit, webAddress, classification, canBeResponsibleOfSpaces, campus);
                }
                case COUNTRY: {
                    return CountryUnit.createNewCountryUnit(unitName, unitNameCard, costCenterCode, acronym, begin, end, parentUnit, webAddress, classification, canBeResponsibleOfSpaces, campus);
                }
                case SCHOOL: {
                    return SchoolUnit.createNewSchoolUnit(unitName, unitNameCard, costCenterCode, acronym, begin, end, parentUnit, webAddress, classification, canBeResponsibleOfSpaces, campus);
                }
                case UNIVERSITY: {
                    return UniversityUnit.createNewUniversityUnit(unitName, unitNameCard, costCenterCode, acronym, begin, end, parentUnit, webAddress, classification, canBeResponsibleOfSpaces, campus);
                }
                case ADMINISTRATIVE_OFFICE_UNIT: {
                    AdministrativeOffice office = (AdministrativeOffice)FenixFramework.getDomainObject((String)administrativeOfficeID);
                    Unit unit = Unit.createNewUnit(unitName, unitNameCard, costCenterCode, acronym, begin, end, parentUnit, accountabilityType, webAddress, classification, office, canBeResponsibleOfSpaces, campus);
                    unit.setType(type);
                    return unit;
                }
                case AGGREGATE_UNIT: {
                    return AggregateUnit.createNewAggregateUnit(unitName, unitNameCard, costCenterCode, acronym, begin, end, parentUnit, accountabilityType, webAddress, classification, canBeResponsibleOfSpaces, campus);
                }
                case COMPETENCE_COURSE_GROUP: {
                    return CompetenceCourseGroupUnit.createNewInternalCompetenceCourseGroupUnit(unitName, unitNameCard, costCenterCode, acronym, begin, end, parentUnit, accountabilityType, webAddress, classification, canBeResponsibleOfSpaces, campus);
                }
                case SCIENTIFIC_AREA: {
                    return ScientificAreaUnit.createNewInternalScientificArea(unitName, unitNameCard, costCenterCode, acronym, begin, end, parentUnit, accountabilityType, webAddress, classification, canBeResponsibleOfSpaces, campus);
                }
                case SECTION: {
                    return SectionUnit.createNewSectionUnit(unitName, unitNameCard, costCenterCode, acronym, begin, end, parentUnit, accountabilityType, webAddress, classification, canBeResponsibleOfSpaces, campus);
                }
                case MANAGEMENT_COUNCIL: {
                    return ManagementCouncilUnit.createManagementCouncilUnit(unitName, unitNameCard, costCenterCode, acronym, begin, end, parentUnit, accountabilityType, webAddress, classification, canBeResponsibleOfSpaces, campus);
                }
                case SCIENTIFIC_COUNCIL: {
                    return ScientificCouncilUnit.createScientificCouncilUnit(unitName, unitNameCard, costCenterCode, acronym, begin, end, parentUnit, accountabilityType, webAddress, classification, canBeResponsibleOfSpaces, campus);
                }
            }
        } else {
            return Unit.createNewUnit(unitName, unitNameCard, costCenterCode, acronym, begin, end, parentUnit, accountabilityType, webAddress, classification, null, canBeResponsibleOfSpaces, campus);
        }
        throw new FenixServiceException("createUnit.service.empty.unit.type");
    }

    private static Integer getCostCenterCode(String unitCostCenter) {
        Integer costCenterCode = null;
        if (unitCostCenter != null && !unitCostCenter.equals("")) {
            costCenterCode = Integer.valueOf(unitCostCenter);
        }
        return costCenterCode;
    }
}

