/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.bolonhaManager;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLoad;
import org.fenixedu.academic.domain.degreeStructure.RegimeType;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.dto.bolonhaManager.CourseLoad;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.service.services.bolonhaManager.EditCompetenceCourseLoad$callable$run;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EditCompetenceCourseLoad {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void run(String string, RegimeType regimeType, Integer n, List<CourseLoad> list) throws FenixServiceException {
        Object object = advice$run.perform((Callable)new EditCompetenceCourseLoad$callable$run(string, regimeType, n, list));
    }

    static /* synthetic */ void advised$run(String competenceCourseID, RegimeType regimeType, Integer numberOfPeriods, List<CourseLoad> courseLoads) throws FenixServiceException {
        AccessControl.check(RolePredicates.BOLONHA_MANAGER_PREDICATE);
        CompetenceCourse competenceCourse = (CompetenceCourse)FenixFramework.getDomainObject((String)competenceCourseID);
        if (competenceCourse == null) {
            throw new FenixServiceException("error.noCompetenceCourse");
        }
        competenceCourse.setRegime(regimeType);
        AcademicPeriod academicPeriod = AcademicPeriod.SEMESTER;
        for (CourseLoad courseLoad : courseLoads) {
            if (courseLoad.getAction().equals("create") && competenceCourse.getCompetenceCourseLoads().size() < numberOfPeriods) {
                competenceCourse.addCompetenceCourseLoad(courseLoad.getTheoreticalHours(), courseLoad.getProblemsHours(), courseLoad.getLaboratorialHours(), courseLoad.getSeminaryHours(), courseLoad.getFieldWorkHours(), courseLoad.getTrainingPeriodHours(), courseLoad.getTutorialOrientationHours(), courseLoad.getAutonomousWorkHours(), courseLoad.getEctsCredits(), courseLoad.getOrder(), academicPeriod);
                continue;
            }
            CompetenceCourseLoad competenceCourseLoad = (CompetenceCourseLoad)FenixFramework.getDomainObject((String)courseLoad.getIdentification());
            if (competenceCourseLoad != null && courseLoad.getAction().equals("edit")) {
                competenceCourseLoad.edit(courseLoad.getTheoreticalHours(), courseLoad.getProblemsHours(), courseLoad.getLaboratorialHours(), courseLoad.getSeminaryHours(), courseLoad.getFieldWorkHours(), courseLoad.getTrainingPeriodHours(), courseLoad.getTutorialOrientationHours(), courseLoad.getAutonomousWorkHours(), courseLoad.getEctsCredits(), courseLoad.getOrder(), academicPeriod);
                continue;
            }
            if (competenceCourseLoad == null || !courseLoad.getAction().equals("delete")) continue;
            competenceCourseLoad.delete();
        }
    }
}

