/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.bolonhaManager;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CompetenceCourseType;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLevel;
import org.fenixedu.academic.domain.degreeStructure.CurricularStage;
import org.fenixedu.academic.domain.degreeStructure.RegimeType;
import org.fenixedu.academic.domain.organizationalStructure.CompetenceCourseGroupUnit;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.service.services.bolonhaManager.CreateCompetenceCourse$callable$run;
import org.fenixedu.academic.service.services.exceptions.ExistingCompetenceCourseInformationException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.util.StringFormatter;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreateCompetenceCourse {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static CompetenceCourse run(String string, String string2, String string3, Boolean bl, RegimeType regimeType, CompetenceCourseLevel competenceCourseLevel, CompetenceCourseType competenceCourseType, String string4, ExecutionSemester executionSemester, String string5) throws FenixServiceException {
        return (CompetenceCourse)((Object)advice$run.perform((Callable)new CreateCompetenceCourse$callable$run(string, string2, string3, bl, regimeType, competenceCourseLevel, competenceCourseType, string4, executionSemester, string5)));
    }

    static /* synthetic */ CompetenceCourse advised$run(String name, String nameEn, String acronym, Boolean basic, RegimeType regimeType, CompetenceCourseLevel competenceCourseLevel, CompetenceCourseType type, String unitID, ExecutionSemester startSemester, String code) throws FenixServiceException {
        AccessControl.check(RolePredicates.BOLONHA_MANAGER_PREDICATE);
        CompetenceCourseGroupUnit unit = (CompetenceCourseGroupUnit)FenixFramework.getDomainObject((String)unitID);
        if (unit == null) {
            throw new FenixServiceException("error.invalidUnit");
        }
        CreateCompetenceCourse.checkIfCanCreateCompetenceCourse(name.trim(), nameEn.trim());
        CompetenceCourse competenceCourse = new CompetenceCourse(name, nameEn, basic, regimeType, competenceCourseLevel, type, CurricularStage.DRAFT, unit, startSemester);
        competenceCourse.setCode(code);
        return competenceCourse;
    }

    private static void checkIfCanCreateCompetenceCourse(String name, String nameEn) throws FenixServiceException {
        String normalizedName = StringFormatter.normalize(name);
        String normalizedNameEn = StringFormatter.normalize(nameEn);
        for (CompetenceCourse competenceCourse : CompetenceCourse.readBolonhaCompetenceCourses()) {
            if (StringFormatter.normalize(competenceCourse.getName()) != null && StringFormatter.normalize(competenceCourse.getName()).equals(normalizedName)) {
                throw new ExistingCompetenceCourseInformationException("error.existingCompetenceCourseWithSameName", competenceCourse.getDepartmentUnit().getName());
            }
            if (StringFormatter.normalize(competenceCourse.getNameEn()) == null || !StringFormatter.normalize(competenceCourse.getNameEn()).equals(normalizedNameEn)) continue;
            throw new ExistingCompetenceCourseInformationException("error.existingCompetenceCourseWithSameNameEn", competenceCourse.getDepartmentUnit().getName());
        }
    }
}

